/*
**	ssh.h	-- ssh client header file.
**
**	Copyright 1997,1998 Tadayoshi Kohno.  All rights reserved.
**	See the LICENSE file.
**
**	I'd like to site my most major reference, the Internet Draft
**	by T. Ylonen (ylo@ssh.fi) for the SSH Protocol version 1.5.
**
**		draft-ylonen-ssh-protocol-00.txt, 15 November 1997
**
**	This reference describes the protocol in great detail and I referenced
**	it for almost all the functions I wrote (which is natural because
**	I tried to follow the standard :).
**
**	I made extensive use of Eric Young's SSLeay libraries.
**	Although I give additional referece to him the the README.txt,
**	I'd like to state that this product includes cryptographic
**	software written by Eric Young (eay@cryptsoft.com).
*/

#ifndef __SSH_H
#define __SSH_H

/*
**	Include major debugging and error stuff
*/
#include "ssh_debug.h"
#include "ssh_errno.h"

/*
**	Lets try to have a universal types system
*/
#include "ssh_types.h"

/*
**	Include appropriate header files for encryption
*/
#include "ssh_msg.h"		/* ssh message types */
#include "ssh_crypt.h"		/* ssh encryption types */
#include "ssh_auth.h"		/* ssh authentication modes */

/*
**	I know this is getting kind of circular, but let's include
**	all our mini include files -- include these in our final release
*/
#define SSH_PRODUCTION

#ifdef SSH_PRODUCTION
#include "ssh_cmsg.h"
#include "ssh_smsg.h"
#include "ssh_comm.h"
#include "ssh_connect.h"
#include "ssh_packet.h"
#include "ssh_prepare.h"
#include "ssh_presetup.h"
#include "ssh_proto.h"
#include "ssh_ident.h"
#include "ssh_misc.h"
#include "ssh_random.h"
#include "ssh_compress.h"
#include "ssh_final.h"
#endif

#define LIBSSH_VERSION_MAJOR	0		/* major version of libSSH */
#define LIBSSH_VERSION_MIDDLE	0		/* middle version of libSSH */
#define LIBSSH_VERSION_MINOR	1		/* minor version of libSSH */

/*
**	What protocol do we currently conform with?  (1.5)
*/
#define SSH_PROTO_HEAD		"SSH"		/* Head of protocol */
#define SSH_PROTO_MAJOR		1		/* Major version of 1 */
#define SSH_PROTO_MINOR		5		/* Minor version of 5 */

/*
**	General SSH stuff
*/
#define SSH_SESSION_ID_SIZE	16		/* bytes for session id */
#define SSH_SESSION_KEY_SIZE	32		/* bytes for session key */

#define SSH_COOKIE_SIZE		8		/* bytes for cookie */

#define SSH_DEFAULT_CIPHER	SSH_CIPHER_3DES	/* default cipher */

#define SSH_PORT		22		/* default SSH port */

/*
**	Now some general stuff
*/
#define STR_MISC_LEN		1000		/* misc length string (badxxx)*/
#define SR_FLAGS		0		/* send/recv flags */

#endif	/* __SSH_H */

