/*
**	ssh_packet.h	-- packet stuff (pack and unpack)
**
**	Copyright 1997, 1998 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_PACKET_H
#define __SSH_PACKET_H

#include "ssh_types.h"

#define SSH_PACKET_LENGTH_LEN	sizeof(uint32_t)	/* bytes for length */
#define SSH_PACKET_CRC_LEN	sizeof(uint32_t)	/* bytes for CRC */
#define SSH_UNITS		8		/* units for packets */
#define SSH_DATA_LEN_DIFF	5		/* length & data diff */
#define SSH_DATA_BLOCK_LEN_DIFF	4		/* length & data/type diff */
#define SSH_TYPE_LEN		1		/* one byte for type */

#ifdef __cplusplus
extern "C" {
#endif

/*
**	functions to pack and unpack a message
*/
int ssh_packet_unpack(struct ssh_struct * ssh_info, const uint8_t * packet,
	uint32_t * data_len, uint8_t * type, uint8_t * data,
	uint32_t out_size);

int ssh_packet_pack(struct ssh_struct * ssh_info, uint8_t * packet,
	uint32_t * total_len, uint8_t type, const uint8_t * data,
	uint32_t data_len, uint32_t out_size);

/*
**	new functions to pack and unpack a message.  this take a
**	"mondo data" block of type and data.
*/
int ssh_packet_unpack_block(struct ssh_struct * ssh_info,
	const uint8_t * packet,
	uint32_t * block_len, uint8_t * block, uint32_t out_size);

int ssh_packet_pack_block(struct ssh_struct * ssh_info, uint8_t * packet,
	uint32_t * total_len, const uint8_t * block, uint32_t block_len,
	uint32_t out_size);

/*
**	functions to glom/extract packet type with content
*/
int ssh_packet_block_glom(uint8_t * output, uint32_t * output_len,
	uint8_t type, const uint8_t * data, uint32_t data_len,
	uint32_t out_size);

int ssh_packet_block_extract(uint8_t * type, uint8_t * data,
	uint32_t * data_len, const uint8_t * input, uint32_t input_len,
	uint32_t data_size);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_PACKET_H */

