#ifndef EC_INCL_EINFO_H
#define EC_INCL_EINFO_H
/* beginning of einfo.h */


	/* ecashlib public headers */
#include "einfo.fh"

#include "eaccid.fh"
#include "emintid.fh"
#include "eaddr.fh"
#include "eamount.fh"
#include "eaccstat.fh"
#include "eerrno.fh"
#include "ecoinage.fh"


	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "einfo.ih"
#endif




	/* EC_Info functions */


/* 
 * Note the lack of a public "EC_info_new()" function.  Instead use
 * EC_pocket_get_info() or EC_acth_get_info().
 */


/*
 * Free account information structure. 
 *
 * return values:
 *	standard EC_Errno
 */
EC_EXPORT EC_Errno EC_info_free(EC_Info *this_info_ptr);

/*
 * Get the account ID.
 *
 * return values:
 *	pointer to the EC_AccountID on success, NULL on failure
 */
EC_EXPORT EC_AccountID *EC_info_get_accID(const EC_Info *this_info_lnk);

/*
 * Get the account info.
 *
 * return values:
 *	NULL-terminated string containing the account info on success,
 *		NULL Char pointer on failure
 */
EC_EXPORT Char *EC_info_get_account_info(const EC_Info *this_info_lnk);

/*
 * Get the account status.
 *
 * return values:
 *	EC_AccountStatus on success, undefined on failure
 */
EC_EXPORT EC_AccountStatus EC_info_get_acct_status(const EC_Info *this_info_lnk);

/*
 * Get the mint ID.
 *
 * return values:
 *	EC_MintID on success, undefined on failure
 */
EC_EXPORT EC_MintID EC_info_get_mintID(const EC_Info *this_info_lnk);

/*
 * Get the mint info.
 *
 * return values:
 *	NULL-terminated string containing the mint info on success, NULL Char
 *		pointer on failure
 */
EC_EXPORT Char *EC_info_get_mint_info(const EC_Info *this_info_lnk);

/*
 * Get the mint address.
 *
 * return values:
 *	pointer to the EC_Address on success, NULL pointer on failure
 */
EC_EXPORT EC_Address *EC_info_get_mint_addr(const EC_Info *this_info_lnk);

/*
 * Get the coinage for this account.
 *
 * return values:
 *	pointer to the EC_Coinage on success, NULL pointer on failure
 */
EC_EXPORT EC_Coinage *EC_info_get_coinage(const EC_Info *this_info_lnk);

/*
 * Get the amount in cash for this account.
 *
 * return values:
 *	EC_Amount on success, undefined on failure
 */
EC_EXPORT EC_Amount EC_info_get_cash(const EC_Info *this_info_lnk);

/*
 * Get the amount stored at the mint for this account.
 *
 * return values:
 *	EC_Amount on success, undefined on failure
 */
EC_EXPORT EC_Amount EC_info_get_balance(const EC_Info *this_info_lnk);

/*
 * Get the amount in expired cash for this account.
 *
 * return values:
 *	EC_Amount on success, undefined on failure
 */
EC_EXPORT EC_Amount EC_info_get_exp_cash(const EC_Info *this_info_lnk);

/*
 * Get the number of payments guaranteed to be payable using the
 * current coins.
 *
 * return values:
 *	minimum guaranteed payments on success, 
 *		EC_MINPAYMENTS_INVALID on failure
 */
EC_EXPORT UInt16 EC_info_get_min_payments(const EC_Info *this_info_lnk);

/*
 * Get the recovery string used to recover this pocket's lost
 * coins in the case of a disaster.
 *
 * return values:
 *	the recovery string on success, NULL pointer on failure
 *
 * notes:
 *	The recovery_str member of an EC_Info is only valid after a 
 *	successful call to this EC_Pocket's EC_pocket_new() and before this 
 *	EC_Pocket leaves memory-- the recovery_str is not stored in this 
 *	EC_Pocket's persistent storage!  Whenever the recovery_str member 
 *	is invalid it is set to a NULL pointer.
 */
EC_EXPORT Char *EC_info_get_recovery_string(const EC_Info *this_info_lnk);


/* end of einfo.h */
#endif

