/* NASA's interface, with extensions */

#define FTPNAMESIZE 80
#define FTPCMDSIZE (FTPNAMESIZE+6)

   /* This structure defines the ftp fd handle.  */
struct ftpHandle {
       char host[FTPNAMESIZE];     /* name of server host.             */
       char user[FTPNAMESIZE];     /* user name for host login.        */
       char passWd[FTPNAMESIZE];   /* password for host login.         */
       char acct[FTPNAMESIZE];     /* account for host login.          */
       char cmd[FTPCMDSIZE];       /* command to send to host.         */
       char dirname[FTPNAMESIZE];  /* directory to 'cd' to before sending command. */
       char filename[FTPNAMESIZE]; /* file name to send with command.  */
       int pCtrlSock;              /* where to return control socket fd. */
       int pDataSock;              /* where to rreturn data socket fd, */
                                   /* (null = dont't open data connection). */
       void *secure_data;
     };

struct ftpHandle *
openFtp(char *tgtHost,		/* connect to  */
	char *usrName,		/* ftp "user" (also kerberos user) */
	char *passWd,		/* password  */
	char *acct,		/* account name */
	int cmd,		/* O_RDONLY == RETR, O_WRONLY == STOR */
	char *dirName,		/* directory target */
	char *fName		/* file name to store */
	);
int writeFtp (struct ftpHandle *handle, char *buffer, size_t nBytes);
int readFtp(struct ftpHandle* f, char *buffer, size_t maxbytes);
int closeFtp(struct ftpHandle* f);
extern int ftpverbose, ftpdebug;
