# ASK QUESTION VALIDATION_PROC ?DEFAULT?
proc ask_varargs { q validate arglist } {
    set args $arglist
    if [llength $args]==0 {
	set have_default 0
    } elseif [llength $args]==1 {
	set have_default 1
	set default [lindex $args 0]
	if ![string compare "" $default] { set have_default 0 }
    } else {
	error "wrong # args: should be \"ask prompt validate-proc ?default?\""
    }
    while 1 {
	puts -nonewline "$q "
	if $have_default { puts -nonewline "\[$default\] " }
	flush stdout
	if -1==[gets stdin answer] { exit 1 }
	set answer [string trim $answer]
	if "$have_default && ![string compare {} $answer]" {
	    set answer $default
	}
	if ![string length $validate] { return $answer }
	if [$validate $answer] { return $answer }
    }
}
proc ask { q validate args } { ask_varargs $q $validate $args }

proc pause { } {
    ask "Hit Return or Enter to continue>" {}
}

proc v.realm { r } {
    if ![regexp -nocase {^[a-z0-9.-]+$} $r] {
	puts "Invalid characters found in realm name \"$r\".  Please"
	puts "enter a valid realm name."
	puts ""
	return 0
    }
    return 1
}
proc ask_realm { q args } { ask_varargs $q v.realm $args }

proc v.yes-no { ans } {
    switch [string range $ans 0 0] {
	"y" -
	"Y" -
	"n" -
	"N" { return 1 }
    }
    puts "Please answer yes or no."
    return 0
}

proc ask-yesno { q args } {
    switch [string range $args 0 0] {
	""  {}
	"y" -
	"Y" { set args yes }
	"n" -
	"N" { set args no }
    }
    set ans [ask_varargs $q v.yes-no $args]
    switch [string range $ans 0 0] {
	"y" -
	"Y" { return 1 }
	"n" -
	"N" { return 0 }
    }
    error "bad return value from 'ask'"
}

proc v.hostname-or-addr { h } {
    set is_ok 0
    if ![regexp -nocase {^[a-z0-9_./-]+$} $h] {
	puts "Invalid characters found in host name \"$h\".  Please"
	puts "enter a valid host name."
	return 0
    }
    catch {krb5tcl_canonicalize_hostname $h ; set is_ok 1} err
    if $is_ok { return 1 }
    # Here only if caught an error.
    if [ask-yesno "$err (\"$h\") -- use it anyways?" y] {
	return 1
    } else {
	return 0
    }
}
proc v.kdcaddr { h } {
    # if colon form is used, it must be followed by exactly one port number
    set x [split $h ":"]
    if [llength $x]<1||[llength $x]>2 {
	puts "Hostname or hostname:portnumber combination required."
	return 0
    }
    if [v.hostname-or-addr [lindex $x 0]]==0 { return 0 }
    if [llength $x]==1 { return 1 }
    set port [lindex $x 1]
    if ![regexp "^\[0-9\]\[0-9\]*$" $port] {
	puts "Port specification must consist of exactly one number."
	return 0
    }
    if "$port < 1 || $port > 65535" {
	puts "Port number $port outside range 1..65535."
	return 0
    }
    return 1
}
proc v.hostname-addr-or-empty { h } {
    if ![string compare $h ""] { return 1 }
    v.hostname-or-addr $h
}
proc v.kdcaddr-or-empty { h } {
    if ![string compare $h ""] { return 1 }
    v.kdcaddr $h
}
proc ask_hostname { q args } { ask_varargs $q v.hostname-or-addr $args }
proc ask_maybe_hostname { q args } {
    ask_varargs $q v.hostname-addr-or-empty $args
}

proc askpw { prompt1 { prompt2 "" } } {

    if ![string compare $prompt2 ""] {
	set prompt2 "Verifying: $prompt1"
    }

    set err ""
    set ok 0
    set result ""
    while {!$ok} {
	catch {
	    set result [krb5tcl_read_password "$prompt1 " "$prompt2 "]
	    set ok 1
	} err
	if $ok {
	    return $result
	} else {
	    if ![string compare "Password mismatch" $err] {
		puts "Password mismatch; please try again.\n"
	    } else {
		error $err
	    }
	}
    }
}

