/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/kadmin/passwd/tty_kpasswd.c,v 1.6 1996/07/22 20:28:13 marc Exp $
 *
 *
 */

static char rcsid[] = "$Id: tty_kpasswd.c,v 1.6 1996/07/22 20:28:13 marc Exp $";

#include <kadm5/admin.h>
#include <krb5.h>

#include "kpasswd_strings.h"
#define string_text error_message
#define initialize_kpasswd_strings initialize_kpws_error_table

#include <stdio.h>
#include <pwd.h>
#include <string.h>

char *whoami;

void display_intro_message(fmt_string, arg_string)
     char *fmt_string;
     char *arg_string;
{
  com_err(whoami, 0, fmt_string, arg_string);
}

long read_old_password(context, password, pwsize)
     krb5_context context;
     char *password;
     int *pwsize;
{
  long code = krb5_read_password(context,
			 (char *)string_text(KPW_STR_OLD_PASSWORD_PROMPT),  
			 0, password, pwsize);
  return code;
}

long read_new_password(server_handle, password, pwsize, msg_ret, princ)
     void *server_handle;
     char *password;
     int *pwsize;
     char *msg_ret;
     krb5_principal princ;
{
  return (ovsec_kadm_chpass_principal_util(server_handle, princ, NULL, 
					   NULL /* don't need new pw back */,
					   msg_ret));
}


/*
 * main() for tty version of kpasswd.c
 */
int
main(argc, argv)
     int argc;
     char *argv[];
{
  krb5_context context;
  int retval;

  initialize_kpasswd_strings();

  whoami = (whoami = strrchr(argv[0], '/')) ? whoami + 1 : argv[0];

  if (retval = krb5_init_context(&context)) {
       com_err(whoami, retval, "initializing krb5 context");
       exit(retval);
  }
  retval = kpasswd(context, argc, argv);

  if (!retval)
    printf(string_text(KPW_STR_PASSWORD_CHANGED));

  exit(retval);
}
