/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "gssapiP_krb5.h"

OM_uint32
krb5_gss_inquire_cred(minor_status, cred_handle, name, lifetime_ret,
		      cred_usage, mechanisms)
     OM_uint32 *minor_status;
     gss_cred_id_t cred_handle;
     gss_name_t *name;
     OM_uint32 *lifetime_ret;
     gss_cred_usage_t *cred_usage;
     gss_OID_set *mechanisms;
{
   krb5_context context;
   krb5_gss_cred_id_t cred;
   krb5_error_code code;
   krb5_timestamp now;
   krb5_deltat lifetime;
   krb5_principal ret_name;
   gss_OID_set mechs;

   if (GSS_ERROR(kg_get_context(minor_status, &context)))
      return(GSS_S_FAILURE);

   if (name) *name = NULL;
   if (mechanisms) *mechanisms = NULL;

   /* check for default credential */
   /*SUPPRESS 29*/
   if (cred_handle == GSS_C_NO_CREDENTIAL) {
      OM_uint32 major;

      if ((major = kg_get_defcred(minor_status, &cred_handle)) &&
	  GSS_ERROR(major)) {
	 return(major);
      }
   } else {
      if (! kg_validate_cred_id(cred_handle)) {
	 *minor_status = (OM_uint32) G_VALIDATE_FAILED;
	 return(GSS_S_CALL_BAD_STRUCTURE|GSS_S_NO_CRED);
      }
   }

   cred = (krb5_gss_cred_id_t) cred_handle;

   if (code = krb5_timeofday(context, &now)) {
      *minor_status = code;
      return(GSS_S_FAILURE);
   }

   if (cred->tgt_expire > 0) {
       if ((lifetime = cred->tgt_expire - now) < 0)
	   lifetime = 0;
   }
   else
       lifetime = GSS_C_INDEFINITE;

   if (name) {
      if (code = krb5_copy_principal(context, cred->princ, &ret_name)) {
	 *minor_status = code;
	 return(GSS_S_FAILURE);
      }
   }

   if (mechanisms)
      if (! g_copy_OID_set(cred->actual_mechs, &mechs)) {
	 krb5_free_principal(context, ret_name);
	 *minor_status = ENOMEM;
	 return(GSS_S_FAILURE);
      }

   if (name) {
      if (! kg_save_name((gss_name_t) ret_name)) {
	 (void) gss_release_oid_set(minor_status, &mechs);
	 krb5_free_principal(context, ret_name);
	 *minor_status = (OM_uint32) G_VALIDATE_FAILED;
	 return(GSS_S_FAILURE);
      }
      *name = (gss_name_t) ret_name;
   }

   if (lifetime_ret)
      *lifetime_ret = lifetime;

   if (cred_usage)
      *cred_usage = cred->usage;

   if (mechanisms)
      *mechanisms = mechs;

   *minor_status = 0;
   return((lifetime == 0)?GSS_S_CREDENTIALS_EXPIRED:GSS_S_COMPLETE);
}

/* V2 interface */
OM_uint32
krb5_gss_inquire_cred_by_mech(minor_status, cred_handle,
			      mech_type, name, initiator_lifetime,
			      acceptor_lifetime, cred_usage)
    OM_uint32		*minor_status;
    gss_cred_id_t	cred_handle;
    gss_OID		mech_type;
    gss_name_t		*name;
    OM_uint32		*initiator_lifetime;
    OM_uint32		*acceptor_lifetime;
    gss_cred_usage_t *cred_usage;
{
    krb5_context	context;
    krb5_gss_cred_id_t	cred;
    OM_uint32		lifetime;
    OM_uint32		mstat;

    if (GSS_ERROR(kg_get_context(minor_status, &context)))
       return(GSS_S_FAILURE);

    /*
     * We only know how to handle our own creds.
     */
    if ((mech_type != GSS_C_NULL_OID) &&
	!g_OID_equal(gss_mech_krb5, mech_type)) {
	*minor_status = 0;
	return(GSS_S_NO_CRED);
    }

    cred = (krb5_gss_cred_id_t) cred_handle;
    mstat = krb5_gss_inquire_cred(minor_status,
				  cred_handle,
				  name,
				  &lifetime,
				  cred_usage,
				  (gss_OID_set *) NULL);
    if (mstat == GSS_S_COMPLETE) {
	if (cred &&
	    ((cred->usage == GSS_C_INITIATE) ||
	     (cred->usage == GSS_C_BOTH)) &&
	    initiator_lifetime)
	    *initiator_lifetime = lifetime;
	if (cred &&
	    ((cred->usage == GSS_C_ACCEPT) ||
	     (cred->usage == GSS_C_BOTH)) &&
	    acceptor_lifetime)
	    *acceptor_lifetime = lifetime;
    }
    return(mstat);
}

