/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "gssapiP_krb5.h"
#include <memory.h>

/*
 * $Id: util_crypt.c,v 1.9 1996/07/22 20:34:40 marc Exp $
 */

static unsigned char zeros[8] = {0,0,0,0,0,0,0,0};

int
kg_confounder_size(ed)
     krb5_gss_enc_desc *ed;
{
   /* XXX Is this an abstraction violation? */

   return(ed->eblock.crypto_entry->block_length);
}

krb5_error_code
kg_make_confounder(ed, buf)
     krb5_gss_enc_desc *ed;
     unsigned char *buf;
{
   return(krb5_random_confounder(ed->eblock.crypto_entry->block_length, buf));
}

int
kg_encrypt_size(ed, n)
     krb5_gss_enc_desc *ed;
     int n;
{
   return(krb5_encrypt_size(n, ed->eblock.crypto_entry));
}

krb5_error_code
kg_encrypt(context, ed, iv, in, out, length)
     krb5_context context;
     krb5_gss_enc_desc *ed;
     krb5_pointer iv;
     krb5_pointer in;
     krb5_pointer out;
     int length;
{
   krb5_error_code code;
   krb5_pointer tmp;

   if (! ed->processed) {
      if (code = krb5_process_key(context, &ed->eblock, ed->key))
	 return(code);
      ed->processed = 1;
   }

   /* this is lame.  the krb5 encryption interfaces no longer allow
      you to encrypt in place.  perhaps this should be fixed, but
      dealing here is easier for now --marc */

   if ((tmp = (krb5_pointer) xmalloc(length)) == NULL)
      return(ENOMEM);

   memcpy(tmp, in, length);

   code = krb5_encrypt(context, tmp, out, length, &ed->eblock, 
		       iv?iv:(krb5_pointer)zeros);

   xfree(tmp);

   if (code)
      return(code);

   return(0);
}

/* length is the length of the cleartext. */

krb5_error_code
kg_decrypt(context, ed, iv, in, out, length)
     krb5_context context;
     krb5_gss_enc_desc *ed;
     krb5_pointer iv;
     krb5_pointer in;
     krb5_pointer out;
     int length;
{
   krb5_error_code code;
   int elen;
   char *buf;

   if (! ed->processed) {
      if (code = krb5_process_key(context, &ed->eblock, ed->key))
	 return(code);
      ed->processed = 1;
   }

   elen = krb5_encrypt_size(length, ed->eblock.crypto_entry);
   if ((buf = (char *) xmalloc(elen)) == NULL)
      return(ENOMEM);

   if (code = krb5_decrypt(context, in, buf, elen, &ed->eblock, 
			   iv?iv:(krb5_pointer)zeros)) {
      xfree(buf);
      return(code);
   }

   memcpy(out, buf, length);
   xfree(buf);

   return(0);
}
