/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/admin_internal.h,v 1.13 1996/07/25 22:06:39 tytso Exp $
 */

#ifndef __KADM5_ADMIN_INTERNAL_H__
#define __KADM5_ADMIN_INTERNAL_H__

#include <kadm5/admin.h>

#define KADM5_SERVER_HANDLE_MAGIC	0x12345800

#define GENERIC_CHECK_HANDLE(handle, old_api_version, new_api_version) \
{ \
	kadm5_server_handle_t srvr = \
	     (kadm5_server_handle_t) handle; \
 \
	if (! srvr) \
		return KADM5_BAD_SERVER_HANDLE; \
	if (srvr->magic_number != KADM5_SERVER_HANDLE_MAGIC) \
		return KADM5_BAD_SERVER_HANDLE; \
	if ((srvr->struct_version & KADM5_MASK_BITS) != \
	    KADM5_STRUCT_VERSION_MASK) \
		return KADM5_BAD_STRUCT_VERSION; \
	if (srvr->struct_version < KADM5_STRUCT_VERSION_1) \
		return KADM5_OLD_STRUCT_VERSION; \
	if (srvr->struct_version > KADM5_STRUCT_VERSION_1) \
		return KADM5_NEW_STRUCT_VERSION; \
	if ((srvr->api_version & KADM5_MASK_BITS) != \
	    KADM5_API_VERSION_MASK) \
		return KADM5_BAD_API_VERSION; \
	if (srvr->api_version < KADM5_API_VERSION_1) \
		return old_api_version; \
	if (srvr->api_version > KADM5_API_VERSION_2) \
		return new_api_version; \
}

/*
 * _KADM5_CHECK_HANDLE calls the function _kadm5_check_handle and
 * returns any non-zero error code that function returns.
 * _kadm5_check_handle, in client_handle.c and server_handle.c, exists
 * in both the server- and client- side libraries.  In each library,
 * it calls CHECK_HANDLE, which is defined by the appropriate
 * _internal.h header file to call GENERIC_CHECK_HANDLE as well as
 * CLIENT_CHECK_HANDLE and SERVER_CHECK_HANDLE.
 *
 * _KADM5_CHECK_HANDLE should be used by a function that needs to
 * check the handle but wants to be the same code in both the client
 * and server library; it makes a function call to the right handle
 * checker.  Code that only exists in one library can call the
 * CHECK_HANDLE macro, which inlines the test instead of making
 * another function call.
 *
 * Got that?
 */
#define _KADM5_CHECK_HANDLE(handle) \
{ int code; if ((code = _kadm5_check_handle((void *)handle))) return code; }

kadm5_ret_t _kadm5_chpass_principal_util(void *server_handle,
					 void *lhandle,
					 krb5_principal princ,
					 char *new_pw, 
					 char **ret_pw,
					 char *msg_ret);

/* this is needed by the alt_prof code I stole.  The functions
   maybe shouldn't be named krb5_*, but they are. */

krb5_error_code
krb5_string_to_keysalts(char *string, const char *tupleseps,
			const char *ksaltseps, krb5_boolean dups,
			krb5_key_salt_tuple **ksaltp, krb5_int32 *nksaltp);

krb5_error_code
krb5_string_to_flags(char* string, const char* positive, const char* negative,
		     krb5_flags *flagsp);

#endif /* __KADM5_ADMIN_INTERNAL_H__ */
