/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/clnt/client_principal.c,v 1.1 1996/07/24 22:22:43 tlyu Exp $
 */

#if !defined(lint) && !defined(__CODECENTER__)
static char *rcsid = "$Header: /afs/athena.mit.edu/astaff/project/krbdev/.cvsroot/src/lib/kadm5/clnt/client_principal.c,v 1.1 1996/07/24 22:22:43 tlyu Exp $";
#endif

#include    <rpc/rpc.h>
#include    <kadm5/admin.h>
#include    <kadm5/kadm_rpc.h>
#include    <memory.h>
#include    "client_internal.h"

kadm5_ret_t
kadm5_create_principal(void *server_handle,
			    kadm5_principal_ent_t princ, long mask,
			    char *pw)
{
    generic_ret		*r;
    cprinc_arg		arg;
    kadm5_server_handle_t handle = server_handle;

    CHECK_HANDLE(server_handle);

    arg.mask = mask;
    arg.passwd = pw;
    arg.api_version = handle->api_version;

    if(princ == NULL)
	return EINVAL;
    memcpy(&arg.rec, princ, sizeof(kadm5_principal_ent_rec));
    if (handle->api_version == KADM5_API_VERSION_1) {
	 /*
	  * hack hack cough cough.
	  * krb5_unparse name dumps core if we pass it in garbage
	  * or null. So, since the client is not allowed to set mod_name
	  * anyway, we just fill it in with a dummy principal. The server of
	  * course ignores this.
	  */
	 krb5_parse_name(handle->context, "bogus/bogus", &arg.rec.mod_name);
    } else
	 arg.rec.mod_name = NULL;
    
    if(!(mask & KADM5_POLICY))
	arg.rec.policy = NULL;
    if (! (mask & KADM5_KEY_DATA)) {
	 arg.rec.n_key_data = 0;
	 arg.rec.key_data = NULL;
    }
    if (! (mask & KADM5_TL_DATA)) {
	 arg.rec.n_tl_data = 0;
	 arg.rec.tl_data = NULL;
    }
	 
    r = create_principal_1(&arg, handle->clnt);

    if (handle->api_version == KADM5_API_VERSION_1)
	 krb5_free_principal(handle->context, arg.rec.mod_name);

    if(r == NULL)
	return KADM5_RPC_ERROR;
    return r->code;
}

kadm5_ret_t
kadm5_delete_principal(void *server_handle, krb5_principal principal)
{
    dprinc_arg		arg;
    generic_ret		*r;
    kadm5_server_handle_t handle = server_handle;

    CHECK_HANDLE(server_handle);

    if(principal == NULL)
	return EINVAL;
    arg.princ = principal;
    arg.api_version = handle->api_version;
    r = delete_principal_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;    
    return r->code;
}

kadm5_ret_t
kadm5_modify_principal(void *server_handle,
			    kadm5_principal_ent_t princ, long mask)
{
    mprinc_arg		arg;
    generic_ret		*r;
    kadm5_server_handle_t handle = server_handle;

    CHECK_HANDLE(server_handle);

    arg.mask = mask;
    arg.api_version = handle->api_version;
    /*
     * cough cough gag gag
     * see comment in create_principal.
     */
    if(princ == NULL)
	return EINVAL;
    memcpy(&arg.rec, princ, sizeof(kadm5_principal_ent_rec));
    if(!(mask & KADM5_POLICY))
	arg.rec.policy = NULL;
    if (! (mask & KADM5_KEY_DATA)) {
	 arg.rec.n_key_data = 0;
	 arg.rec.key_data = NULL;
    }
    if (! (mask & KADM5_TL_DATA)) {
	 arg.rec.n_tl_data = 0;
	 arg.rec.tl_data = NULL;
    }

    if (handle->api_version == KADM5_API_VERSION_1) {
	 /*
	  * See comment in create_principal
	  */
	 krb5_parse_name(handle->context, "bogus/bogus", &arg.rec.mod_name);
    } else
	 arg.rec.mod_name = NULL;
    
    r = modify_principal_1(&arg, handle->clnt);

    if (handle->api_version == KADM5_API_VERSION_1)
	 krb5_free_principal(handle->context, arg.rec.mod_name);    

    if(r == NULL)
	return KADM5_RPC_ERROR;    
    return r->code;
}

kadm5_ret_t
kadm5_get_principal(void *server_handle,
		    krb5_principal princ, kadm5_principal_ent_t ent,
		    long mask)
{
    gprinc_arg	arg;
    gprinc_ret	*r;
    kadm5_server_handle_t handle = server_handle;
    krb5_error_code retval;

    CHECK_HANDLE(server_handle);

    if(princ == NULL)
	return EINVAL;
    arg.princ = princ;
    if (handle->api_version == KADM5_API_VERSION_1)
       arg.mask = KADM5_PRINCIPAL_NORMAL_MASK;
    else
       arg.mask = mask;
    arg.api_version = handle->api_version;
    r = get_principal_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;
    if (handle->api_version == KADM5_API_VERSION_1) {
	 kadm5_principal_ent_t_v1 *entp;

	 entp = (kadm5_principal_ent_t_v1 *) ent;
	 if (r->code == 0) {
	      if (!(*entp = (kadm5_principal_ent_t_v1)
		    malloc(sizeof(kadm5_principal_ent_rec_v1))))
		   return ENOMEM;
	      /* this memcpy works because the v1 structure is an initial
		 subset of the v2 struct.  C guarantees that this will
		 result in the same layout in memory */
	      memcpy(*entp, &r->rec, sizeof(**entp));
	 } else {
	    *entp = NULL;
	 }
    } else {
	 if (r->code == 0)
	      memcpy(ent, &r->rec, sizeof(r->rec));
    }
    
    return r->code;
}

kadm5_ret_t
kadm5_get_principals(void *server_handle,
			  char *exp, char ***princs, int *count)
{
    gprincs_arg	arg;
    gprincs_ret	*r;
    kadm5_server_handle_t handle = server_handle;
    krb5_error_code retval;

    CHECK_HANDLE(server_handle);

    if(princs == NULL || count == NULL)
	return EINVAL;
    arg.exp = exp;
    arg.api_version = handle->api_version;
    r = get_princs_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;
    if(r->code == 0) {
	 *count = r->count;
	 *princs = r->princs;
    } else {
	 *count = 0;
	 *princs = NULL;
    }
    
    return r->code;
}

kadm5_ret_t
kadm5_get_next_principals(void *server_handle,
			  char *start_princ, char ***princs, int *count)
{
    gnprincs_arg	arg;
    gnprincs_ret	*r;
    kadm5_server_handle_t handle = server_handle;
    krb5_error_code retval;

    CHECK_HANDLE(server_handle);

    if(princs == NULL || count == NULL || *count == 0)
	return EINVAL;
    arg.startprinc = start_princ;
    arg.count = *count;
    arg.api_version = handle->api_version;
    r = get_next_princs_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;
    if(r->code == 0) {
	 *count = r->count;
	 *princs = r->princs;
    } else {
	 *count = 0;
	 *princs = NULL;
    }
    
    return r->code;
}

kadm5_ret_t
kadm5_rename_principal(void *server_handle,
			    krb5_principal source, krb5_principal dest)
{
    rprinc_arg		arg;
    generic_ret		*r;
    kadm5_server_handle_t handle = server_handle;

    CHECK_HANDLE(server_handle);

    arg.src = source;
    arg.dest = dest;
    arg.api_version = handle->api_version;
    if (source == NULL || dest == NULL)
	return EINVAL;
    r = rename_principal_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;        
    return r->code;
}

kadm5_ret_t
kadm5_chpass_principal(void *server_handle,
			    krb5_principal princ, char *password)
{
    chpass_arg		arg;
    generic_ret		*r;
    kadm5_server_handle_t handle = server_handle;

    CHECK_HANDLE(server_handle);

    arg.princ = princ;
    arg.pass = password;
    arg.api_version = handle->api_version;

    if(princ == NULL)
	return EINVAL;
    r = chpass_principal_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;        
    return r->code;
}

kadm5_ret_t
kadm5_randkey_principal(void *server_handle,
			krb5_principal princ,
			krb5_keyblock **key, int *n_keys)
{
    chrand_arg		arg;
    chrand_ret		*r;
    krb5_keyblock	new;
    kadm5_server_handle_t handle = server_handle;
    int			i, ret;

    CHECK_HANDLE(server_handle);

    arg.princ = princ;
    arg.api_version = handle->api_version;

    if(princ == NULL)
	return EINVAL;
    r = chrand_principal_1(&arg, handle->clnt);
    if(r == NULL)
	return KADM5_RPC_ERROR;
    if (handle->api_version == KADM5_API_VERSION_1) {
	 if (key)
	      krb5_copy_keyblock(handle->context, &r->key, key);
    } else {
	 if (n_keys)
	      *n_keys = r->n_keys;
	 if (key) {
	      *key = (krb5_keyblock *) malloc(r->n_keys*sizeof(krb5_keyblock));
	      if (*key == NULL)
		   return ENOMEM;
	      for (i = 0; i < r->n_keys; i++) {
		   ret = krb5_copy_keyblock_contents(handle->context,
						     &r->keys[i],
						     &(*key)[i]);
		   if (ret) {
			free(*key);
			return ENOMEM;
		   }
	      }
	 }
    }
	 
    return r->code;
}

/* not supported on client side */
kadm5_ret_t kadm5_decrypt_key(void *server_handle,
			      kadm5_principal_ent_t entry, krb5_int32
			      ktype, krb5_int32 stype, krb5_int32
			      kvno, krb5_keyblock *keyblock,
			      krb5_keysalt *keysalt, int *kvnop)
{
     return EINVAL;
}
