/* 	File name:	krb5auth.c

	4/24/96		Raymond Jou		Replace SetUpA4() and RestoreA4(oldA4) with EnterCodeResource() 
									and ExitCodeResource() to get A4 correctly point to global data.  
									In the old way, SetUpA4() just initializes A4 to 0L which 
									does not set up A4 properly. 
									
								Include A4Stuff.h instead of SetupA4.h.
*/

#include <A4Stuff.h>

#include "tnae.h"
#include "encrypt.h"
#include "enc-proto.h"
#include "telnet.h"

#ifndef ENCRYPTION
#define ENCRYPTION
#endif /* ENCRYPTION */

#ifndef KRB5
#define KRB5
#endif /* KRB5 */

#ifndef FORWARD
#define FORWARD
#endif /* FORWARD */

// Following code is based on appl/telnet/libtelnet/kerberos5.c.
#ifdef	FORWARD 

#define KRB_FORWARD     		4       /* Forwarded credentials follow */
#define KRB_FORWARD_ACCEPT     	5       /* Forwarded credentials accepted */
#define KRB_FORWARD_REJECT     	6       /* Forwarded credentials rejected */

#endif	/* FORWARD */
// end appl/telnet/libtelnet/kerberos5.c.

#ifdef KRB5
#	include "k5-int.h"
#	include "com_err.h"
#	include "prof_int.h"
#	include "krb5.h"
#endif
#define KRB_SERVICE_NAME	"host"
#define K5_REJECT			1
#define K5_ACCEPT			2
#define K5_RESPONSE			3		// They had to make it different
#define KSUCCESS    		0
#define KFAILURE    		255

/* per-connection k5 state. can't store this in globals because the user might
   have multiple connections open */
typedef struct k5_tn_auth_data {
	krb5_context k5_context;
	krb5_auth_context auth_context;
	krb5_creds *new_cred;
	krb5_ccache ccache;
	krb5_keyblock *session_key;
	int mutual_complete;
} k5_tn_auth_data;

long	main(long func, char *parameters);
static int 	k5_auth_send (tnParams *tn, int AuthType, int how, char *szHostName);
static int	k5_auth_reply (tnParams *tn, int AuthType, int how, unsigned char *data, int cnt);
void tn_sendsub (tnParams *tn, int code, int request, char *scp, int length);
void tn_sendauthsub (tnParams *tn, int code, int request, int vers, int how, int auth, char *scp, int length);

long
main(long func, char *parameters)
{
	char 		*so;
	char 		pairs[] = {	AUTH_KERBEROS_V5, AUTH_CLIENT_TO_SERVER|AUTH_HOW_MUTUAL,
							AUTH_KERBEROS_V5, AUTH_CLIENT_TO_SERVER|AUTH_HOW_ONE_WAY };
#define NUM_PAIRS 2
	long		err=0;
	char 		strTmp[100];
	tnParams	*tn;
	int			wasDecrypting;

	EnterCodeResource();
		
	switch (func) {
		case TNFUNC_INIT_CODE:
			/*
			 * Initialize this code module.
			 *
			 * parameters: points to area to save type/modifier pairs
			 * returns: the number of pairs entered.
			 */
			memcpy((char *)parameters, pairs, 2*NUM_PAIRS);
 			
			err = NUM_PAIRS;	/* number of pairs of authentication types being supported */

			break;
	
		case TNFUNC_INIT_SESSION_AUTH:
			{
			k5_tn_auth_data *adata;
			
			tn = (tnParams*)parameters;
			
			adata = tn->authdata = (k5_tn_auth_data *)NewPtrClear(sizeof (k5_tn_auth_data));

		    krb5_init_context(&(adata->k5_context));
		    krb5_init_ets(adata->k5_context);
			}
			break;
			
		case TNFUNC_AUTH_SEND:
			{
			char		server[100];
			unsigned char *mypair, *hispair;
			/*
			 * Process [IAC SB] AUTH SEND <type-modifier-list> [IAC SE] sub-option.
			 *
			 */
		
			tn=(tnParams*)parameters;

			/*
			 * For telnet clients, the buffer contains:
			 * AUTHENTICATION SEND type modifier [type modifier] [...] IAC SE
			 * We scan the type/modifier pairs until we find one we can do. 
			 * Since they are are in priority order, the  first one we
			 * find that we can do wins.
			 */
			for(hispair = &tn->subbuffer[SB_TYPE]; hispair < tn->subbuffer+tn->sublength; hispair += 2)
				for(mypair = pairs; mypair < pairs + NUM_PAIRS*2; mypair += 2)
					if((hispair[0] == mypair[0]) && (hispair[1] == mypair[1])) goto found;

			mypair = "\0\0";

		found:
			strcpy(server, tn->cname);
			server[strlen(server) - 1] = 0;	// knock last character (".") off name.
			err = !k5_auth_send(tn, mypair[0], mypair[1], server);
			}
		break;
	
		case TNFUNC_AUTH_REPLY:
			/*
			 * Process an [IAC SB] AUTH REPLY <type-modifier-list> [IAC SE] sub-option.
			 *
			 */
			tn = (tnParams *)parameters;
			so = &tn->subbuffer[SB_TYPE];
			err = !k5_auth_reply(tn, so[0], so[1], tn->subbuffer, tn->sublength);
			break;

#ifdef ENCRYPTION			
		case TNFUNC_INIT_SESSION_ENCRYPT:
			tn = (tnParams *)parameters;
			tn->encryptdata = (k5_tn_enc_data *)NewPtrClear(sizeof (k5_tn_enc_data));
			break;

		case TNFUNC_ENCRYPT_SB:
			tn = (tnParams *)parameters;
			wasDecrypting = tn->decrypting;
			
			switch (tn->subbuffer[1]) {
			case ENCRYPT_SUPPORT:
				encrypt_support(tn, tn->subbuffer+2, tn->sublength-2);
				break;
			case ENCRYPT_START:
				encrypt_start(tn);
				break;
			case ENCRYPT_END:
				encrypt_end(tn);
				break;
			case ENCRYPT_REQSTART:
				encrypt_request_start(tn);
				break;
			case ENCRYPT_REQEND:
				encrypt_request_end(tn);
				break;
			case ENCRYPT_IS:
				encrypt_is(tn, tn->subbuffer+2, tn->sublength-2);
				break;
			case ENCRYPT_REPLY:
				encrypt_reply(tn, tn->subbuffer+2, tn->sublength-2);
				break;
			case ENCRYPT_ENC_KEYID:
				encrypt_enc_keyid(tn, tn->subbuffer+2, tn->sublength-2);
				break;
			case ENCRYPT_DEC_KEYID:
				encrypt_dec_keyid(tn, tn->subbuffer+2, tn->sublength-2);
				break;
			default:
				break;
			}
			if(tn->decrypting && !wasDecrypting) err=TNREP_START_DECRYPT;
			break;
	
		case TNFUNC_DECRYPT:
			{
			k5_tn_enc_data *edata;
			
			tn = (tnParams*)parameters;
			edata = tn->encryptdata;
			
			if(edata->decrypting) tn->data = edata->dp->input(edata->dstate, tn->data);
			
			err = 0;	
			}
			break;
	
		case TNFUNC_ENCRYPT:
			{
			k5_tn_enc_data *edata;
			
			tn = (tnParams*)parameters;
			edata = tn->encryptdata;
			
			if(edata->encrypting) edata->ep->output(edata->estate, tn->ebuf, tn->data);
			
			err = 0;	
			}
			break;

		case TNFUNC_QUERY_ENCRYPT:
			err = 1;	/* RUJ 4/30/96 this will set code->encryptok in loadcode() to true. */
			break;
#else /* ENCRYPTION */
		case TNFUNC_QUERY_ENCRYPT:
			err = 0;
			break;
#endif /* ENCRYPTION */
	
		default:
			err = TNREP_ERROR;
	}
	ExitCodeResource();
	return err;
}

/*
** 
** K5_auth_send - gets authentication bits we need to send to KDC.
** 
** Code lifted from wintel code in the windows directory.)
** (Code lifted from telnet sample code in the appl directory.)
**
** Returns: 0 on failure, 1 on success
** 
*/

static int 
k5_auth_send (tnParams *tn, int AuthType, int how, char *szHostName)
{
	krb5_error_code r;
	krb5_creds cred;
	krb5_flags ap_opts;
    int len;
	char type_check[2];		// RUJ 5/6/96 add for checksum
	krb5_data check_data;	// RUJ 5/6/96 add for checksum
	krb5_data auth;
	k5_tn_auth_data *adata=tn->authdata;
	
#ifdef	ENCRYPTION
	krb5_keyblock *newkey = 0;
#endif	/* ENCRYPTION */

	if (r = krb5_cc_default(adata->k5_context, &(adata->ccache))) {
//		com_err (NULL, r, "while authorizing.");
		return(0);
	}

	memset((char *)&cred, 0, sizeof(cred));
	if (r = krb5_sname_to_principal(adata->k5_context, szHostName, KRB_SERVICE_NAME,
            KRB5_NT_SRV_HST, &cred.server)) {
//		com_err (NULL, r, "while authorizing.");
        return(0);
    }

	if (r = krb5_cc_get_principal(adata->k5_context, adata->ccache, &cred.client)) {
//		com_err (NULL, r, "while authorizing.");
        krb5_free_cred_contents(adata->k5_context, &cred);
		return(0);
	}

	cred.keyblock.enctype = ENCTYPE_DES_CBC_CRC;
	if (r = krb5_get_credentials(adata->k5_context, KDC_OPT_RENEWABLE_OK,
				     adata->ccache, &cred, &(adata->new_cred))) {
//		com_err (NULL, r, "while authorizing.");
		krb5_free_cred_contents(adata->k5_context, &cred);
		return(0);
	}

    ap_opts = 0;
	if ((how & AUTH_HOW_MASK) == AUTH_HOW_MUTUAL)
	    ap_opts = AP_OPTS_MUTUAL_REQUIRED;
	    
#ifdef ENCRYPTION
	ap_opts |= AP_OPTS_USE_SUBKEY;
#endif	/* ENCRYPTION */
	    
	// RUJ 5/8/96 added to be consistent with appl/telnet/libtelnet/kerberos5_send().
	if (adata->auth_context) {
	    krb5_auth_con_free(adata->k5_context, adata->auth_context);
	    adata->auth_context = 0;
	}
	if ((r = krb5_auth_con_init(adata->k5_context, &(adata->auth_context)))) {
//		com_err (NULL, r, "while authorizing.");
	    return(0);
	}
	
	krb5_auth_con_setflags(adata->k5_context, adata->auth_context,
			       KRB5_AUTH_CONTEXT_RET_TIME);

	// RUJ 5/6/96 set up check_data for checksum auth_context->krb5_cksumtype;
	type_check[0] = AuthType;
	type_check[1] = how;
	check_data.magic = KV5M_DATA;
	check_data.length = 2;
	check_data.data = (char *) &type_check;

	r = krb5_mk_req_extended(adata->k5_context, &(adata->auth_context), ap_opts,
				 &check_data, adata->new_cred, &auth);
	tn_sendsub(tn, OPT_AUTHENTICATION, TNQ_NAME, 
		krb5_princ_component(adata->k5_context, cred.client, 0)->data,
		krb5_princ_component(adata->k5_context, cred.client, 0)->length);
	tn_sendauthsub(tn, OPT_AUTHENTICATION, TNQ_IS, AuthType, how, KRB_AUTH, 
		auth.data, auth.length);
	
			 
#ifdef	ENCRYPTION
	krb5_auth_con_getlocalsubkey(adata->k5_context, adata->auth_context, &newkey);
	if (adata->session_key) {
		krb5_free_keyblock(adata->k5_context, adata->session_key);
		adata->session_key = 0;
	}

	if (newkey) {
	    /* keep the key in our private storage, but don't use it
	       yet---see kerberos5_reply() below */
	    if ((newkey->enctype != ENCTYPE_DES_CBC_CRC) &&
			(newkey-> enctype != ENCTYPE_DES_CBC_MD5)) {
			if ((adata->new_cred->keyblock.enctype == ENCTYPE_DES_CBC_CRC) ||
			    (adata->new_cred->keyblock.enctype == ENCTYPE_DES_CBC_MD5))
			    /* use the session key in credentials instead */
			    krb5_copy_keyblock(adata->k5_context, &(adata->new_cred->keyblock),
					      &(adata->session_key));
			else
			    /* XXX ? */;
	    } else {
			krb5_copy_keyblock(adata->k5_context, newkey, &(adata->session_key));
	    }
	    krb5_free_keyblock(adata->k5_context, newkey);
	}
#endif	/* ENCRYPTION */

	krb5_free_cred_contents(adata->k5_context, &cred);
#ifndef FORWARD
	krb5_free_creds(adata->k5_context, adata->new_cred);
#endif /* FORWARD */

	if (r) {
//		com_err (NULL, r, "while authorizing.");
		return(0);
	}

	return(1);
}

/*
** 
** K5_auth_reply -- checks the reply for mutual authentication.
**
** Code lifted from telnet sample code in the appl directory.
** 
*/
static int
k5_auth_reply (tnParams *tn, int AuthType, int how, unsigned char *data, int cnt) {
	char strTmp[256];
	Session_Key skey;
	int 	x;
	k5_tn_auth_data *adata = tn->authdata;
#ifdef FORWARD
	krb5_data forw_creds;
	krb5_address laddr, lport;
#endif /* FORWARD */	
	
	if (cnt-- < 1)
		return;
		
    data += 4;	/* move forward 4 bytes to point to status byte */
	
	switch (*data++) {
	case K5_REJECT:
        if (cnt > 0) {
            sprintf (strTmp,
				"Kerberos V5 refuses authentication because %.*s", cnt, data);
//			com_err (data, cnt, strTmp);
		}
		else {
			sprintf (strTmp, "Kerberos V5 refuses authentication"); 
//			com_err (NULL, 0, strTmp);
		}	
		return KFAILURE;

	case K5_ACCEPT:
		if (!adata->mutual_complete) {
			if ((how & AUTH_HOW_MASK) == AUTH_HOW_MUTUAL) {
		    	sprintf(strTmp, "Kerberos V5 accepted you, " 
		    		"but didn't provide mutual authentication");
//				com_err (NULL, 0, strTmp);
		    	return KSUCCESS;
			}
#ifdef	ENCRYPTION
		    if (adata->session_key) {
				skey.type = SK_DES;
				skey.length = 8;
				skey.data = adata->session_key->contents;
				encrypt_session_key(tn, &skey);
		    }
#endif	/* ENCRYPTION */
		}
		if (cnt) {
			x = cnt - 4;	//reduce 4 bytes due to data += 4;
		    sprintf(strTmp, "Kerberos V5 accepts you as %.*s", x, data);
//			com_err (NULL, 0, strTmp);
		}
		else {
		    sprintf(strTmp, "Kerberos V5 accepts you");
//			com_err (NULL, 0, strTmp);
		}
		
#ifdef	FORWARD
    	laddr.contents = tn->ipaddr;
    	laddr.length = 4;
    	laddr.addrtype = ADDRTYPE_INET;
		lport.contents = (char *)&(tn->port);
		lport.length = sizeof(short);
		lport.addrtype = ADDRTYPE_IPPORT;

		if(krb5_auth_con_setaddrs(adata->k5_context, adata->auth_context, &laddr, NULL)) break;
		if(krb5_auth_con_setports(adata->k5_context, adata->auth_context, &lport, NULL)) break;
		
	    if (krb5_fwd_tgt_creds(adata->k5_context, adata->auth_context, 0, 
	    			adata->new_cred->client, adata->new_cred->server, adata->ccache,
					1 /* forwarded tickets will themselves be forwardable */,
					&forw_creds) == 0) {	    
		    /* Send forwarded credentials */
		    tn_sendauthsub(tn, OPT_AUTHENTICATION, TNQ_IS, AuthType, how, KRB_FORWARD,
		    	forw_creds.data, forw_creds.length);
	    }

	    if (forw_creds.data) free(forw_creds.data);
		krb5_free_creds(adata->k5_context, adata->new_cred);
#endif	/* FORWARD */

        return KSUCCESS;
		break;

	case K5_RESPONSE:
		if ((how & AUTH_HOW_MASK) == AUTH_HOW_MUTUAL) {
		    /* the rest of the reply should contain a krb_ap_rep */
		    krb5_ap_rep_enc_part *reply;
		    krb5_data inbuf;
		    krb5_error_code r;

		    inbuf.length = cnt;
		    inbuf.data = (char *)data;

		    if (r = krb5_rd_rep (adata->k5_context, adata->auth_context, &inbuf, &reply)) {
//				com_err (NULL, r, "while authorizing.");
                return KFAILURE;
		    }
		    krb5_free_ap_rep_enc_part(adata->k5_context, reply);
#ifdef	ENCRYPTION
		    if (adata->session_key) {
				skey.type = SK_DES;
				skey.length = 8;
				skey.data = adata->session_key->contents;
				encrypt_session_key(tn, &skey);
			}
#endif	/* ENCRYPTION */
			
		    adata->mutual_complete = 1;
		}
		return KSUCCESS;
		
#ifdef	FORWARD
	case KRB_FORWARD_ACCEPT:
		sprintf(strTmp, "Kerberos V5 accepted forwarded credentials");
//		com_err (NULL, 0, strTmp);
		return;
	case KRB_FORWARD_REJECT:
		sprintf(strTmp, "Kerberos V5 refuses forwarded credentials because %.*s",
				cnt, data);
//		com_err (NULL, 0, strTmp);
		return;
#endif	/* FORWARD */

	default:
		return KSUCCESS;                        // Unknown reply type
	}
}


/*
 * Insert a suboption into the suboption buffer.
 */
void tn_sendsub (tnParams *tn, int code, int request, char *scp, int length)
{
	int len;
	unsigned char *src, *lp, *limit;
	char start[] = {IAC, SB, 0, 0};
	char end[] = {IAC, SE};
	unsigned char *dst = tn->sendbuffer;

	src = (unsigned char *)scp;
	limit = src + length;
	start[2] = code;
	start[3] = request;

	BlockMoveData(start, dst, sizeof(start));
	dst += sizeof(start);

	/*
	 * Encode the buffer. IACs must be doubled
	 */
	if (*src == IAC) {						/* check initial iac in buffer */
		*dst++ = IAC;
	}
	while (src < limit) {
		lp = src+1;							/* dont check first char */
		while (lp < limit) {				/* scan for IAC */
			if (*lp == IAC)
				break;
			lp++;		
		}
		len = lp - src;
		if (lp < limit)						/* if stopped on IAC */
			len++;							/* include IAC in xmit */

		BlockMoveData(src, dst, len);
		dst += len;

		src = lp;							/* resume scanning */
    }

	BlockMoveData(end, dst, 2);
	dst += 2;

	len = dst - tn->sendbuffer;
	*tn->sendlength -= len;
	tn->sendbuffer += len;
}


/*
 * Insert a suboption into the suboption buffer.
 */
void tn_sendauthsub (tnParams *tn, int code, int request, int vers, int how, int auth, char *scp, int length)
{
	int len;
	unsigned char *src, *lp, *limit;
	char start[] = {IAC, SB, 0, 0, 0, 0, 0};
	char end[] = {IAC, SE};
	unsigned char *dst = tn->sendbuffer;

	src = (unsigned char *)scp;
	limit = src + length;
	start[2] = code;
	start[3] = request;
	start[4] = vers;
	start[5] = how;
	start[6] = auth;

	BlockMoveData(start, dst, sizeof(start));
	dst += sizeof(start);

	/*
	 * Encode the buffer. IACs must be doubled
	 */
	if (*src == IAC) {						/* check initial iac in buffer */
		*dst++ = IAC;
	}
	while (src < limit) {
		lp = src+1;							/* dont check first char */
		while (lp < limit) {				/* scan for IAC */
			if (*lp == IAC)
				break;
			lp++;		
		}
		len = lp - src;
		if (lp < limit)						/* if stopped on IAC */
			len++;							/* include IAC in xmit */

		BlockMoveData(src, dst, len);
		dst += len;

		src = lp;							/* resume scanning */
    }

	BlockMoveData(end, dst, 2);
	dst += 2;

	len = dst - tn->sendbuffer;
	*tn->sendlength -= len;
	tn->sendbuffer += len;
}

void tn_sendencsub (tnParams *tn, int code, int request, int method, int info, char *scp, int length)
{
	int len;
	unsigned char *src, *lp, *limit;
	char start[] = {IAC, SB, 0, 0, 0, 0};
	char end[] = {IAC, SE};
	unsigned char *dst = tn->sendbuffer;

	src = (unsigned char *)scp;
	limit = src + length;
	start[2] = code;
	start[3] = request;
	start[4] = method;
	start[5] = info;

	BlockMoveData(start, dst, sizeof(start));
	dst += sizeof(start);

	/*
	 * Encode the buffer. IACs must be doubled
	 */
	if (*src == IAC) {						/* check initial iac in buffer */
		*dst++ = IAC;
	}
	while (src < limit) {
		lp = src+1;							/* dont check first char */
		while (lp < limit) {				/* scan for IAC */
			if (*lp == IAC)
				break;
			lp++;		
		}
		len = lp - src;
		if (lp < limit)						/* if stopped on IAC */
			len++;							/* include IAC in xmit */

		BlockMoveData(src, dst, len);
		dst += len;

		src = lp;							/* resume scanning */
    }

	BlockMoveData(end, dst, 2);
	dst += 2;

	len = dst - tn->sendbuffer;
	*tn->sendlength -= len;
	tn->sendbuffer += len;
}

extern void (*__exit_proc__)(void);
void (*__exit_proc__)(void);
