/*
 * Copyright (c) 1997 Cygnus Solutions
 *
 * Author:  Michael Graff
 */

#include <windows.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "tel_reg.h"

#include "../lib/registry.h"

telnet_reg_t tel_res;  /* yes, a global.  Sue me. */

/*
 * function to load all the data we will want from the registry.  If the
 * registry data cannot be found this function will initialize a default
 * environment.
 */
void
telnet_load_registry(void)
{
  char    tmp[1024];
  DWORD   tdw;
  char   *ts;
  HKEY    key;
  HKEY    host_key;
  HKEY    tkey;
  int     i;
  telnet_host_t tmp_host;

  /*
   * Set up reasonable default values.  These will all be overwritten if
   * the registry is successfully opened.
   */
  tel_res.num_hosts = 0;
  tel_res.width = 80;
  tel_res.height = 24;
  tel_res.backspace = VK_BACK;

  strcpy(tel_res.font.face, "Courier");
  tel_res.font.height = 0;
  tel_res.font.width = 0;
  tel_res.font.escapement = 0;
  tel_res.font.char_set = 0;
  tel_res.font.pitch_and_family = 49;


  /*
   * Try to open the registry.  If we succeed, read the last used values from there.  If we
   * do not get the registry open simply return.
   */
  key = registry_open(HKEY_CURRENT_USER, KERBNET_TELNET_BASE, KEY_ALL_ACCESS);

  if (key == INVALID_HANDLE_VALUE)
	return;

  if (registry_string_get(key, "font_face", &ts) == 0) {
	strcpy(tel_res.font.face, ts);
	free(ts);
  }

  if (registry_dword_get(key, "font_height", &tdw) == 0)
	  tel_res.font.height = tdw;

  if (registry_dword_get(key, "font_width", &tdw) == 0)
	  tel_res.font.width = tdw;

  if (registry_dword_get(key, "font_escapement", &tdw) == 0)
	  tel_res.font.escapement = tdw;

  if (registry_dword_get(key, "font_char_set", &tdw) == 0)
	  tel_res.font.char_set = (BYTE)tdw;

  if (registry_dword_get(key, "font_pitch_and_family", &tdw) == 0)
	  tel_res.font.pitch_and_family = (BYTE)tdw;

  if (registry_dword_get(key, "height", &tdw) == 0)
	  tel_res.height = tdw;

  if (registry_dword_get(key, "width", &tdw) == 0)
	  tel_res.width = tdw;

  if (registry_dword_get(key, "backspace", &tdw) == 0)
	  tel_res.backspace = tdw;

  host_key = registry_open(key, "host", KEY_ALL_ACCESS);
  if (host_key == INVALID_HANDLE_VALUE) {
	registry_close(key);
	return;
  }

  for (i = 0 ; i < 10 ; i++) {
	  sprintf(tmp, "%d", i);
	  tkey = registry_open(host_key, tmp, KEY_ALL_ACCESS);
	  if (tkey == INVALID_HANDLE_VALUE)
		  break;

	  if (registry_string_get(tkey, "name", &ts) != 0)
		  goto host_err;
	  
	  strcpy(tmp_host.name, ts);
	  free(ts);
	  
	  if (registry_dword_get(tkey, "port", &tdw) != 0)
		  goto host_err;
	  tmp_host.port = tdw;

	  if (registry_dword_get(tkey, "backspace", &tdw) != 0)
		  goto host_err;
	  tmp_host.backspace = tdw;

	  memcpy(&(tel_res.hosts[i]), &tmp_host, sizeof(telnet_host_t));

	  tel_res.num_hosts++;

host_err:
	  registry_close(tkey);
  }

  registry_close(host_key);
  registry_close(key);
}

/*
 * save all the registry data, creating the keys if needed.
 */
void
telnet_save_registry(void)
{
  char    tmp[1024];
  HKEY    key;
  HKEY    host_key;
  HKEY    tkey;
  int     i;

  /*
   * First, create the heirachy...  This is gross, but functional
   */
  key = registry_key_create(HKEY_CURRENT_USER, CYGNUS_SOLUTIONS, KEY_WRITE);
  if (key == INVALID_HANDLE_VALUE)
	  return;

  key = registry_key_create(HKEY_CURRENT_USER, KERBNET_SANS_VERSION, KEY_WRITE);
  if (key == INVALID_HANDLE_VALUE)
	  return;
  registry_close(key);

  key = registry_key_create(HKEY_CURRENT_USER, KERBNET_BASE, KEY_WRITE);
  if (key == INVALID_HANDLE_VALUE)
	  return;
  registry_close(key);

  key = registry_key_create(HKEY_CURRENT_USER, KERBNET_TELNET_BASE, KEY_WRITE);
  if (key == INVALID_HANDLE_VALUE)
	return;

  registry_string_set(key, "font_face", tel_res.font.face);
  registry_dword_set(key, "font_height", tel_res.font.height);
  registry_dword_set(key, "font_width", tel_res.font.width);
  registry_dword_set(key, "font_escapement", tel_res.font.escapement);
  registry_dword_set(key, "font_char_set", tel_res.font.char_set);
  registry_dword_set(key, "font_pitch_and_family", tel_res.font.pitch_and_family);

  registry_dword_set(key, "height", tel_res.height);
  registry_dword_set(key, "width", tel_res.width);
  registry_dword_set(key, "backspace", tel_res.backspace);

  host_key = registry_key_create(key, "host", KEY_ALL_ACCESS);
  if (host_key == INVALID_HANDLE_VALUE) {
	registry_close(key);
	return;
  }

  for (i = 0 ; i < tel_res.num_hosts ; i++) {
	  sprintf(tmp, "%d", i);
	  tkey = registry_key_create(host_key, tmp, KEY_ALL_ACCESS);
	  if (tkey == INVALID_HANDLE_VALUE)
		  break;

	  registry_string_set(tkey, "name", tel_res.hosts[i].name);
	  registry_dword_set(tkey, "port", tel_res.hosts[i].port);
	  registry_dword_set(tkey, "backspace", tel_res.hosts[i].backspace);

	  registry_close(tkey);
  }

  registry_close(host_key);
  registry_close(key);
}
