#ifndef LUC_H
#define LUC_H

#include "pkcspad.h"

class LUCPublicKey : public PublicKeyUsingPKCSPadding
{
public:
    // you can use the default copy constructor to make a LUCPublicKey
    // out of a LUCPrivateKey
    LUCPublicKey(const Integer &n, const Integer &e);
    LUCPublicKey(BufferedTransformation &bt);

    void DEREncode(BufferedTransformation &bt) const;

    unsigned int MaxPlainTextLength() const {return modulusLen-11;}
    unsigned int CipherTextLength() const {return modulusLen;}
    unsigned int MaxMessageLength() const {return modulusLen-11;}
    unsigned int SignatureLength() const {return modulusLen;}

    const Integer& Exponent() const {return e;}
    const Integer& Modulus() const {return n;}

protected:
    LUCPublicKey() {}
    void RawEncrypt(const Integer &in, Integer &out) const;
	unsigned int PKCSBlockLen() const {return modulusLen;}

    Integer n, e;           // these are only modified in constructors
    unsigned int modulusLen;
};

class LUCPrivateKey : public LUCPublicKey, public PrivateKeyUsingPKCSPadding
{
public:
    LUCPrivateKey(const Integer &n, const Integer &e, const Integer &p, const Integer &q, const Integer &u);
    // generate a random private key
    LUCPrivateKey(RandomNumberGenerator &rng, unsigned int keybits, Integer eStart=17);
    LUCPrivateKey(BufferedTransformation &bt);

    void DEREncode(BufferedTransformation &bt) const;

protected:
    void RawDecrypt(const Integer &in, Integer &out) const;
	unsigned int PKCSBlockLen() const {return modulusLen;}

    Integer p, q, u;
};

#endif
