/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 */

package cryptix.pgp;

import java.io.InputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import cryptix.util.StreamInterface;
import cryptix.util.Streamable;

public abstract class Packet
{
	protected Packet()
	{
	}

	protected Packet( DataInput in, int length )
		throws IOException
	{
		read( in, length );
	}

	public final void
	load( byte buf[] )
		throws IOException
	{
		load( buf, 0, buf.length );
	}

	public final void
	load( byte buf[], int offset )
		throws IOException
	{
		int len = buf.length - offset;
		if ( len <= 0 )
			throw new IOException( "Offset too big or buffer too short." );
		load( buf, offset, len );
	}

	public final void
	load( byte buf[], int offset, int length )
		throws IOException
	{
		InputStream in = new ByteArrayInputStream( buf );
		if ( offset > 0 )
			in.skip( offset );
		read( new DataInputStream( in ), length );
	}

	public final byte[]
	save()
		throws IOException
	{
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		write( new DataOutputStream( out ) );
		return out.toByteArray();
	}

	public abstract void read( DataInput in, int length ) throws IOException;
	public abstract int write( DataOutput out ) throws IOException;
}
