package cryptix.gui;

import java.io.*;
import java.util.*;
import java.awt.*;

import cryptix.crypt.rsa.RSAKeyGen;
import cryptix.crypt.rsa.RSAKeyGenObserver;
import cryptix.pgp.RandomStream;
// import cryptix.gui.widgets.Slider;

public class KeyGen extends Frame implements Runnable, RSAKeyGenObserver
{
    private String phrase = "";
    private Button cont;
    private Button cancel;
    private TextField keyid;
    private TextField pass1;
    private TextField pass2;
	private Frame parent;
	private CardLayout card_layout;
	private Panel card_panel;
	private Label info_label;
	private boolean need_random = true;
	private boolean info_entered = false;
	private int event_counter = 200;
	private int keylen = 512;
	private RandomStream rs;
	private ByteArrayOutputStream event_buf;
	private DataOutputStream event_dos;
	private cryptix.crypt.rsa.SecretKey key;
	private String errstr;
	private Thread keygenThread;

	private Label rl2;
	private Label kgl2;


    public KeyGen(Frame parent, RandomStream rs, int keylen)
    {
		this.parent = parent;
		this.rs = rs;
		this.keylen = keylen;

		//
		//	Initialise our buffer with some entropy from the RandomStream
		//
		event_buf = new ByteArrayOutputStream();
		event_dos = new DataOutputStream(event_buf);
		
		// Is suppose this could be thrown as an exception instead???
		try {
			for(int i = 0; i < 24; i++)
				event_dos.writeByte(rs.read());
		} catch(IOException e)
		{
			(new WarningDialog(this.parent, "Problem obtaining good random numbers ("+e.getMessage()+")")).show();
			return;
		}


		// Does this work?
		setResizable(false);


		//
		//	Create the two buttons
		//
		cont = new Button("Continue");
		cancel = new Button("Cancel");


		//
		//	Create a panel for the buttons
		//
        Panel button_panel = new Panel();
        button_panel.setLayout(new FlowLayout());
        button_panel.add(cont);
        button_panel.add(cancel);

		//
		//	Create a panel for the key id text field
		//
		keyid = new TextField(30);
        Panel keyid_panel = new Panel();
        keyid_panel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        keyid_panel.add(new Label("Key id:"));
        keyid_panel.add(keyid);

		//
		//	Create a panel for the passphrase text field
		//
		pass1 = new TextField(30);
        pass1.setEchoCharacter('*');
        Panel pass1_panel = new Panel();
        pass1_panel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        pass1_panel.add(new Label("Passphrase:"));
        pass1_panel.add(pass1);

		//
		//	Create a panel for the passphrase text field
		//
		pass2 = new TextField(30);
        pass2.setEchoCharacter('*');
        Panel pass2_panel = new Panel();
        pass2_panel.setLayout(new FlowLayout(FlowLayout.RIGHT));
        pass2_panel.add(new Label("Passphrase:"));
        pass2_panel.add(pass2);


		//
		//	Build a data panel from the previous fields
		//
        Panel data_panel = new Panel();
		data_panel.setLayout(new GridLayout(0,1));
		data_panel.add(keyid_panel);
		data_panel.add(pass1_panel);
		data_panel.add(pass2_panel);

		//
		//	Build the random panel
		//
        Panel random_text_panel = new Panel();
		random_text_panel.setLayout(new GridLayout(0,1));
		// Label rl1 = new Label("Please play with slider until the");
		Label rl1 = new Label("Please move mouse until");
		rl2 = new Label("counter reaches zero: 1000");
		random_text_panel.add(rl1);
		random_text_panel.add(rl2);

//        Panel random_slider_panel = new Panel();
//		random_slider_panel.add(new Slider(0, 100));

        Panel random_panel = new Panel();
		// random_panel.setLayout(new GridLayout(0,1));
        random_panel.add(random_text_panel);
//		random_panel.add(random_slider_panel);


		//
		//	Build the key generation panel
		//
        Panel keygen_panel = new Panel();
		keygen_panel.setLayout(new GridLayout(0,1));
		Label kgl1 = new Label("This may take a long time.");
		kgl2 = new Label("");
		keygen_panel.add(kgl1);
		keygen_panel.add(kgl2);


		//
		//	Create the dual purpose (card) panel
		//
		card_panel = new Panel();
		card_layout = new CardLayout();
		card_panel.setLayout(card_layout);
		card_panel.add("data input", data_panel);
		card_panel.add("random", random_panel);
		card_panel.add("key generation", keygen_panel);

		info_label = new Label("Enter id and passphrase (twice) for the new key");
        Panel info_panel = new Panel();
		info_panel.add("Center", info_label);
		//
		//	Now add the card panel (the dual purpose panel)
		//	and the buttons
		//
        add("North", info_panel);
        add("Center", card_panel);
        add("South", button_panel);

		pack();
    }

    public boolean action(Event e, Object arg)
    {
		if (e.target == cont)
		{
			if (keyid.getText().length() == 0)
			{
				(new InfoDialog(this.parent, "Invalid key id")).show();
				return true;
			}
			if (pass1.getText().length() < 4)
			{
				(new InfoDialog(this.parent, "Please use a longer passphrase")).show();
				return true;
			}
			if (!pass1.getText().equals(pass2.getText()))
			{
				(new InfoDialog(this.parent, "Passphrases do not match")).show();
				pass1.setText("");
				pass2.setText("");
				return true;
			}
			card_layout.show(card_panel, "random");
			cont.disable();
			info_entered = true;
			info_label.setText("Generating random numbers");
			return true;
		}
		if (e.target == cancel)
		{
			if (keygenThread != null)
				keygenThread.stop();
			hide();
			parent.postEvent(new Event(this, Event.ACTION_EVENT, null));
			return true;
		}
		return false;
    }

	public final boolean
	handleEvent(Event event)
	{
		if (need_random)
		{
			try {
				event_dos.writeLong(event.when);
				event_dos.writeInt(event.x);
				event_dos.writeInt(event.y);
				event_dos.writeInt(event.modifiers);
				event_dos.writeInt(event.id);
				event_dos.writeLong(System.currentTimeMillis());

				if (event_counter == 0)
				{
					if (info_entered)
					{
						need_random = false;
						keygenThread = new Thread(this, "keygen");
						keygenThread.start();
					}
				}
				else
				{
					rl2.setText("counter reaches zero: "+event_counter);
					event_counter--;
				}
			}
			catch(IOException e)
			{
				(new WarningDialog(this.parent, "Problem obtaining good random numbers "+e.getMessage()+")")).show();
			}
		}
		return super.handleEvent(event);
	}

	public void
	run()
	{
		info_label.setText("Generating secret key.");
		card_layout.show(card_panel, "key generation");

		keygenThread.setPriority(keygenThread.getPriority()-2);

		try {
			rs.add(event_buf.toByteArray());
			rs.updateSeedFile();
		}
		catch(IOException e)
		{
			(new WarningDialog(this.parent, "Problem writing random seed file ("+e.getMessage()+")")).show();
		}
		key = RSAKeyGen.createKey(rs, keylen, this);
		hide();
		parent.postEvent(new Event(this, Event.ACTION_EVENT, key));
	}


	private int symbol = 0;
	private char symbols[] = { '-', '\\', '|', '/' };
	
	//
	//	Confusing method name - change this at some point
	//
	public void
	handleEvent(int event)
	{
		String primeStr = "";	//More hacks ...
		boolean showSymbol = true;
		switch(event)
		{
		case KEY_GEN_DONE:
			return;
		case NOT_PRIME:
		case NO_SMALL_FACTORS:
		case HAS_SMALL_FACTORS:
			symbol++;
			symbol %= 4;
			break;
		/** the RSA Key Generator is searching for a suitable Q */
		case FINDING_Q:
//			primeStr = "P done, seeking Q ";
			break;
		/** the RSA Key Generator is generation a key from P and Q */
		case KEY_RESOLVING:
			primeStr = "Resolving keys ...";
			showSymbol = false;
			break;
		case IS_PRIME:
		case FINDING_P:
		default:
			break;
		}
		kgl2.setText( showSymbol ? ( primeStr + symbols[symbol] ) : primeStr );

		Thread.yield();	// don't rely on pre-emptive threads
		return;
	}

    public static void main( String argv[] )
		throws IOException
    {
	    MainFrame top = new MainFrame("KeyGen (mainframe)");
		top.show();
		System.exit(-1);
    }

}

class MainFrame extends Frame
{
	KeyGen kg;
	Thread t;

	MainFrame(String title)
		throws IOException
	{
		super(title);

		RandomStream rs = new RandomStream();
	    kg = new KeyGen(this, rs, 256);
	}

	public void
	show()
	{
		kg.show();
		t = Thread.currentThread();
		t.suspend();
	}

	public boolean
	action(Event event, Object arg)
	{
		if (arg == null)
			System.out.println("key generation unsuccessful");
		else
			System.out.println("key generation successful");

		t.resume();
		return true;
	}

	public boolean
	handleEvent(Event event)
	{
		if (event.id == Event.WINDOW_DESTROY)
			System.exit(0);

		return super.handleEvent(event);
	}
}
