.TH GC_MALLOC 1L "12 November 1992"
.SH NAME
GC_malloc, GC_malloc_atomic, GC_free, GC_realloc, GC_register_displacement, GC_register_finalizer \- Garbage collecting malloc replacement
.SH SYNOPSIS
#include "gc.h"
.br
# define malloc(n) GC_malloc(n)
.br
... malloc(...) ...
.br
.sp
cc ... gc.a
.LP
.SH DESCRIPTION
.I GC_malloc
and
.I GC_free
are plug-in replacements for standard malloc and free.  However,
.I
GC_malloc
will attempt to reclaim inaccessible space automaticaly by invoking a conservative garbage collector at appropriate points.  The collector traverses all data structures accessible by following pointers from the machines registers, stack(s), data, and bss segments.  Inaccessible structures will be reclaimed.  A machine word is considered to be a valid pointer if it resides on a stack or in registers and is an address inside an object allocated by
.I
GC_malloc
or friends, or if it resides inside the heap, and points to either the beginning of a heap object, or points to an offset \fIn\fP within the object that was registered by a call
.I
GC_register_displacement(n).
.LP
Unlike the standard implementations of malloc,
.I
GC_malloc
clears the newly allocated storage.
.I
GC_malloc_atomic
does not.  Furthermore, it informs the collector that the resulting object will never contain any pointers, and should therefore not be scanned by the collector.
.I
GC_free
can be used to deallocate objects, but its use is optional, and discouraged.
.I
GC_realloc
has the standard realloc semantics.  It preserves pointer-free-ness.
.I
GC_register_finalizer
allows for registration of functions that are invoked when an object becomes inaccessible.
.LP
It is also possible to use the collector to find storage leaks in programs destined to be run with standard malloc/free.  The collector can be compiled for thread-safe operation.  Unlike standard malloc, it is safe to call malloc after a previous malloc call was interrupted by a signal, provided the original malloc call is not resumed.
.LP
Debugging versions of many of the above routines are provided as macros.  Their names are identical to the above, but consist of all capital letters.  If GC_DEBUG is defined before gc.h is included, these routines do additional checking, and allow the leak detecting version of the collector to produce slightly more useful output.  Without GC_DEBUG defined, they behave exactly like the lower-case versions.
.LP
.SH "SEE ALSO"
The README and gc.h files in the distribution.  More detailed definitions of the functions exported by the collector are given there.  (The above list is not complete.)
.LP
Boehm, H., and M. Weiser, "Garbage Collection in an Uncooperative Environment",
\fISoftware Practice & Experience\fP, September 1988, pp. 807-820.
.LP
The malloc(3) man page.
.LP
.SH AUTHOR
Hans-J. Boehm (boehm@parc.xerox.com).  Some of the code was written by others, most notably Alan Demers.
