/* 
 * AFM koi8 encoding.
 * Copyright (c) 1996 Markku Rossi.
 *
 * Author: Markku Rossi <mtr@iki.fi>
 */

/*
 * This file is part of the AFM library.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "afmint.h"

AFMEncodingTable afm_koi8_encoding[] =
{
  {0x00, AFM_ENC_NONE},
  {0x01, AFM_ENC_NONE},
  {0x02, AFM_ENC_NONE},
  {0x03, AFM_ENC_NONE},
  {0x04, AFM_ENC_NONE},
  {0x05, AFM_ENC_NONE},
  {0x06, AFM_ENC_NONE},
  {0x07, AFM_ENC_NONE},
  {0x08, AFM_ENC_NONE},
  {0x09, AFM_ENC_NONE},
  {0x0a, AFM_ENC_NONE},
  {0x0b, AFM_ENC_NONE},
  {0x0c, AFM_ENC_NONE},
  {0x0d, AFM_ENC_NONE},
  {0x0e, AFM_ENC_NONE},
  {0x0f, AFM_ENC_NONE},
  {0x10, AFM_ENC_NONE},
  {0x11, AFM_ENC_NONE},
  {0x12, AFM_ENC_NONE},
  {0x13, AFM_ENC_NONE},
  {0x14, AFM_ENC_NONE},
  {0x15, AFM_ENC_NONE},
  {0x16, AFM_ENC_NONE},
  {0x17, AFM_ENC_NONE},
  {0x18, AFM_ENC_NONE},
  {0x19, AFM_ENC_NONE},
  {0x1a, AFM_ENC_NONE},
  {0x1b, AFM_ENC_NONE},
  {0x1c, AFM_ENC_NONE},
  {0x1d, AFM_ENC_NONE},
  {0x1e, AFM_ENC_NONE},
  {0x1f, AFM_ENC_NONE},
  {0x20, "space"},
  {0x21, "exclam"},
  {0x22, "quotedbl"},
  {0x23, "numbersign"},
  {0x24, "dollar"},
  {0x25, "percent"},
  {0x26, "ampersand"},
  {0x27, "quoteright"},
  {0x28, "parenleft"},
  {0x29, "parenright"},
  {0x2a, "asterisk"},
  {0x2b, "plus"},
  {0x2c, "comma"},
  {0x2d, "hyphen"},
  {0x2e, "period"},
  {0x2f, "slash"},
  {0x30, "zero"},
  {0x31, "one"},
  {0x32, "two"},
  {0x33, "three"},
  {0x34, "four"},
  {0x35, "five"},
  {0x36, "six"},
  {0x37, "seven"},
  {0x38, "eight"},
  {0x39, "nine"},
  {0x3a, "colon"},
  {0x3b, "semicolon"},
  {0x3c, "less"},
  {0x3d, "equal"},
  {0x3e, "greater"},
  {0x3f, "question"},
  {0x40, "at"},
  {0x41, "A"},
  {0x42, "B"},
  {0x43, "C"},
  {0x44, "D"},
  {0x45, "E"},
  {0x46, "F"},
  {0x47, "G"},
  {0x48, "H"},
  {0x49, "I"},
  {0x4a, "J"},
  {0x4b, "K"},
  {0x4c, "L"},
  {0x4d, "M"},
  {0x4e, "N"},
  {0x4f, "O"},
  {0x50, "P"},
  {0x51, "Q"},
  {0x52, "R"},
  {0x53, "S"},
  {0x54, "T"},
  {0x55, "U"},
  {0x56, "V"},
  {0x57, "W"},
  {0x58, "X"},
  {0x59, "Y"},
  {0x5a, "Z"},
  {0x5b, "bracketleft"},
  {0x5c, "backslash"},
  {0x5d, "bracketright"},
  {0x5e, "asciicircum"},
  {0x5f, "underscore"},
  {0x60, "quoteleft"},
  {0x61, "a"},
  {0x62, "b"},
  {0x63, "c"},
  {0x64, "d"},
  {0x65, "e"},
  {0x66, "f"},
  {0x67, "g"},
  {0x68, "h"},
  {0x69, "i"},
  {0x6a, "j"},
  {0x6b, "k"},
  {0x6c, "l"},
  {0x6d, "m"},
  {0x6e, "n"},
  {0x6f, "o"},
  {0x70, "p"},
  {0x71, "q"},
  {0x72, "r"},
  {0x73, "s"},
  {0x74, "t"},
  {0x75, "u"},
  {0x76, "v"},
  {0x77, "w"},
  {0x78, "x"},
  {0x79, "y"},
  {0x7a, "z"},
  {0x7b, "braceleft"},
  {0x7c, "bar"},
  {0x7d, "braceright"},
  {0x7e, "tilde"},
  {0x7f, AFM_ENC_NONE},
  {0x80, AFM_ENC_NONE},
  {0x81, AFM_ENC_NONE},
  {0x82, AFM_ENC_NONE},
  {0x83, AFM_ENC_NONE},
  {0x84, "guillmotleft"},
  {0x85, "guillmotright"},
  {0x86, "afii61352"},
  {0x87, AFM_ENC_NONE},
  {0x88, AFM_ENC_NONE},
  {0x89, AFM_ENC_NONE},
  {0x8a, AFM_ENC_NONE},
  {0x8b, AFM_ENC_NONE},
  {0x8c, AFM_ENC_NONE},
  {0x8d, AFM_ENC_NONE},
  {0x8e, AFM_ENC_NONE},
  {0x8f, AFM_ENC_NONE},
  {0x90, AFM_ENC_NONE},
  {0x91, AFM_ENC_NONE},
  {0x92, AFM_ENC_NONE},
  {0x93, AFM_ENC_NONE},
  {0x94, AFM_ENC_NONE},
  {0x95, AFM_ENC_NONE},
  {0x96, AFM_ENC_NONE},
  {0x97, AFM_ENC_NONE},
  {0x98, AFM_ENC_NONE},
  {0x99, AFM_ENC_NONE},
  {0x9a, AFM_ENC_NONE},
  {0x9b, AFM_ENC_NONE},
  {0x9c, AFM_ENC_NONE},
  {0x9d, AFM_ENC_NONE},
  {0x9e, AFM_ENC_NONE},
  {0x9f, AFM_ENC_NONE},
  {0xa0, "space"},
  {0xa1, "exclamdown"},
  {0xa2, "cent"},
  {0xa3, "afii10071"},
  {0xa4, "currency"},
  {0xa5, "yen"},
  {0xa6, "brokenbar"},
  {0xa7, "section"},
  {0xa8, "dieresis"},
  {0xa9, "copyright"},
  {0xaa, "ordfeminine"},
  {0xab, "guillemotleft"},
  {0xac, "logicalnot"},
  {0xad, "hyphen"},
  {0xae, "registered"},
  {0xaf, "macron"},
  {0xb0, "degree"},
  {0xb1, "plusminus"},
  {0xb2, "twosuperior"},
  {0xb3, "afii10023"},
  {0xb4, "acute"},
  {0xb5, "mu"},
  {0xb6, "paragraph"},
  {0xb7, "bullet"},
  {0xb8, "cedilla"},
  {0xb9, "dotlessi"},
  {0xba, "ordmasculine"},
  {0xbb, "guillemotright"},
  {0xbc, "onequarter"},
  {0xbd, "onehalf"},
  {0xbe, "threequarters"},
  {0xbf, "questiondown"},
  {0xc0, "afii10096"},
  {0xc1, "afii10065"},
  {0xc2, "afii10066"},
  {0xc3, "afii10088"},
  {0xc4, "afii10069"},
  {0xc5, "afii10070"},
  {0xc6, "afii10086"},
  {0xc7, "afii10068"},
  {0xc8, "afii10087"},
  {0xc9, "afii10074"},
  {0xca, "afii10075"},
  {0xcb, "afii10076"},
  {0xcc, "afii10077"},
  {0xcd, "afii10078"},
  {0xce, "afii10079"},
  {0xcf, "afii10080"},
  {0xd0, "afii10081"},
  {0xd1, "afii10097"},
  {0xd2, "afii10082"},
  {0xd3, "afii10083"},
  {0xd4, "afii10084"},
  {0xd5, "afii10085"},
  {0xd6, "afii10072"},
  {0xd7, "afii10067"},
  {0xd8, "afii10094"},
  {0xd9, "afii10093"},
  {0xda, "afii10073"},
  {0xdb, "afii10090"},
  {0xdc, "afii10095"},
  {0xdd, "afii10091"},
  {0xde, "afii10089"},
  {0xdf, "afii10092"},
  {0xe0, "afii10048"},
  {0xe1, "afii10017"},
  {0xe2, "afii10018"},
  {0xe3, "afii10040"},
  {0xe4, "afii10021"},
  {0xe5, "afii10022"},
  {0xe6, "afii10038"},
  {0xe7, "afii10020"},
  {0xe8, "afii10039"},
  {0xe9, "afii10026"},
  {0xea, "afii10027"},
  {0xeb, "afii10028"},
  {0xec, "afii10029"},
  {0xed, "afii10030"},
  {0xee, "afii10031"},
  {0xef, "afii10032"},
  {0xf0, "afii10033"},
  {0xf1, "afii10049"},
  {0xf2, "afii10034"},
  {0xf3, "afii10035"},
  {0xf4, "afii10036"},
  {0xf5, "afii10037"},
  {0xf6, "afii10024"},
  {0xf7, "afii10019"},
  {0xf8, "afii10046"},
  {0xf9, "afii10045"},
  {0xfa, "afii10025"},
  {0xfb, "afii10042"},
  {0xfc, "afii10047"},
  {0xfd, "afii10043"},
  {0xfe, "afii10041"},
  {0xff, "afii10044"},
  {-1,   NULL},
};
