/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.term;

import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.TermConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TermUtils {
    static final CompoundTermTag existsTag = CompoundTermTag.get("^", 2);

    private TermUtils() {
    }

    public static boolean isVariant(Term term1, Term term2) {
        return TermUtils.isVariant(term1, term2, new HashMap<Term, Term>());
    }

    protected static boolean isVariant(Term term1, Term term2, Map<Term, Term> map) {
        term1 = term1.dereference();
        term2 = term2.dereference();
        if (term1 instanceof VariableTerm) {
            if (!(term2 instanceof VariableTerm)) {
                return false;
            }
            Term s = map.get(term1);
            if (s != null) {
                return s == term2;
            }
            map.put(term1, term2);
            return true;
        }
        if (term1 == term2) {
            return true;
        }
        if (term1.getClass() != term2.getClass()) {
            return false;
        }
        if (term1 instanceof FloatTerm) {
            FloatTerm f1 = (FloatTerm)term1;
            FloatTerm f2 = (FloatTerm)term2;
            return f1.value == f2.value;
        }
        if (term1 instanceof IntegerTerm) {
            IntegerTerm i1 = (IntegerTerm)term1;
            IntegerTerm i2 = (IntegerTerm)term2;
            return i1.value == i2.value;
        }
        if (term1 instanceof JavaObjectTerm) {
            JavaObjectTerm i1 = (JavaObjectTerm)term1;
            JavaObjectTerm i2 = (JavaObjectTerm)term2;
            return i1.value == i2.value;
        }
        if (term1 instanceof CompoundTerm) {
            CompoundTerm c1 = (CompoundTerm)term1;
            CompoundTerm c2 = (CompoundTerm)term2;
            if (c1.tag != c2.tag) {
                return false;
            }
            for (int i = c2.tag.arity - 1; i >= 0; --i) {
                if (TermUtils.isVariant(c1.args[i], c2.args[i], map)) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException("unknown term type");
    }

    public static void getVariableSet(Term term, Set<Term> set) {
        if ((term = term.dereference()) instanceof VariableTerm) {
            set.add(term);
        } else if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            for (int i = ct.tag.arity - 1; i >= 0; --i) {
                TermUtils.getVariableSet(ct.args[i], set);
            }
        }
    }

    public static Term getExistentialVariableSet(Term term, Set<Term> set) {
        if ((term = term.dereference()) instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            if (ct.tag == existsTag) {
                TermUtils.getVariableSet(ct.args[0], set);
                return TermUtils.getExistentialVariableSet(ct.args[1], set);
            }
            return ct;
        }
        return term;
    }

    public static Term getFreeVariableSet(Term term1, Term term2, Set<Term> set) {
        HashSet<Term> bound = new HashSet<Term>();
        TermUtils.getVariableSet(term2, bound);
        Term rc = TermUtils.getExistentialVariableSet(term1, bound);
        TermUtils.getVariableSet(term1, set);
        set.removeAll(bound);
        return rc;
    }

    public static Term getWitness(Set<Term> set) {
        Term rc = TermConstants.emptyListAtom;
        Iterator<Term> i = set.iterator();
        while (i.hasNext()) {
            rc = CompoundTerm.getList(i.next(), rc);
        }
        return rc;
    }
}

