//
// sha1.hxx
//
// NIST/NSA's Secure Hash Algorithm
// (as defined in FIPS 180-1)
//
// this implementation
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

#ifndef _SHA1_HXX
#define _SHA1_HXX

#include <chnhash/sha.hxx>

extern "C"
{
  void LC_SHA1_Scramble(u32*,u32*,u32*,u32*,u32*, u32*);
}

class SHA1 : public SHA 
{
private:
  static inline void Scramble(u32& a, u32& b, u32& c, u32& d, u32& e, u32* X);
  void ProcessBuf();
public:
  SHA1();
  ~SHA1();

  static void CompressBlock(const u32* iv, const u32* block, u32* result);
  void Compress(const void* iv, const void* block, void* result) const;
};

#include <chnhash/sha1.inl>

#endif
