// lmisc.inl
//
// odds and ends
//
// Copyright (C) 1996-7 by Leonard Janke (janke@unixg.ubc.ca)

inline void LMisc::MemZero(unsigned int* x, int size)
{
  LMisc::MemZero((u32*) x, size);
}

inline void LMisc::MemCopy(unsigned int* dest, const unsigned int* source, 
			   int size)
{
  LMisc::MemCopy((u32*) dest,(const u32*) source,size);
}

inline void LMisc::MemMove(unsigned int* dest, unsigned int* source, 
			   int size)
{
  LMisc::MemMove((u32*) dest,(u32*) source,size);
}

inline unsigned int LMisc::BSwap(unsigned int x)
{
  return BSwap((u32) x);
}

inline void LMisc::MemSwap(u32* buffer, int size)
{
  for (int i=0; i<size; i++)
    buffer[i]=BSwap(buffer[i]);
}

inline void LMisc::MemSwap(unsigned int* buffer,  int size)
{
  MemSwap((u32*) buffer,size);
}

inline unsigned int LMisc::LowBitFilter(const int numBits)
{
  return ~(~0u<<numBits);
}

inline unsigned int LMisc::Ceiling(unsigned int x, unsigned int y)
{
  return ( x % y ) ? x/y+1 : x/y;
}

inline u32 LMisc::High32Of64(const u64 x)
{
   return x>>32;
}

inline u32 LMisc::Low32Of64(const u64 x)
{
   return x&0xffffffffull;
}

template<class T> inline void LC_Swap(T& x, T& y)
{
  T temp=x;
  x=y;
  y=temp;
}

template<class T> inline const T& LC_Min(const T& x, const T& y)
{
  return ( x<y ) ? x : y;
}

template<class T> inline const T& LC_Max(const T& x, const T& y)
{
  return ( x>y ) ? x : y;
}

