#!/bin/sh
# Exercise an abort-inducing flaw in inotify-enabled tail -F.

# Copyright (C) 2009-2014 Free Software Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. "${srcdir=.}/tests/init.sh"; path_prepend_ ./src
print_ver_ tail

# 9 is a magic number, related to internal details of tail.c and hash.c
n=9
seq $n | xargs touch || framework_failure_

debug='---disable-inotify'
debug=
tail $debug -s.1 -qF $(seq $n) > out 2>&1 & pid=$!

check_tail_output()
{
  local delay="$1"
  grep "$tail_re" out > /dev/null ||
    { sleep $delay; return 1; }
}

# Wait up to 6.3s for tail to start
echo x > $n
tail_re='^x$' retry_delay_ check_tail_output .1 7 || fail=1

mv 1 f || fail=1

# Wait 6.3s for this diagnostic:
# tail: '1' has become inaccessible: No such file or directory
tail_re='inaccessible' retry_delay_ check_tail_output .1 7 || fail=1

# Trigger the bug.  Before the fix, this would provoke the abort.
echo a > 1 || fail=1

# Wait up to 2s for the buggy tail to die,
# or for the "tail: '1' has appeared;  following end of new file" output
for i in $(seq 10); do
  kill -0 $pid || break
  grep 'has appeared;' out > /dev/null && break
  sleep .2
done

# Kill the working tail, or fail if it has already aborted
kill $pid || fail=1

cat out

Exit $fail
