
;;; d-modeline.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-modeline.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Unix Backup
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(setq mode-line-format (delete 'global-mode-string default-mode-line-format))
;;(setq mode-line-format (delete "   " default-mode-line-format))

(defun d--mapcar--default-mode-line-format (arg)
  (let ((match-1-a "   %[(")
        (match-1-b "  %[(")
        (match-2   ")%]--"))
    (cond
     ((and (stringp arg)
           (string= arg match-1-a))
      (list match-1-b))
     ((and (stringp arg)
           (string= arg match-2))
      (list match-2 'global-mode-string "--"))
     (t
      (list arg)))))

(setq mode-line-format (apply 'nconc (mapcar 'd--mapcar--default-mode-line-format mode-line-format)))

(setq default-mode-line-format mode-line-format)

;; (nconc '(1 2 3) '(4 5 6))
;; (apply 'nconc '( (1 2 3) ( 4 5 6)))

(provide 'd-modeline)
;;; d-modeline.el ends here
