static char sccsid[] = "@(#)ThisForthKernel.c   94-09-01    Wil Baden";
# include "fo.h"

extern FILE * usrin, * usrout;
extern int parg; extern int pargc; extern char ** pargv;

extern struct tm * broken_down_time;
extern time_t time_now;

extern unsigned char data[];
extern int localname;
extern int anonymous;

extern instruction code[];

static unsigned char * word;

extern char CS[];

extern union   { double Double; long Long; short Short[4]; } u;

extern cell rack[], *R;
extern cell stack[], *S, top;
extern double  fstack[], *F, ftop;   /* floating point stack */

extern int  current, context, last, leaves, I;
extern int  colevel, finger, here, level, link, progress, state;
extern int  shelf;
extern int  dataspace, namespace;
extern int  latest, previous, preceding;

extern FILE * file[];
extern char*    cpps[];     /* Character Pointer Pointer Stack */
extern char*    cpp;                /* Character Pointer Pointer */
extern char*    cp;                 /* Character Pointer */
extern int  files;

extern jmp_buf jmpbuf;

void adopt(int primitive)
{   /* Get the next word and build a header.*/
	if (code[CURRENT] == 0) sorry("(New Definitions Not Allowed)") ;
	current = next, dataspace = here, namespace = finger;
	if (! lexer(&name[finger])) sorry("(End of File)") ;
	monocase(finger);
	last = code[code[CURRENT]];
	if (anonymous) {
		c(last), last = current;
		move(
			&name[localname], &name[finger], name[finger]+ 1
		);
		c(localname), localname += name[localname] + 1;
		anonymous = FALSE;
	} else {
		source = finger;
		link = searchwordlist(&name[finger], last);
		c(last), last = current;
		if (link) {
			type(&name[finger+1], name[finger]),
			printf(" (Redefined) ");
			c(code[link + 1]);
		} else
			stringcompile();
	}
	c(primitive);
}

int lexer(unsigned char *charp)
{   /* Get a graphic word of max length WIDTH .*/
	int c, n;
	while ((c = char()) != EOF  && ! isgraph(c))
	if (c == EOL) {
		if (usrin == stdin && cp == cpp) {
			if (! state)
				printf("(OK)\n") ;
			for (n = S - stack; n > 0; -- n)
				printf("   ");
		}
	}
	for (n = 0; c != EOF && isgraph(c); c = char()) {
		if (n < WIDTH)
			++ n ;
		else
			move(&charp[WIDTH - 10],&charp[WIDTH - 9], 10);
		charp[n] = c;
	}
	charp[0] = n; charp[n + 1] = EOS;

	if (c == EOL) unchar(c) ;

	return n;
}

FILE    * stream(void)
{   /* Open next file.*/
	if (usrin && usrin != stdin)
		fclose(usrin);
	if (files)
		usrin = file[--files],
			cp = cpp, cpp = cpps[files];
	else if (++parg >= pargc || ! strcmp(pargv[parg], "-"))
		usrin = stdin, unchar(EOL);
	else
		if ((usrin = fopen(pargv[parg], "r")) == NULL)
			fprintf(usrout, "Can't open %s.\n", pargv[parg]) ;
	return usrin;
}

void    monocase(int caddr)
{   /* Convert word to lowercase if no lowercase in word.*/
	int n;
	for (n = name[caddr]; n && ! islower(name[caddr + n]); -- n) ;
	if (! n)
		for (n = name[caddr]; n; -- n)
			name[caddr + n] = tolower(name[caddr + n]);
}

void stringcompile(void)
{	/* Compile location of string. */
	unsigned char * str, * pat;
	register int i, n;
	for (n = 0;; n += name[n] + 1)  {
		str = &name[n], pat = &name[finger];
		i = * str;
		if (i == * pat)  {
			while (i && *++str == *++pat) --i ;
			if (i == 0) break ;
		}
	}
	c(n);
	if (n == finger) finger += name[finger] + 1 ;
}

int (lookup)(int s)
{
	int i;
	int link;
	unsigned char * word = &name[s];

	monocase(s);

	source = s;
	for (i = 0; i < WORDLISTS && code[i + CONTEXT] != 0; ++i) {
		link = searchwordlist(word, code[code[i + CONTEXT]]);
		if (link != 0) return link ;
	}

	return 0;
}

int shelve(void)
{
	int result;
	if (shelf + name[finger] >= pocket) shelf = wall ;
	move(&name[shelf], &name[finger], name[finger] + 1);
	result = shelf, shelf += name[finger] + 1;
	return result;
}

int searchwordlist(unsigned char * word, int last)
{
	int link;
	unsigned char *str, *pat;
	int n;

	link = last;

	for (;;) {
		str = word, pat = &name[code[link+1]];
		if ((n = *word) == *pat) {
			while (n && *++str == *++pat)
				--n;
			if (n == 0) break ;
		}
		link = code[link];
	}
	return link;
}

void    restart(void)
{   /* Back out of everything. */
	if (usrout != stdout)
		fclose(usrout);
	usrout = stdout;
	while (files) {
		if (usrin != stdin)
			fclose(usrin);
		usrin = file[--files];
	}
	if (usrin != stdin)
		fclose(usrin);
	usrin = stdin;
	cp = cpp = CS;
	if (progress)
		current = progress, progress = 0;
	if (state)
		next = current, here = dataspace, finger = namespace;
	while (char() != EOL) ;
	anonymous = state = FALSE, level = 0;
	longjmp(jmpbuf, 1);
}

void    sorry(char *error)
{   /* Display error message, then skip everything to newline.*/
	fprintf(stderr, "%s ", error);
	type(&name[source+1],name[source]);
	S = stack; top = * S = 0;
	F = fstack;
	restart();
}

void    type(unsigned char * str, int n)
{   /* Display n chars of str.*/
	while (n -- > 0) emit(* str++) ;
}

static void na_over_b(unsigned long, unsigned long, unsigned long);

void scale(void)
{
	int sq = 0, sr = 0;
	unsigned long n, a, b;
	b = top < 0 ? (sq = sr = 1, -top) : top;
	a = *S < 0 ? (sq ^= 1, -*S--) : *S--;
	n = *S < 0 ? (sq ^= 1, -*S) : *S;
	na_over_b(n, a, b);
	if (sq) top = -top ;
	if (sq ^ sr) *S = -*S ;
}

/*
D. E. Knuth, _The Stanford GraphBase_, Addison-Wesley, ISBN 0-201-54275-7, p.322.

Integer scaling. Here's a general-purpose routine to compute floor[na/b]
exactly without risking integer overflow, given integers n >= 0 and
0 < a <= b. The idea is to solve the problem first for n/2, if n is
too large.

We are careful to precompute values so that integer overflow cannot
occur when b is very large.
*/

#define el_gordo 0x7fffffff

static /* long */ void na_over_b(unsigned long n, unsigned long a, unsigned  long b)
{
	unsigned long nmax = (unsigned long) el_gordo / a; /* The largest n so that na doesn't overflow. */
	unsigned long r, k, q, br;
	unsigned long a_thresh, b_thresh;
	unsigned long bit = 0;

	if (n <= nmax) {
		/* return (n * a) / b; */
		top = (n * a) / b;
		*S = (n * a) % b;
		return;
	}
	a_thresh = b - a; b_thresh = (b + 1) >> 1;  /* ceil[b/2] */
	k = 0;
	do  {
		bit <<= 1;
		bit |= n & 1;
		n >>= 1;
		k++;
	} while (n > nmax);
	r = n * a; q = r / b; r = r - q * b;
	/* Maintain quotient q and remainder r while increasing n back to
	its original value. */
	do  {
		k--;
		q <<= 1;
		if (r < b_thresh)
			r <<= 1;
		else
			q++, br = (b - r) << 1, r = b - br;
		if (bit & 1)  {
			if (r < a_thresh)
			r += a;
			else
			q++, r -= a_thresh;
		}
		bit >>= 1;
	} while (k);
	/* return q; */
	top = q;
	*S = r;
}

void    parseword(int delimiter)
{
	int c;
	int n = 0;
	if (delimiter == SPACE) {
		while ((c = char()) != EOF && c != EOL && ! isgraph(c)) ;
		if (c != EOF) unchar(c) ;
		while (isgraph(c = char()))
			if (n < COUNTED_STRING_MAX)
				name[++ n + finger] = c;
		if (c == EOL && n) unchar(EOL) ;
	} else {
		while ((c = char()) != EOF && c != EOL && c == delimiter) ;
		if (c != EOF) unchar(c) ;
		while ((c = char()) != EOF && c != EOL && c != delimiter)
			if (n < COUNTED_STRING_MAX)
				name[++ n + finger] = c ;
		if (c == EOL && delimiter != EOL) unchar(EOL) ;
	}
	name[finger] = n;
}

void    parse(int delimiter)
{
	int c;
	int n = 0;
	while ((c = char()) != EOF && c != EOL && c != delimiter)
		if (n < COUNTED_STRING_MAX)
			name[++ n + finger] = c ;
	if (c == EOL && delimiter != EOL) unchar(EOL) ;
	name[finger] = n;
}
#define CELL_SIZE ((sizeof(long) / sizeof(char)) * CHAR_BIT)
#define HALF_CELL_SIZE (CELL_SIZE / 2)

#define lowpart(t) ((unsigned long) (t) & ((1L << HALF_CELL_SIZE) - 1))
#define highpart(t) ((unsigned long) (t) >> HALF_CELL_SIZE)

void umul(void)
{
	unsigned long x0, x1, x2, x3;
	unsigned long ul, vl, uh, vh;

	ul = lowpart(top);
	uh = highpart(top);
	vl = lowpart(* S);
	vh = highpart(* S);

	x0 = ul * vl;
	x1 = ul * vh;
	x2 = uh * vl;
	x3 = uh * vh;

	x1 += highpart(x0);
	x1 += x2;
	if (LOWER(x1, x2))      /* Did we get a carry? */
		x3 += 1L << HALF_CELL_SIZE; /* Yes, add it in the proper posn. */

	top = x3 + highpart(x1);
	* S = lowpart(x1) << HALF_CELL_SIZE | lowpart(x0);
}

void smul(void)
{
	long multiplicand = *S, multiplier = top;
	umul();
	if (multiplier < 0) top -= multiplicand ;
	if (multiplicand < 0) top -= multiplier ;
}

# define SlideDivisor(slide,divisor) do { \
	slide = 0;\
	if (! (divisor & 0xFFFF0000)) \
		slide += 16, divisor <<= 16; \
	if (! (divisor & 0xFF000000)) \
		slide += 8, divisor <<= 8; \
	if (! (divisor & 0xF0000000)) \
		slide += 4, divisor <<= 4; \
	if (! (divisor & 0xC0000000)) \
		slide += 2, divisor <<= 2; \
	if (! (divisor & 0x80000000)) \
		slide += 1, divisor <<= 1; \
	} while(0)

void udiv(void)
{
	unsigned long high_dividend, low_dividend, divisor;
	unsigned long d1, d0, q1, q0, r1, r0, m;
	int slide;
	divisor = top, high_dividend = *S--, low_dividend = *S;
	if (!LOWER(high_dividend,divisor)) sorry("(Divide overflow)");
	if (! high_dividend) {
		top = low_dividend / divisor;
		*S = low_dividend % divisor;
	} else {
		SlideDivisor(slide, divisor);
		if (slide) {
			high_dividend <<= slide;
			high_dividend |= low_dividend >> (CELL_SIZE - slide);
			low_dividend <<= slide;
		}
		d1 = highpart(divisor);
		d0 = lowpart(divisor);
		r1 = high_dividend % d1;
		q1 = high_dividend / d1;
		m = (unsigned long) q1 * d0;
		r1 = r1 << HALF_CELL_SIZE | highpart(low_dividend);
		if (LOWER(r1, m)) {
			q1--, r1 += divisor;
			if (!LOWER(r1, divisor) && LOWER(r1, m))
				q1--, r1 += divisor;
		}
		r1 -= m;
		r0 = r1 % d1;
		q0 = r1 / d1;
		m = (unsigned long) q0 * d0;
		r0 = r0 << HALF_CELL_SIZE | lowpart(low_dividend);
		if (LOWER(r0, m)) {
			q0--, r0 += divisor;
			if (!LOWER(r0, divisor) && LOWER(r0, m))
				q0--, r0 += divisor;
		}
		r0 -= m;
		top = (unsigned long) q1 << HALF_CELL_SIZE | q0;
		* S = r0 >> slide;
	}
}

# define	ABS(x)	((x) < 0 ? -(x) : (x))

void sdiv(void)
{
	long divi = *S, divisor = top;
	if (*S < 0)
		if (S[-1])
			S[-1] = -S[-1], *S = ~*S;
		else
			*S = -*S;
	top = ABS(top);
	udiv();
	if ((divi ^ divisor) < 0) top = -top ;
	if (divi < 0) *S = -*S ;
}

void fdiv(void)
{
	
	long divi = *S, divisor = top;
	if (*S < 0)
		if (S[-1])
			S[-1] = -S[-1], *S = ~*S;
		else
			*S = -*S;
	top = ABS(top);
	udiv();
	if (divisor < 0) *S = -*S;
	if ((divi ^ divisor) < 0)  {
		top = -top;
		if (*S)  {
			--top;
			*S = divisor - *S;
		}
	}
}

long IntSqrt(long x)
{   /* Nearest integer to 1024 * the square root of x */
	register long y, m, q = 2;
	int k;
	if (x <= 0) return 0 ;
	for (k = 25, m = 0x20000000; x < m; k --, m >>= 2) ;
	y = (x >= m + m) ? 1 : 0;
	do {
		y += (x & m) ? y + 1 : y;
		m >>= 1;
		y += (x & m) ? y - q + 1 : y - q;
		q += q;
		if (y > q)
			y -= q, q += 2;
		else if (y <= 0)
			q -= 2, y += q;
		m >>= 1;
	} while (--k);
	return q >> 1;
}

# define	todigit(c) ((unsigned) ((c) - '0') < 10 ? (c) - '0':\
	(unsigned) (((c)|0x20) - 'a') < 26 ? ((c)|0x20) - 'a' + 10 : -1)

long tonumber(char *nptr, char **endptr, int base)
{
	long x;
	int c;
	int d;
	int sign;
	char *s = nptr;
	char *str;

	sign = *s == '-' ? *s++ : '+';
	str = s;

	for (x = 0; (c = *s) != 0; ++s) {
		d = todigit(c);
		if (! ((unsigned) d < base)) break;
		x = x * base + d;
	}
	if (sign == '-') x = -x;
	if (endptr) {
		if (s == str)
			*endptr = nptr;
		else
			*endptr = s;
	}
	return x;
}

/** @(#)memmove.c after P. J. Plauger, _The Standard C Library_ **/

void * (move)(void * dest, void * src, long len)
{
	char * whither = dest;
	const char * whence = src;

	if (whence < whither && whither < whence + len)
		for (whither += len, whence += len; len > 0; --len)
			*--whither = *--whence;
	else
		for( ; len > 0; --len)
			*whither++ = *whence++;
	return dest;
}
