/* file objects */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

#include "fools.h"
#include "parser.h"

#ifndef lint
static char SccsId[] = "@(#)File.c	1.8 2/12/90";
#endif /* lint */
    
/* reset parsing flags */
void fileReset(f)
     Obj f;
{
    ASSERT(objIsClass(f, File) && objFile(f));

    setCond(f, QUERY);
    clearCond(f, MORE);
    clearerr(objFile(f));
}

/* destructor */
void fileDestroy(f)
     Obj f;
{
    if (DATA(f, par, fileInst))
	memFreeBlock((Ptr)DATA(f, par, fileInst), parInfoAlloc);
    if (objFile(f))
	(void)fclose(objFile(f));
}

/* close file */
void fileClose(f)
     Obj f;
{
    FILE *fp;

    if (fp = objFile(f)) {
	(void)fclose(fp);
	objFile(f) = (FILE *)NULL;
    }
}

/* make a file object out of a file ptr
 *
 * File objects are really only necessary for input streams.
 * prompt is the prompt string.
 * more is the prompt when input is not complete.
 * writeonly TRUE if the file will only be used for writing. */
Obj newFile(alloc, file, writeonly)
     F_OBJ alloc;
     FILE *file;
     Boolean writeonly;
{
    Obj f;

    f = (*alloc)(File);

    objFile(f) = file;
    if (!writeonly) {
	setCond(f, QUERY);
	DATA(f, par, fileInst) = (parInfo_t *)memCleanBlock(parInfoAlloc);
    }

    return f;
}

basicClass_t protoFile =
    DEFBASIC(Basic, fileInst_t, (F_VOID)NULL, fileDestroy, "file");
