/* @(#)error.h	1.6 1/16/90 */

/*
 * Copyright 1989 Jonathan Lee.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

/* error codes */

typedef enum error_e {
    NoInput,	/* EOF */
    Abort,	/* abort to top and print stack */
    StackOverflow, /* stack overflow */
    SigInt,	/* ^C interrupt */
    SigFPE,	/* floating point exception */
    BadParse,	/* EOF while parsing */
    BadParen,	/* unmatched right paren */
    BadBrace,	/* unmatched right brace */
    BadDot,	/* dot in illegal position */
    BadFormals,	/* bad formal parameter */
    BadArgs,	/* wrong number of args */
    BadSyntax,	/* syntax error */
    BadChar,	/* illegal character */
    BadSymbol,	/* using an undefined symbol */
    BadProc,	/* object is not a procedure */
    BadClass,	/* wrong class */
    BadFile,	/* couldn't open file */
    BadWrite,	/* couldn't write to stream */
    BadRead,	/* couldn't read from stream */
    BadVal,	/* using an inappropriate value */
    BadSplice,	/* invalid ,@ */
    Other,	/* other */
} error_code;

/* structure to hold a function and an arg on callback stack */
typedef struct callback_s {
    Ptr arg;
    F_VOID func;
} Callback_t;

/* current error code (not cleared after an error) */
extern error_code errorFlag;

extern List gcList, gcStack;

#ifdef __STDC__

/* initialize the error module */
extern void errorInit(void);

/* set error flag, print error message, reset to current error level, etc... */
extern void errorPrint(error_code code, char *fmt, ...);

/* formatted object printers.  Understands %d, %%, %s, and %O (objects). */
extern void objfPrintf(FILE *fp, char *fmt, ...);
extern void objPrintf(char *fmt, ...);

/* error call backs:   this interface provides procedures with a method
 * to clean up after an error takes control away from them.  When an error
 * occurs, all the callbacks in the callback stack are called. */

/* put a callback on the callback stack */
extern void errorPushCB(Callback_t *cb_ptr);

/* remove a callback from the callback stack */
extern void errorPopCB(void);

/* Set an error level.  The jmp_buf is registered so that all following
 * errors can return to the calling function's setjmp.
 * Only callbacks registered after the current level will be called until
 * this error level is removed. */
extern void errorSetLevel(jmp_buf buf);

/* Remove the topmost error level.  Pops the jmp_buf and restores the
 * callback and garbage stacks. */
extern void errorClearLevel(void);

/* use instead of exit */
extern void errorExit(int ret_code);

/* enable, disable, or check for SIGINT interrupts */
extern void intEnable(void);
extern void intDisable(void);
extern void intCheck(void);

#else

extern void errorInit();
/*VARARGS*/
extern void errorPrint();
/*VARARGS*/
extern void objfPrintf();
/*VARARGS*/
extern void objPrintf();
extern void errorPushCB();
extern void errorPopCB();
extern void errorSetLevel();
extern void errorClearLevel();
extern void errorExit();
extern void intEnable();
extern void intDisable();
extern void intCheck();

#endif /* defined(__STDC__) */
