'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_AddErrorInfo.man,v 1.2 90/01/15 14:58:47 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_AddErrorInfo tcl
.BS
.SH NAME
Tcl_AddErrorInfo \- record information about where an error occurred
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
char *
\fBTcl_AddErrorInfo\fR(\fIinterp, message\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter in which to record information.
.AP char *varName in
Name of desired variable.
.AP char *message in
Identifying string to record in \fBerrorInfo\fR variable.
.BE

.SH DESCRIPTION
.PP
Whenever \fBTcl_Eval\fR returns a \fBTCL_ERROR\fR return code,
it also places information in a global variable \fBerrorInfo\fR
that describes the command that was being executed when the error
occurred.  If multiple commands or procedures were nested when
the error occurred, additional information gets added to
\fBerrorInfo\fR as the \fBTCL_ERROR\fR code is passed upwards.
Eventually, \fBerrorInfo\fR will give a complete trace
of the activity that was in progress when the error occurred.
.PP
The procedure \fBTcl_AddErrorInfo\fR may be invoked to record
additional information about what was happening when an error
occurred.  For example, the \fBsource\fR command uses this
procedure to record the name of the file being processed and the
line number on which the error occurred;  for Tcl procedures, the
procedure name and line number within the procedure are recorded,
and so on.  The extra information is contained in the \fImessage\fR
argument, and is normally enclosed in parentheses.  If \fBTcl_AddErrorInfo\fR
is to be called, it should be called by code that invokes
\fBTcl_Eval\fR;  \fBTcl_AddErrorInfo\fR should be called
just after \fBTcl_Eval\fR returns \fBTCL_ERROR\fR.  In calling
\fBTcl_AddErrorInfo\fR, you may find it useful to use the \fBerrorLine\fR
field of the interpreter (see the \fBTcl_Interp\fR manual entry for
details).

.SH KEYWORDS
error, stack, trace, variable
