/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class TclClassLoader
extends ClassLoader {
    private static String pathSep = System.getProperty("file.separator");
    private static Hashtable classes = new Hashtable();
    private String[] classpath;
    private String[] loadpath;

    TclClassLoader(Interp interp, TclObject tclObject) {
        try {
            TclObject tclObject2;
            int n;
            TclObject[] tclObjectArray;
            if (tclObject != null) {
                tclObjectArray = TclList.getElements(interp, tclObject);
                this.classpath = new String[tclObjectArray.length];
                n = 0;
                while (n < tclObjectArray.length) {
                    tclObject2 = tclObjectArray[n];
                    if (tclObject2.stringRep == null) {
                        tclObject2.stringRep = tclObject2.internalRep.toString();
                    }
                    this.classpath[n] = TclClassLoader.absolutePath(interp, tclObject2.stringRep);
                    ++n;
                }
            }
            if ((tclObjectArray = TclClassLoader.getEnvTclClasspath(interp)) != null) {
                this.loadpath = new String[tclObjectArray.length];
                n = 0;
                while (n < tclObjectArray.length) {
                    tclObject2 = tclObjectArray[n];
                    if (tclObject2.stringRep == null) {
                        tclObject2.stringRep = tclObject2.internalRep.toString();
                    }
                    this.loadpath[n] = TclClassLoader.absolutePath(interp, tclObject2.stringRep);
                    ++n;
                }
                return;
            }
        }
        catch (TclException tclException) {}
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException, SecurityException {
        Class<?> clazz = (Class<?>)classes.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {}
        if (string.startsWith("java.") || string.startsWith("tcl.")) {
            throw new SecurityException();
        }
        byte[] byArray = this.getClassFromPath(this.classpath, string);
        if (byArray == null) {
            byArray = this.getClassFromPath(this.loadpath, string);
        }
        if (byArray == null) {
            throw new ClassNotFoundException(string);
        }
        clazz = this.defineClass(string, byArray, 0, byArray.length);
        if (clazz == null) {
            throw new ClassFormatError();
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        classes.put(string, clazz);
        return clazz;
    }

    Class defineClass(String string, byte[] byArray) {
        Class<?> clazz = null;
        try {
            clazz = this.defineClass(null, byArray, 0, byArray.length);
        }
        catch (ClassFormatError classFormatError) {}
        if (clazz != null) {
            if (string == null) {
                string = clazz.getName();
            }
            classes.put(string, clazz);
        }
        return clazz;
    }

    private byte[] getClassFromPath(String[] stringArray, String string) {
        int n = 0;
        byte[] byArray = null;
        if (stringArray != null) {
            String string2;
            while ((n = string.indexOf(".", n)) != -1) {
                string = String.valueOf(string.substring(0, n)) + pathSep + string.substring(n + 1);
            }
            string = String.valueOf(string) + ".class";
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].toString();
                try {
                    if (string2.endsWith(".jar") || string2.endsWith(".zip")) {
                        byArray = this.extractClassFromJar(string2, string);
                        if (byArray != null) {
                            return byArray;
                        }
                    } else {
                        File file = new File(string2, string);
                        if (file.exists()) {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            byArray = new byte[fileInputStream.available()];
                            fileInputStream.read(byArray);
                            return byArray;
                        }
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n].toString();
                try {
                    byArray = this.getClassFromJar(string2, string);
                    if (byArray != null) {
                        return byArray;
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
        }
        return null;
    }

    private byte[] getClassFromJar(String string, String string2) throws IOException {
        byte[] byArray = null;
        JarFilenameFilter jarFilenameFilter = new JarFilenameFilter();
        String[] stringArray = new File(string).list(jarFilenameFilter);
        int n = 0;
        while (n < stringArray.length) {
            byArray = this.extractClassFromJar(String.valueOf(string) + pathSep + stringArray[n], string2);
            if (byArray != null) break;
            ++n;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] extractClassFromJar(String string, String string2) throws IOException {
        byte[] byArray;
        ZipInputStream zipInputStream;
        block5: {
            byte[] byArray2;
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            try {
                ZipEntry zipEntry;
                do {
                    if ((zipEntry = zipInputStream.getNextEntry()) != null) continue;
                    byArray = null;
                    break block5;
                } while (!string2.equals(zipEntry.getName()));
                int n = this.getEntrySize(string, string2);
                byte[] byArray3 = new byte[n];
                int n2 = zipInputStream.read(byArray3);
                while (true) {
                    if (n2 == n) {
                        byArray2 = byArray3;
                        Object var10_10 = null;
                        break;
                    }
                    n2 += zipInputStream.read(byArray3, n2, n - n2);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                zipInputStream.close();
                throw throwable;
            }
            zipInputStream.close();
            return byArray2;
        }
        Object var10_11 = null;
        zipInputStream.close();
        return byArray;
    }

    private int getEntrySize(String string, String string2) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!string2.equals(zipEntry.getName())) continue;
            zipFile.close();
            return (int)zipEntry.getSize();
        }
        return -1;
    }

    private static TclObject[] getEnvTclClasspath(Interp interp) throws TclException {
        TclObject tclObject = interp.varFrame.getVar("env", "TCL_CLASSPATH", 2049);
        if (tclObject != null) {
            return TclList.getElements(interp, tclObject);
        }
        return null;
    }

    private static String absolutePath(Interp interp, String string) throws TclException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            String string2 = String.valueOf(interp.getWorkingDir().toString()) + System.getProperty("file.separator") + string;
            file = new File(string2);
        }
        return file.toString();
    }

    void removeCache(String string) {
        classes.remove(string);
    }
}

