/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;

class FileCmd
implements Command {
    static Class procClass = null;
    private static final String[] validCmds = new String[]{"atime", "attributes", "copy", "delete", "dirname", "executable", "exists", "extension", "isdirectory", "isfile", "join", "lstat", "mtime", "mkdir", "nativename", "owned", "pathtype", "readable", "readlink", "rename", "rootname", "size", "split", "stat", "tail", "type", "volumes", "writable"};
    private static final int OPT_ATIME = 0;
    private static final int OPT_ATTRIBUTES = 1;
    private static final int OPT_COPY = 2;
    private static final int OPT_DELETE = 3;
    private static final int OPT_DIRNAME = 4;
    private static final int OPT_EXECUTABLE = 5;
    private static final int OPT_EXISTS = 6;
    private static final int OPT_EXTENSION = 7;
    private static final int OPT_ISDIRECTORY = 8;
    private static final int OPT_ISFILE = 9;
    private static final int OPT_JOIN = 10;
    private static final int OPT_LSTAT = 11;
    private static final int OPT_MTIME = 12;
    private static final int OPT_MKDIR = 13;
    private static final int OPT_NATIVENAME = 14;
    private static final int OPT_OWNED = 15;
    private static final int OPT_PATHTYPE = 16;
    private static final int OPT_READABLE = 17;
    private static final int OPT_READLINK = 18;
    private static final int OPT_RENAME = 19;
    private static final int OPT_ROOTNAME = 20;
    private static final int OPT_SIZE = 21;
    private static final int OPT_SPLIT = 22;
    private static final int OPT_STAT = 23;
    private static final int OPT_TAIL = 24;
    private static final int OPT_TYPE = 25;
    private static final int OPT_VOLUMES = 26;
    private static final int OPT_WRITABLE = 27;
    private static final String[] validOptions = new String[]{"-force", "--"};
    private static final int OPT_FORCE = 0;
    private static final int OPT_LAST = 1;

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option name ?arg ...?");
        }
        int n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[1], (String[])validCmds, (String)"option", (int)0);
        File file = null;
        switch (n) {
            case 0: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                int n2 = FileCmd.getMtime(interp, tclObjectArray[2].toString(), file);
                interp.setResult(TclInteger.newInstance((int)n2));
                return;
            }
            case 1: {
                throw new TclException(interp, "sorry, \"file attributes\" is not implemented yet");
            }
            case 2: {
                FileCmd.fileCopyRename(interp, tclObjectArray, true);
                return;
            }
            case 3: {
                FileCmd.fileDelete(interp, tclObjectArray);
                return;
            }
            case 4: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = tclObjectArray[2].toString();
                TclObject[] tclObjectArray2 = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, string));
                if (tclObjectArray2.length > 1) {
                    String string2 = FileUtil.joinPath(interp, tclObjectArray2, 0, tclObjectArray2.length - 1);
                    if (string2 == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)string2));
                    return;
                }
                if (tclObjectArray2.length == 0 || FileUtil.getPathType(string) == 0) {
                    if (JACL.PLATFORM == 2) {
                        if (":" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance((String)":"));
                        return;
                    }
                    if ("." == null) {
                        interp.resetResult();
                        return;
                    }
                    interp.setResult(TclString.newInstance((String)"."));
                    return;
                }
                String string3 = tclObjectArray2[0].toString();
                if (string3 == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string3));
                return;
            }
            case 5: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                boolean bl = false;
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                if (file.exists()) {
                    String string;
                    bl = file.isDirectory();
                    if (bl) {
                        interp.setResult(TclBoolean.newInstance((boolean)bl));
                        return;
                    }
                    bl = Util.isWindows() ? (string = tclObjectArray[2].toString()).endsWith(".exe") || string.endsWith(".com") || string.endsWith(".bat") : (Util.isMac() ? true : true);
                }
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
            case 6: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                boolean bl = file.exists();
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = FileCmd.getExtension(tclObjectArray[2].toString());
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                boolean bl = file.isDirectory();
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
            case 9: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                boolean bl = file.isFile();
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
            case 10: {
                String string = FileUtil.joinPath(interp, tclObjectArray, 2, tclObjectArray.length);
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 11: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name varName");
                }
                throw new TclException(interp, "file command with opt " + tclObjectArray[1].toString() + " is not yet implemented");
            }
            case 12: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                int n3 = FileCmd.getMtime(interp, tclObjectArray[2].toString(), file);
                interp.setResult(TclInteger.newInstance((int)n3));
                return;
            }
            case 13: {
                FileCmd.fileMakeDirs(interp, tclObjectArray);
                return;
            }
            case 14: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = FileUtil.translateFileName(interp, tclObjectArray[2].toString());
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 15: {
                boolean bl;
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                if (!file.exists()) {
                    bl = false;
                } else {
                    boolean bl2 = !Util.isMac() && !Util.isWindows();
                    bl = true;
                }
                boolean bl3 = bl;
                interp.setResult(TclBoolean.newInstance((boolean)bl3));
                return;
            }
            case 16: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                switch (FileUtil.getPathType(tclObjectArray[2].toString())) {
                    case 0: {
                        if ("relative" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance((String)"relative"));
                        return;
                    }
                    case 1: {
                        if ("volumerelative" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance((String)"volumerelative"));
                        return;
                    }
                    case 2: {
                        if ("absolute" == null) {
                            interp.resetResult();
                            return;
                        }
                        interp.setResult(TclString.newInstance((String)"absolute"));
                    }
                }
                return;
            }
            case 17: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                boolean bl = file.canRead();
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
            case 18: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                throw new TclException(interp, "file command with opt " + tclObjectArray[1].toString() + " is not yet implemented");
            }
            case 19: {
                FileCmd.fileCopyRename(interp, tclObjectArray, false);
                return;
            }
            case 20: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = tclObjectArray[2].toString();
                String string4 = FileCmd.getExtension(string);
                int n4 = string.length() - string4.length();
                String string5 = string.substring(0, n4);
                if (string5 == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string5));
                return;
            }
            case 21: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                if (!file.exists()) {
                    throw new TclPosixException(interp, 2, true, "could not read \"" + tclObjectArray[2].toString() + "\"");
                }
                int n5 = (int)file.length();
                interp.setResult(TclInteger.newInstance((int)n5));
                return;
            }
            case 22: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                interp.setResult(FileUtil.splitPath(interp, tclObjectArray[2].toString()));
                return;
            }
            case 23: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name varName");
                }
                FileCmd.getAndStoreStatData(interp, tclObjectArray[2].toString(), tclObjectArray[3].toString());
                return;
            }
            case 24: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                String string = FileCmd.getTail(interp, tclObjectArray[2].toString());
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 25: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                String string = FileCmd.getType(interp, tclObjectArray[2].toString(), file);
                if (string == null) {
                    interp.resetResult();
                    return;
                }
                interp.setResult(TclString.newInstance((String)string));
                return;
            }
            case 26: {
                throw new TclException(interp, "sorry, \"file volumes\" is not implemented yet");
            }
            case 27: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "name");
                }
                file = FileUtil.getNewFileObj(interp, tclObjectArray[2].toString());
                boolean bl = file.canWrite();
                interp.setResult(TclBoolean.newInstance((boolean)bl));
                return;
            }
        }
        throw new TclRuntimeError("file command with opt " + tclObjectArray[1].toString() + " is not implemented");
    }

    private static boolean isOwner(Interp interp, File file) throws TclException {
        if (!file.exists()) {
            return false;
        }
        boolean bl = !Util.isMac() && !Util.isWindows();
        return true;
    }

    private static int getMtime(Interp interp, String string, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        return (int)file.lastModified();
    }

    private static String getType(Interp interp, String string, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        if (file.isFile()) {
            return "file";
        }
        if (file.isDirectory()) {
            return "directory";
        }
        return "link";
    }

    private static void getAndStoreStatData(Interp interp, String string, String string2) throws TclException {
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "could not read \"" + string + "\"");
        }
        try {
            int n = FileCmd.getMtime(interp, string, file);
            TclObject tclObject = TclInteger.newInstance((int)n);
            TclObject tclObject2 = TclInteger.newInstance((int)n);
            TclObject tclObject3 = TclInteger.newInstance((int)n);
            Var.setVar(interp, string2, "atime", tclObject2, 512);
            Var.setVar(interp, string2, "ctime", tclObject3, 512);
            Var.setVar(interp, string2, "mtime", tclObject, 512);
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.getMessage());
        }
        catch (TclException tclException) {
            throw new TclException(interp, "can't set \"" + string2 + "(dev)\": variable isn't array");
        }
        try {
            TclObject tclObject = TclInteger.newInstance((int)((int)file.length()));
            Var.setVar(interp, string2, "size", tclObject, 512);
        }
        catch (Exception exception) {}
        try {
            TclObject tclObject = TclString.newInstance((String)FileCmd.getType(interp, string, file));
            Var.setVar(interp, string2, "type", tclObject, 512);
        }
        catch (Exception exception) {}
        try {
            boolean bl;
            if (!file.exists()) {
                bl = false;
            } else {
                boolean bl2 = !Util.isMac() && !Util.isWindows();
                bl = true;
            }
            TclObject tclObject = TclBoolean.newInstance((boolean)bl);
            Var.setVar(interp, string2, "uid", tclObject, 512);
            return;
        }
        catch (TclException tclException) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static String getExtension(String var0) {
        if (var0.length() < 1) {
            return "";
        }
        var1_1 = -1;
        switch (JACL.PLATFORM) {
            case 1: {
                var2_2 = var0.replace('\\', '/').replace(':', '/');
                var1_1 = var2_2.lastIndexOf(47);
                break;
            }
            case 2: {
                var1_1 = var0.lastIndexOf(58);
                if (var1_1 != -1) break;
                var1_1 = var0.lastIndexOf(47);
                break;
            }
            default: {
                var1_1 = var0.lastIndexOf(47);
            }
        }
        if (++var1_1 >= var0.length()) {
            return "";
        }
        var2_2 = var0.substring(var1_1);
        var3_3 = var2_2.lastIndexOf(46);
        if (var3_3 != -1) ** GOTO lbl23
        return "";
lbl-1000:
        // 1 sources

        {
            --var3_3;
lbl23:
            // 2 sources

            ** while (var3_3 > 0 && var2_2.charAt((int)(var3_3 - 1)) == '.')
        }
lbl24:
        // 1 sources

        return var2_2.substring(var3_3);
    }

    private static String getTail(Interp interp, String string) throws TclException {
        TclObject tclObject = FileUtil.splitAndTranslate(interp, string);
        int n = TclList.getLength(interp, tclObject) - 1;
        if (n >= 0 && (n > 0 || FileUtil.getPathType(string) == 0)) {
            TclObject tclObject2 = TclList.index(interp, tclObject, n);
            return tclObject2.toString();
        }
        return "";
    }

    private static void fileMakeDirs(Interp interp, TclObject[] tclObjectArray) throws TclException {
        boolean bl = false;
        int n = 2;
        while (n < tclObjectArray.length) {
            String string = tclObjectArray[n].toString();
            if (string.length() == 0) {
                throw new TclPosixException(interp, 2, true, "can't create directory \"\"");
            }
            File file = FileUtil.getNewFileObj(interp, string);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new TclPosixException(interp, 17, true, "can't create directory \"" + string + "\"");
                }
            } else {
                try {
                    bl = file.mkdir();
                    if (!bl) {
                        bl = file.mkdirs();
                    }
                }
                catch (SecurityException securityException) {
                    throw new TclException(interp, securityException.getMessage());
                }
                if (!bl) {
                    throw new TclPosixException(interp, 13, true, "can't create directory \"" + string + "\":  best guess at reason");
                }
            }
            ++n;
        }
    }

    private static void fileDelete(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        boolean bl = false;
        int n2 = 2;
        boolean bl2 = false;
        while (n2 < tclObjectArray.length && !bl2) {
            if (!tclObjectArray[n2].toString().startsWith("-")) break;
            n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n2], (String[])validOptions, (String)"option", (int)1);
            switch (n) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + n + " index to validOptions");
                }
            }
            ++n2;
        }
        if (n2 >= tclObjectArray.length) {
            throw new TclNumArgsException(interp, 2, tclObjectArray, "?options? file ?file ...?");
        }
        n = n2;
        while (n < tclObjectArray.length) {
            FileCmd.deleteOneFile(interp, tclObjectArray[n].toString(), bl);
            ++n;
        }
    }

    private static void deleteOneFile(Interp interp, String string, boolean bl) throws TclException {
        boolean bl2 = true;
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists() || string.length() == 0) {
            return;
        }
        if (file.isDirectory() && file.list().length > 0) {
            if (bl) {
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    TclObject[] tclObjectArray = new TclObject[]{TclString.newInstance((String)string), TclString.newInstance((String)stringArray[n])};
                    String string2 = FileUtil.joinPath(interp, tclObjectArray, 0, 2);
                    FileCmd.deleteOneFile(interp, string2, bl);
                    ++n;
                }
            } else {
                throw new TclPosixException(interp, 66, "error deleting \"" + string + "\": directory not empty");
            }
        }
        try {
            bl2 = file.delete();
        }
        catch (SecurityException securityException) {
            throw new TclException(interp, securityException.getMessage());
        }
        if (!bl2) {
            throw new TclPosixException(interp, 13, true, "error deleting \"" + string + "\":  best guess at reason");
        }
    }

    private static void fileCopyRename(Interp interp, TclObject[] tclObjectArray, boolean bl) throws TclException {
        int n;
        int n2 = 2;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n2 < tclObjectArray.length && !bl3) {
            if (!tclObjectArray[n2].toString().startsWith("-")) break;
            n = TclIndex.get((Interp)interp, (TclObject)tclObjectArray[n2], (String[])validOptions, (String)"option", (int)1);
            switch (n) {
                case 0: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl3 = true;
                    break;
                }
                default: {
                    throw new TclRuntimeError("FileCmd.cmdProc: bad option " + n + " index to validOptions");
                }
            }
            ++n2;
        }
        if (n2 >= tclObjectArray.length - 1) {
            throw new TclNumArgsException(interp, n2, tclObjectArray, "?options? source ?source ...? target");
        }
        n = tclObjectArray.length - 1;
        String string = tclObjectArray[n].toString();
        File file = FileUtil.getNewFileObj(interp, string);
        if (file.isDirectory()) {
            int n3 = n2;
            while (n3 < n) {
                String string2 = tclObjectArray[n3].toString();
                if (string.length() == 0) {
                    FileCmd.copyRenameOneFile(interp, string2, string, bl, bl2);
                } else {
                    String string3 = FileCmd.getTail(interp, string2);
                    TclObject[] tclObjectArray2 = new TclObject[]{TclString.newInstance((String)string), TclString.newInstance((String)string3)};
                    String string4 = FileUtil.joinPath(interp, tclObjectArray2, 0, 2);
                    FileCmd.copyRenameOneFile(interp, string2, string4, bl, bl2);
                }
                ++n3;
            }
            return;
        }
        if (n2 + 1 != n) {
            String string5 = bl ? "copying" : "renaming";
            throw new TclPosixException(interp, 20, "error " + string5 + ": target \"" + tclObjectArray[n].toString() + "\" is not a directory");
        }
        String string6 = tclObjectArray[n2].toString();
        FileCmd.copyRenameOneFile(interp, string6, string, bl, bl2);
    }

    private static void copyRenameOneFile(Interp interp, String string, String string2, boolean bl, boolean bl2) throws TclException {
        if (bl2 && string.equals(string2)) {
            return;
        }
        String string3 = bl ? "copying" : "renaming";
        File file = FileUtil.getNewFileObj(interp, string);
        if (!file.exists() || string.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\"");
        }
        if (string2.length() == 0) {
            throw new TclPosixException(interp, 2, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        File file2 = FileUtil.getNewFileObj(interp, string2);
        if (file2.exists() && !bl2) {
            throw new TclPosixException(interp, 17, true, "error " + string3 + " \"" + string + "\" to \"" + string2 + "\"");
        }
        if (file.isDirectory() && !file2.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite file \"" + string2 + "\" with directory \"" + string + "\"");
        }
        if (file2.isDirectory() && !file.isDirectory()) {
            throw new TclPosixException(interp, 21, "can't overwrite directory \"" + string2 + "\" with file \"" + string + "\"");
        }
        if (!bl) {
            if (!file.renameTo(file2)) {
                throw new TclPosixException(interp, 13, true, "error renaming \"" + string + "\" to \"" + string2 + "\":  best guess at reason");
            }
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                char[] cArray = new char[256];
                int n = 0;
                int n2 = bufferedReader.read(cArray, 0, 256);
                while (n2 != -1) {
                    bufferedWriter.write(cArray, n, n2);
                    n2 = bufferedReader.read(cArray, n += 256, 256);
                }
                bufferedReader.close();
                bufferedWriter.close();
                return;
            }
            catch (Exception exception) {
                throw new TclException(interp, "error copying: " + exception.getMessage());
            }
        }
    }

    FileCmd() {
    }
}

