#
#  VMS MMS build file for PS utilities
#
#  Hunter Goatley, 16-MAR-1993 14:47
#
CFLAGS = /NOLIST/OBJECT=$(MMS$TARGET)
LFLAGS = /NOTRACE/EXEC=$(MMS$TARGET)

.IFDEF __ALPHA__               #If building with Alpha cross-compilers, OBJ
OPTIONS_FILE =                  #... is defined already
LINKOPT =
CFLAGS = /NOLIST/OBJECT=$(MMS$TARGET)/STANDARD=VAXC
.ELSE
OBJ = .OBJ
EXE = .EXE
OPTIONS_FILE = ,VAXC.OPT
LINKOPT = $(options_file)/OPTIONS
.ENDIF

# epsffit fits an epsf file to a given bounding box
# psbook rearranges pages into signatures
# psselect selects page ranges
# pstops performs general page rearrangement and merging

all : psbook$(exe), psselect$(exe), pstops$(exe), epsffit$(exe)
        @ write sys$output "PSUTILS build complete"

epsffit$(exe) : epsffit$(obj)$(options_file)
        $(LINK)$(LFLAGS) $(MMS$SOURCE)$(linkopt)

psbook$(exe) :  psbook$(obj), psutil$(obj)$(options_file)
        $(LINK)$(LFLAGS) psbook$(obj),psutil$(obj)$(linkopt)

psselect$(exe) :        psselect$(obj), psutil$(obj)
        $(LINK)$(LFLAGS) psselect$(obj),psutil$(obj)$(linkopt)

pstops$(exe) :  pstops$(obj), psutil$(obj)
        $(LINK)$(LFLAGS) pstops$(obj),psutil$(obj)$(linkopt)

psbook$(obj) : psbook.c psutil.h patchlevel.h

pstops$(obj) : pstops.c, psutil.h patchlevel.h

psutil$(obj) : psutil.c, psutil.h patchlevel.h

psselect$(obj) : psselect.c, psutil.h patchlevel.h

clean :
        delete/log *$(obj);*,psbook$(exe);*,psselect$(exe);*,pstops$(exe);*,epsf
fit$(e
xe);*

