/* CDDRIVE.C - Programmed by Maarten Hofman */
/* 120793: Started programming */
/* 130793: Continued programming */

#include <alloc.h>
#include "cdrom.h"
#include "cddrive.h"

int lasterror,lastbusy,lastdone;
unsigned char qchannel[11],upccode[13],audio[9];

int query_error(void) {
  return lasterror;
}

int query_busy(void) {
  return lastbusy;
}

int query_done(void) {
  return lastdone;
}

static void check_status(unsigned int status) {
  lasterror=(status&0x8000)?(status&0x0ff):-1;
  lastbusy=(status&0x0100)?1:0;
  lastdone=(status&0x0200)?1:0;
}

static void standard_read_write_call(int drive,unsigned char *data,
				     int size,int kind) {
struct request header;

  header.length=13+sizeof(struct ioctl);
  header.subunit=0;
  header.command=kind;
  header.extra.ioctl.mdb=0;
  header.extra.ioctl.rvi=NULL;
  header.extra.ioctl.ssn=0;
  header.extra.ioctl.size=size;
  header.extra.ioctl.transfer=data;
  send_device_driver_request(drive,&header);
  check_status(header.status);
}

void play_audio(int drive,long int start,long int stop) {
struct request header;

  header.length=13+sizeof(struct audio);
  header.subunit=0;
  header.command=132;
  header.extra.audio.am=1;
  header.extra.audio.start=start;
  header.extra.audio.stop=stop;
  send_device_driver_request(drive,&header);
  check_status(header.status);
}

static void standard_audio_call(int drive,int kind) {
struct request header;

  header.length=13;
  header.subunit=0;
  header.command=kind;
  send_device_driver_request(drive,&header);
  check_status(header.status);
}

void stop_audio(int drive) {
  standard_audio_call(drive,STOP);
}

void resume_audio(int drive) {
  standard_audio_call(drive,RESUME);
}

unsigned char *audio_channel_info(int drive) {
  audio[0]=4;
  standard_read_write_call(drive,audio,9,READ);
  return(audio+1);
}

void audio_channel_control(int drive,int what,int setting) {
  audio[0]=4;
  standard_read_write_call(drive,audio,9,READ);
  if(lasterror!=NO_ERROR) return;
  audio[what+1]=setting;
  audio[0]=3;
  standard_read_write_call(drive,audio,9,WRITE);
}

int device_status(int drive) {
unsigned char data[5];
long int tussen;

  data[0]=6;
  standard_read_write_call(drive,data,5,READ);
  tussen=*(long int *)(&data[1]);
  tussen&=0x000003BF;
  return(tussen);
}

int media_changed(int drive) {
unsigned char data[2];

  data[0]=9;
  standard_read_write_call(drive,data,2,READ);
  return(data[1]);
}

int audio_disk_info(int drive,int track) {
unsigned char data[7];

  data[0]=10;
  standard_read_write_call(drive,data,7,READ);
  return(data[track]);
}

int audio_track_info(int drive,int track) {
unsigned char data[7];

  data[0]=11;
  data[1]=track;
  standard_read_write_call(drive,data,7,READ);
  return(data[6]);
}

unsigned char *audio_qchannel_info(int drive) {

  qchannel[0]=12;
  standard_read_write_call(drive,qchannel,11,READ);
  return(qchannel+1);
}

unsigned char *get_upccode(int drive) {
unsigned char data[11];
int i;

  data[0]=14;
  standard_read_write_call(drive,data,11,READ);
  if(!data[1]) {
    for(i=0;i<13;i++) upccode[i]=0;
    return(upccode);
  }
  for(i=0;i<13;i++) {
    if(i%2) {
      upccode[i]=data[i/2+2]>>8;
    }
    else {
      upccode[i]=data[i/2+2]&0x0f;
    }
  }
  return(upccode);
}

int audio_status_info(int drive) {
unsigned char data[11];
int tussen;

  data[0]=15;
  standard_read_write_call(drive,data,11,READ);
  tussen=*(int *)(&data[1]);
  return(tussen&0x0001);
}

long int get_track_address(int drive, int track) {
unsigned char data[11];
long int tussen;

  if(track==LEAD_OUT_TRACK) {
    data[0]=10;
    standard_read_write_call(drive,data,7,READ);
    tussen=*(long int *)(&data[3]);
    return(tussen);
  }
  if((track==STARTING_LOCATION)||(track==ENDING_LOCATION)) {
    data[0]=15;
    standard_read_write_call(drive,data,11,READ);
    tussen=*(long int *)((track==STARTING_LOCATION)?(&data[3]):(&data[7]));
    return(tussen);
  }
  data[0]=11;
  data[1]=track;
  standard_read_write_call(drive,data,7,READ);
  tussen=*(long int *)(&data[2]);
  return(tussen);
}

void eject_disk(int drive) {
unsigned char data;

  data=0;
  standard_read_write_call(drive,&data,1,WRITE);
}

void close_tray(int drive) {
unsigned char data;

  data=5;
  standard_read_write_call(drive,&data,1,WRITE);
}

void lock_unlock_door(int drive,int door) {
unsigned char data[2];

  data[0]=1;
  data[1]=door;
  standard_read_write_call(drive,data,2,WRITE);
}

void reset_drive(int drive) {
unsigned char data;

  data=2;
  standard_read_write_call(drive,&data,1,WRITE);
}

long int redbook_to_hsg(long int redbook) {
long int frame,second,minute;

  frame=redbook&0x000000ff;
  second=(redbook&0x0000ff00)>>8;
  minute=(redbook&0x00ff0000)>>16;
  return(minute*60*75+second*75+frame);
}
