#!/bin/sh
# expects arg1 to be the Postgres home directory
# expects arg2 to be the basename of the Postgres Object directory
# expects arg3 to be the port
# expects arg4 to be the identifier for "SHIP"
# expects arg5 to be the path to 'make'
#
# $Header: /private/postgres/newconf/RCS/install.sh,v 1.40 1992/08/19 08:28:46 mer Exp $


#
# Now does an installation in $POSTGRESHOME/bin if $POSTGRESHOME is
# defined
#

if (test -n "$POSTGRESHOME")
then
    if (test -d "$POSTGRESHOME")
    then
        echo "Installing in $POSTGRESHOME"
        echo
    else
        echo "Error: $POSTGRESHOME does not exist."
        exit 1
    fi
    DEST=$POSTGRESHOME
else
    echo "Installing in $1"
    echo
    DEST=$1
fi

TREE=$1
OBJ=$2
PORT=$3
SHIP=$4
MAKE=$5
EXEC_CHOWN=0
EXEC_INITDB=1

BINDIR=$DEST/bin
FILEDIR=$DEST/files
SUPODIR=$TREE/`basename $OBJ`/support
SCRIPTDIR=$TREE/src/scripts


if (test -f $BINDIR/pg_id)
then
    PG_ID=$BINDIR/pg_id
else
    PG_ID=$SUPODIR/pg_id
fi


if (test $SHIP = 1)
then
    if (test ! -f $PG_ID)
    then
        echo "Executing 'Make pg_id'..."
        $TREE/newconf/Make pg_id 
        if (test ! -f $PG_ID)
        then
            echo "Make pg_id failed - installation aborting."
            exit 1
        fi
    fi

    #
    # Test to see if the user is trying to do the install as root.
    # If the user is, we'll have to chown postgres on all the bin, files,
    # and data directories, as well as $POSTGRESHOME itself.
    #
    # If there is no Postgres user (and this will break if there is no 
    # /etc/passwd file), initdb can't be run until the installer fixes this
    # problem.
    #

    if (test "`$PG_ID`" = "0")
    then
        if (test "`grep '^postgres' /etc/passwd|sed 's/:.*//'`" = "postgres")
        then
            echo -n "Make install: NOTICE: will change ownership of files"
            echo " to user \"postgres\""
            EXEC_CHOWN=1
        else
            echo "Make install: WARNING: you are installing as root and"
            echo "there is as yet no Postgres user.  Postgres will"
            echo "NOT WORK until you change ownership (see chown(2)) of"
            echo "all files under $TREE and $TREE itself to a registered"
            echo "Postgres user, preferably \"postgres\".  The"
            echo "installation will continue, but the initial template"
            echo "database will not be created."
            echo
            EXEC_INITDB=0
        fi
    fi

    if (test ! -f $TREE/newconf/everything.stat)
    then
        echo "Executing 'Make everything'..."
        $TREE/newconf/Make everything 
        if (test $? -ne 0)
        then
            echo "Make everything failed."
            echo "installation aborting."
            exit 1
        fi
    fi
fi

if (test ! -d $BINDIR)
then
    echo "creating $BINDIR"
    mkdir $BINDIR
fi

SETUIDS="postgres postmaster"
EXECUTABLES="$SETUIDS pg_version monitor pg_id pagedoc shmemdoc"

for i in $EXECUTABLES
do
    if (test -f $SUPODIR/$i)
    then
        echo "moving file $SUPODIR/$i"
        mv $SUPODIR/$i $BINDIR
    elif (test -f $BINDIR/$i)
    then
        true
    else
        echo "File $SUPODIR/$i does not exist."
        echo "Your build may have failed"
        echo "or have not been run yet."
        exit 1
    fi
done

for i in $SETUIDS
do
	chmod 4755 $BINDIR/$i
done

SCRIPTS="createdb createdb.sh destroydb initdb vacuum createuser destroyuser"

for i in $SCRIPTS
do
    if (test ! -f $BINDIR/$i)
    then
        echo "moving file $SCRIPTDIR/$i"
        cp $SCRIPTDIR/$i $BINDIR
    fi
done

if (test ! -f $BINDIR/ipcclean)
then
    if (test -f $TREE/newconf/IPCCLEAN/ipcclean.$PORT)
    then
        cp $TREE/newconf/IPCCLEAN/ipcclean.$PORT $BINDIR/ipcclean
        echo "creating file $BINDIR/ipcclean"
        chmod 4755 $BINDIR/ipcclean
    else
        echo "File $TREE/newconf/IPCCLEAN/ipcclean.$PORT does not exist."
    fi
fi

if (test ! -d $FILEDIR)
then
    echo "creating $FILEDIR"
    mkdir $FILEDIR
fi

#
# Now create the bki files
#

if (test ! -f $FILEDIR/local1_template1.bki)
then
    if (test ! -f $SUPODIR/local.bki)
    then
        echo "$SUPODIR/local.bki does not exist.  You will need this file"
        echo "to run Postgres properly"
        exit 1
    else
        echo "Moving $SUPODIR/local.bki to $FILEDIR/local1_template1.bki"
        mv $SUPODIR/local.bki $FILEDIR/local1_template1.bki
    fi
fi

if (test ! -f $FILEDIR/global1.bki)
then
    if (test ! -f $SUPODIR/dbdb.bki)
    then
        echo "$SUPODIR/dbdb.bki does not exist.  You will need this file"
        echo "to run Postgres properly"
        exit 1
    else
        echo "Moving $SUPODIR/dbdb.bki to $FILEDIR/global1.bki"
        cat $SUPODIR/dbdb.bki | \
            sed -e "s/PGUID/`$SUPODIR/pg_uid`/g" > $FILEDIR/global1.bki
	rm -f $SUPODIR/dbdb.bki
    fi
fi

echo "Compiling demo files..."

cd $TREE/demo
if (test ! -f makefile)
then
    cat $TREE/newconf/config.mk ./makefile.source > makefile
fi
$MAKE < ./makefile
if (test $? -ne 0)
then
    echo "demo file compilation failed."
    echo "installation aborting."
    exit 1
fi

echo "Compiling video demo files..."

cd $TREE/video
cp $TREE/demo/*.o $TREE/video
if (test ! -f makefile)
then
    cat $TREE/newconf/config.mk ./makefile.source > makefile
fi
$MAKE < ./makefile
if (test $? -ne 0)
then
    echo "video demo file compilation failed."
    echo "installation aborting."
    exit 1
fi

if (test -d $TREE/test/regress)
then
    echo Compiling regression test files...
    cd $TREE/test/regress
    if (test ! -f makefile)
    then
	cat $TREE/newconf/config.mk ./makefile.source > makefile
	chmod 444 makefile
    fi
    $MAKE < ./makefile
    cd funcs
    if (test ! -f makefile)
    then
	cat $TREE/newconf/config.mk ./makefile.source > makefile
	chmod 444 makefile
    fi
    $MAKE < ./makefile
fi

echo done
cd $TREE

if (test $EXEC_CHOWN -eq 1)
then
    for i in $TREE $TREE/bin $TREE/files $TREE/bin/* $TREE/files/* \
             $TREE/demo $TREE/demo/*
    do
        echo "executing chown to postgres on $i"
        chown postgres $i
        if (test $? -ne 0)
        then
            echo "chown to postgres failed."
            echo "Postgres will NOT work as installed."
            echo "installation aborting."
            exit 1
        fi
    done
fi

if (test "$EXEC_INITDB" != 1)
then
    echo "For reasons indicated above, initdb will NOT be executed.  You will"
    echo "have to run it directly after making the above required changes."
    echo "Installation aborting."
    exit 1
fi

echo
echo "Initializing template database..." 

if (test ! -d data)
then
    $TREE/bin/initdb
    if (test $? -ne 0)
    then
        echo "initialization of template database failed."
        echo "installation aborting."
        exit 1
    fi
fi

echo
if [ $DEVELOPMENT = "f" ] 
then
	echo "Cleaning up..."
	rm -f $OBJ/*.o
fi

echo "Installation complete."
