#! /bin/sh
# ----------------------------------------------------------------
#   FILE
#	Gen_creator.sh
#
#   DESCRIPTION
#       shell script which generates the Make, IMake and RMake
#	node creator functions, as well as the Out, Copy and
#	Equal functions.
#
#   NOTES
#	This process relies on the file $TREE/$OD/lib/H/slots
#	which is generated (earlier) by inherits.sh
#
#   IDENTIFICATION
# 	$Header: /private/postgres/src/lib/Gen/RCS/Gen_creator.sh,v 1.14 1992/03/31 23:12:38 mer Exp $
# ----------------------------------------------------------------
SRC=$1
SLOTFILE=$TREE/$OD/lib/H/slots

EGREP=/usr/bin/egrep
RM=/bin/rm
SED=/bin/sed

echo "/* ---------------------------------------------------------------- "
echo " * 	node file generated from $SRC"
echo " * "
echo " * 	this file has been generated by the Gen_accessors.sh"
echo " * 	and Gen_creator.sh scripts as part of the initial node"
echo " * 	generation process."
echo " * ---------------------------------------------------------------- "
echo " */"
echo "#include \"$SRC\""
echo " "
echo "#ifdef NO_NODE_CHECKING"
echo "#define NODEAssertArg(x)"
echo "#else"
echo "#define NODEAssertArg(x)	AssertArg(x)"
echo "#endif NO_NODE_CHECKING"
echo " "

# ----------------
#	strip trash from the input file and feed the result to awk..
# ----------------
$EGREP -v '(^#|^[ 	/]*\*|typedef|Defs|inherits)' < $SRC | \
$SED -e 's/;//' \
     -e '/\/\*/,/\*\//D' \
     -e 's/\\//' | \
awk -f $TREE/$SD/lib/Gen/Gen_creat.awk $SLOTFILE -
