head	1.3;
access;
symbols;
locks
	PTI:1.3; strict;
comment	@ * @;


1.3
date	96.08.05.20.56.59;	author PTI;	state Exp;
branches;
next	1.2;

1.2
date	96.08.04.11.49.34;	author PTI;	state Exp;
branches;
next	1.1;

1.1
date	96.07.24.20.46.13;	author PTI;	state Exp;
branches;
next	;


desc
@SQL server daemon
@


1.3
log
@Added SIGILL and SIGBREAK to support WATCOM signals. If they would work it
would be grat, however, signals are not working using Watcom.
To be continued...
@
text
@/*
**      msqld.c -
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995  Hughes Technologies Pty Ltd
**
** Modifications by Dirk Ohme, Jan. 1996
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/

#ifdef OS2
#  define INCL_BASE
#  define INCL_DOS
#  define INCL_SUB
#  include <os2.h>
#  ifdef BCPP
#    define _System   _syscall
#    define _Optlink
#  endif
#  undef  APIENTRY
#  define APIENTRY _Optlink
#  define BSD_SELECT
#  include <stdlib.h>
#endif

#include <stdio.h>
#include <fcntl.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
/*#include <sys/time.h>*/
#ifdef WINSOCK
#  include <winsock.h>
#  undef SOCKET_ERROR
#else
#  include <sys/socket.h>
#  include <netinet/in.h>
#endif
#ifdef OS2
#  include <arpa/nameser.h>
#  include <stdarg.h>
#  include <direct.h>
#  include <process.h>
#endif
#ifdef WINNT
#  include <stdlib.h>
#  ifndef WINSOCK
#    include <arpa/inet.h>
#  endif
#  include <stdarg.h>
#  include <direct.h>
#  include <process.h>
#endif
#ifdef UNIX
#  include <stdlib.h>
#  include <arpa/inet.h>
#  include <varargs.h>
#endif

#include "version.h"

#include <common/portable.h>

#ifdef HAVE_SYS_UN_H
#  include <sys/un.h>
#endif

#include <signal.h>
#ifndef WINSOCK
#  include <netdb.h>

#  ifdef HAVE_SELECT_H
#    include <select.h>
#  endif

#  ifdef HAVE_SYS_SELECT_H
#    include <sys/select.h>
#  endif
#endif

#include <common/site.h>
#include <common/debug.h>

#include "msql_prv.h"
#include "errmsg.h"




extern  char    *yytext;
extern  int     yylineno;
extern  int     yydebug;

extern  char    errMsg[];

int     curSock,
        IPsock,
        UNIXsock,
        numCons;

char    *unixPort;

#ifdef OS2
#  define MAX_SOCK_NUM    2049
#elsif defined WINSOCK
#  define MAX_SOCK_NUM    256
#else
#  define MAX_SOCK_NUM    100
#endif

cinfo_t conArray[MAX_SOCK_NUM];

extern  char    *packet;
char    PROGNAME[] = "msqld",
        BLANK_ARGV[] = "                                                  ";

#define safeFree(x)  { if(x){ (void)free(x); x = NULL; } }


void sigTrap(sig)
        int     sig;
{
        int     clientSock;

        signal(sig,SIG_IGN);
        fprintf(stderr,"\nHit by a sig %d\n\n",sig);
#ifndef UNIX
        clientSock = 1;
#else
                  clientSock = 3;
#endif
                  printf("\n\nForced server shutdown due to bad signal!\n\n");
                  while(clientSock < MAX_SOCK_NUM)
        {
                if (conArray[clientSock].db)
                {
                        printf("Forcing close on Socket %d\n",clientSock);
                        shutdown(clientSock,2);
#ifdef OS2
                                                                soclose(clientSock);
#elif defined WINSOCK
                                                                closesocket(clientSock);
#else
                                                                close(clientSock);
#endif
                                         }
                clientSock++;
        }
        shutdown(IPsock,2);
#ifdef OS2
                  soclose(IPsock);
#elif defined WINSOCK
                  closesocket(IPsock);
#else
                  close(IPsock);
#endif
#ifdef HAVE_SYS_UN_H
        shutdown(UNIXsock,2);
                  close(UNIXsock);
        unlink(unixPort);
#endif
        printf("\n");
        abort();
}


sendError(fd,err)
                  char    *err;
{
#       ifdef DEBUG
                printf("Send error called\n");
#       endif
        if (err)
                sprintf(packet,"-1:%s\n",err);
        else
                sprintf(packet,"-1:%s\n",errMsg);
                  writePkt(fd);
}

sendOK(fd)
{
#       ifdef DEBUG
                                         printf("Send OK called\n");
#       endif
                  sprintf(packet,"1:\n");
                  writePkt(fd);
}


/****************************************************************************
**      _initServer
**
**      Purpose :
**      Args    :
**      Returns :
**      Notes   :
*/

initServer()
{
        int     sock,
                tcpPort,
                addrLen,
                opt;
                  struct  sockaddr_in     IPaddr;
        struct  servent         *serv_ptr;
                  char    *envVar;

#ifdef HAVE_SYS_UN_H
        struct  sockaddr_un     UNIXaddr;
#endif

                  /*
        ** Create an IP socket
        */
        tcpPort = MSQL_PORT;
                  if ((serv_ptr = getservbyname("msql", "tcp")))
                  {
                tcpPort = ntohs(serv_ptr->s_port);
                  }
                  if ((envVar = getenv("MSQL_TCP_PORT")))
                  {
                tcpPort = atoi(envVar);
                  }
        msqlDebug(MOD_GENERAL,"IP Socket is %d\n",tcpPort);
                  IPsock = socket(AF_INET, SOCK_STREAM, 0);
        if (IPsock < 0)
        {
                perror("Can't start server : IP Socket ");
                exit(1);
                  }
#ifdef SO_REUSEADDR
#  ifdef OS2
        opt = 1;
                  setsockopt(IPsock, SOL_SOCKET, SO_REUSEADDR, (char*)&opt, sizeof(int));
#  else
                  opt = 1;
                  setsockopt(IPsock, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(int));
#  endif
#endif

                  (void)bzero(&IPaddr, sizeof(IPaddr));
        IPaddr.sin_family = AF_INET;
                  IPaddr.sin_addr.s_addr = htonl(INADDR_ANY);
                  IPaddr.sin_port = htons(tcpPort);
                  if (bind(IPsock, (struct sockaddr *)&IPaddr, sizeof(IPaddr)) < 0)
        {
                                         perror("Can't start server : IP Bind ");
#ifdef WINSOCK
                                         WSACleanup();
#endif
                                         exit(1);
        }
        listen(IPsock,5);

#ifdef HAVE_SYS_UN_H
                  /*
        ** Create the UNIX socket
                  */
        unixPort = MSQL_UNIX_ADDR;
                  if ((envVar = getenv("MSQL_UNIX_PORT")))
        {
                                         unixPort = envVar;
        }

        msqlDebug(MOD_GENERAL,"UNIX Socket is %s\n",unixPort);
        UNIXsock = socket(AF_UNIX, SOCK_STREAM, 0);
        if (UNIXsock < 0)
        {
                                         perror("Can't start server : UNIX Socket ");
                                         exit(1);
                  }
        (void)bzero(&UNIXaddr, sizeof(UNIXaddr));
                  UNIXaddr.sun_family = AF_UNIX;
        strcpy(UNIXaddr.sun_path, unixPort);
                  unlink(unixPort);
        if (bind(UNIXsock, (struct sockaddr *)&UNIXaddr, sizeof(UNIXaddr)) < 0)
                  {
                perror("Can't start server : UNIX Bind ");
                                         exit(1);
                  }
                  listen(UNIXsock,5);
#endif
}



RETSIGTYPE puntServer(sig)
                  int     sig;
{
                  int     clientSock;

                  signal(sig,SIG_IGN);
#ifndef UNIX
                  clientSock = 1;
#else
                  clientSock = 3;
#endif
                  if (sig == -1)
                  {
                                         printf("\n\nNormal Server shutdown!\n\n");
                  }
                  else
                  {
                                         printf("\n\nServer Aborting!\n\n");
                  }
                  while(clientSock < MAX_SOCK_NUM)
                  {
                                         if (conArray[clientSock].db)
                                         {
                                                                printf("Forcing close on Socket %d\n",clientSock);
                                                                shutdown(clientSock,2);
#ifdef OS2
                                                                soclose(clientSock);
#elif defined WINSOCK
                                                                closesocket(clientSock);
#else
                                                                close(clientSock);
#endif
                                         }
                                         clientSock++;
                  }
                  shutdown(IPsock,2);
#ifdef OS2
                  soclose(IPsock);
#elif defined WINSOCK
                  closesocket(IPsock);
#else
                  close(IPsock);
#endif

#ifdef HAVE_SYS_UN_H
                  shutdown(UNIXsock,2);
                  close(UNIXsock);
                  unlink(unixPort);
#endif
                  printf("\n");
                  dropCache();

                  if (debugSet(MOD_MALLOC))
                  {
                                         fprintf(stderr,"\n\nmalloc() leak detection .....\n");
                                         checkBlocks(MALLOC_BLK);
                  }
                  if (debugSet(MOD_MMAP))
                  {
                                         fprintf(stderr,"\n\nmmap() leak detection .....\n");
                                         checkBlocks(MMAP_BLK);
                  }
                  printf("\n\nmSQL Daemon Shutdown Complete.\n\n");
#ifndef UNIX
                                         /*
                                          * OS2 & WINNT
                                          */
                  if (remove(PID_DIR"\\msqld.pid"))
                  {
                                         fprintf(stderr,"\n\nCouldn't remove PID file\n");
                  }
#endif
                  if (sig >= 0)
                  {
#ifdef WINSOCK
                                         WSACleanup();
#endif
                                         exit(1);
                  }
}



yyerror(s)
                  char    *s;
{
                  sprintf(packet,"-1:%s near \"%s\"\n", s, yytext?yytext:"");
                  writePkt(curSock);
                  msqlClean();
}





static int curComSock;
static fd_set *clientFdSet;

static setConnectionState(sock, fds)
                  int     sock;
        fd_set  *fds;
{
        curComSock = sock;
                  clientFdSet = fds;
}


RETSIGTYPE puntClient(sig)
        int     sig;
{
        signal(sig, puntClient);
                  if (clientFdSet)
                  {
                FD_CLR(curComSock, clientFdSet);
                                         shutdown(curComSock,2);
#ifdef OS2
                                         soclose(curComSock);
#elif defined WINSOCK
                                         closesocket(curComSock);
#else
                                         close(curComSock);
#endif
                if (conArray[curComSock].db)
                {
                                                                safeFree(conArray[curComSock].db);
                                                                safeFree(conArray[curComSock].host);
                        safeFree(conArray[curComSock].user);
                                         }
                conArray[curComSock].db = NULL;
                                         printf("Forced close of client on socket %d due to pipe sig\n",
                        curComSock);
                numCons--;
        }
}



setupSignals()
{
#ifdef SIGSEGV
                  signal(SIGSEGV,sigTrap);
#endif
#ifdef SIGBUS
                  signal(SIGBUS,sigTrap);
#endif
#ifdef SIGILL
                  signal(SIGILL,sigTrap);
#endif
#ifdef SIGINT
                  signal(SIGINT,puntServer);
#endif
#ifdef SIGBREAK
                  signal(SIGBREAK,puntServer);
#endif
#ifdef SIGQUIT
                  signal(SIGQUIT,puntServer);
#endif
#ifdef SIGKILL
                  signal(SIGKILL,puntServer);
#endif
#ifdef SIGPIPE
                  signal(SIGPIPE,puntClient);
#endif
#ifdef SIGTERM
                  signal(SIGTERM,puntServer);
#endif
#ifdef SIGHUP
                  signal(SIGHUP,SIG_IGN);
#endif
}



#ifdef OS2
int
#endif
main(argc,argv)
                  int     argc;
                  char    *argv[];
{
                  fd_set  readFDs,
                                         clientFDs;
                  int     sock         = 0,
                                         newSock      = 0,
                                         comSock      = 0,
#ifndef UNIX
                                         lowSock      = MAX_SOCK_NUM,
                                         highSock     = 0,
#endif
                                         command      = 0,
                opt          = 0,
                sig          = 0,
                                         error        = 0;
                  char    dbname[30]   = "\0",
                                         *uname       = NULL,
                                         *cp          = NULL,
                *prog        = NULL,
                *arg         = NULL,
                path[255]    = "\0";
                  FILE    *pidFile     = NULL;
#ifdef OS2
        struct stat aFileInfo;
#endif
#ifdef WINSOCK
                  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
                  WSADATA       wsaData;
                  int nErrorStatus;

                  if (WSAStartup(wVersionRequired, &wsaData) != 0)
                  {
                         printf("msqlConnect : Unable to initialise WINSOCK");
                         exit(1);
                  }
#endif


        /*
        ** We have enough space for fiddling with the argv, continue
        */
                  msqlHomeDir = (char *)getenv("MSQL_HOME");
        if (!msqlHomeDir)
        {
                msqlHomeDir = INST_DIR;
        }
        umask(0);
                  numCons=0;
        chdir(msqlHomeDir);
        printf("\n\nmSQL Server %s starting ...\n\n",SERVER_VERSION);

#ifdef OS2
        msqlHomeDir = ".";

                  /*
        ** switch to main directory of msql
        */
        if( 0 != _stat("msqldb", &aFileInfo) )
        {                                                  /*----------------*/
                APIRET   iRC                = 0;           /* return code    */
                                         char    *psz;                              /* string pointer */
                char     szPath[CCHMAXPATH] = "";          /* program path   */
                PPIB     ppib;                             /* process info 1 */
                PTIB     ptib;                             /* process info 2 */
                                                           /*----------------*/
                /*---| get process info |---*/
                DosGetInfoBlocks( &ptib, &ppib );
                                         iRC = DosQueryModuleName( ppib->pib_hmte,
                                          sizeof(szPath),
                                          (char *) &szPath );
                if( 0 != iRC )
                {
                        fprintf( stderr,
                                                                                        "can't locate server executable (RC=%d) !\n",
                                 iRC
                               );
                        return -1;
                } /* if */

                /*---| cut filename from path |---*/
                                         if( NULL != (psz=strrchr(szPath, '/')) )
                        *psz = '\0';
                if( NULL != (psz=strrchr(szPath, '\\')) )
                        *psz = '\0';

                /*---| change directory |---*/
                                         printf( "server located in '%s'\n", szPath );
                chdir( szPath );
                if( 0 != _stat("msqldb", &aFileInfo) )
                        chdir( ".." );
                if( 0 != _stat("msqldb", &aFileInfo) )
                {
                        fprintf( stderr, "can't locate database directory!\n" );
                                                                return -1;
                } /* if */
        } /* if */
#endif

        initDebug();
                  initNet();
                  initServer();
                  initBackend();
                  (void)sprintf(path,"%s/msqld.pid",PID_DIR);
        pidFile = fopen(path,"w");
        if (!pidFile)
        {
                                         perror("Couldn't open PID file");
        }
        else
        {
#ifdef OS2
                        /*
                                                                 * OS2
                                                                 */
                fprintf(pidFile,"%d",_getpid());
#else
                        /*
                         * WINNT & UNIX
                         */
                                         fprintf(pidFile,"%d",getpid());
#endif
                fclose(pidFile);
        }
        chmod(path,0644);
        umask(0);
                  setupSignals();
                  msqlLoadAcl(1);
                  (void)bzero(&clientFDs,sizeof(fd_set));
        (void)bzero(conArray,sizeof(conArray));
        msqlDebug(MOD_GENERAL,"miniSQL debug mode.  Waiting for connections.\n");
        while(1)
        {
                                        /*
                * wait for a connection being established
                */

                (void)bcopy(&clientFDs,&readFDs,sizeof(fd_set));
                FD_SET(IPsock,&readFDs);
#ifdef HAVE_SYS_UN_H
                FD_SET(UNIXsock,&readFDs);
#endif
#ifdef OS2
                        /*
                         * OS2
                         */
                                         if(bsdselect(MAX_SOCK_NUM+1,&readFDs,0,0,0) < 0)
                        continue;
#else
                        /*
                         * WINNT & UNIX
                         */
                                         if(select(MAX_SOCK_NUM+1,&readFDs,0,0,0) < 0)
                        continue;
#endif

                /*
                ** Is this a new connection request
                */

                sock = 0;
                if (FD_ISSET(IPsock,&readFDs))
                {
                        sock = IPsock;
                }
#ifdef HAVE_SYS_UN_H
                if (FD_ISSET(UNIXsock,&readFDs))
                {
                        sock = UNIXsock;
                }
#endif
                if (sock)
                                         {
                        struct  sockaddr_in     cAddr;
                        struct  sockaddr        dummy;
                        int     cAddrLen,
                                dummyLen;

                                                                cAddrLen = sizeof(struct sockaddr_in);
                        newSock = accept(sock, (struct sockaddr *)&cAddr,
                                &cAddrLen);
                        if(newSock < 0)
                        {
                                perror("Error in accept ");
                                continue;
                                                                }
                        dummyLen = sizeof(struct sockaddr);
                        if (getsockname(newSock,&dummy, &dummyLen) < 0)
                        {
                                perror("Error on new connection socket");
                                continue;
                                                                }
                        if (conArray[newSock].db)
                        {
                                safeFree(conArray[newSock].db);
                                safeFree(conArray[newSock].host);
                                safeFree(conArray[newSock].user);
                                conArray[newSock].db = NULL;
                                                                }

                        /*
                        ** Are we over the connection limit
                                                                */
                                                                numCons++;
                                                                if (numCons > MAX_CON)
                                                                {
                                                                                  numCons--;
                                                                                  sendError(newSock,CON_COUNT_ERROR);
                                shutdown(newSock,2);
#ifdef OS2
                                                                                  soclose(newSock);
#elif defined WINSOCK
                                                                  closesocket(newSock);
#else
                                                                                  close(newSock);
#endif
                                continue;
                                                                }

#ifndef UNIX
                       /*
                        * check limits
                        */
                        if( newSock < lowSock )
                                                                { lowSock  = newSock;
                        }
                        if( newSock > highSock )
                        { highSock = newSock;
                        }
#endif

                        /*
                        ** store the connection details
                        */

                        msqlDebug(MOD_GENERAL,"New connection received on %d\n",
                                newSock);
                                                                error = 0;
                        if (sock == IPsock)
                        {
                                int     addrLen;
                                struct  hostent *hp;

                                                                                  addrLen = sizeof(struct sockaddr);
                                getpeername(newSock, (struct sockaddr *)
                                        &conArray[newSock].remote, &addrLen);
                                addrLen = sizeof(struct sockaddr);
                                getsockname(newSock, (struct sockaddr *)
                                        &conArray[newSock].local, &addrLen);
                                hp = (struct hostent *)gethostbyaddr(
                                                                                                (char *)&conArray[newSock].remote.sin_addr,
                                    sizeof(conArray[newSock].remote.sin_addr),
                                    AF_INET);
                                if (!hp)
                                {
                                                                                                         sendError(newSock, BAD_HOST_ERROR);
                                                                                                         error = 1;
                                        shutdown(newSock,2);
#ifdef OS2
                                                                                                         soclose(newSock);
#elif defined WINSOCK
                                                                                 closesocket(newSock);
#else
                                                                                                         close(newSock);
#endif
                                        numCons --;
                                }
                                else
                                {
                                                                                                         conArray[newSock].host = (char *)
                                                strdup(hp->h_name);
                                        msqlDebug(MOD_GENERAL,"Host = %s\n",
                                                hp->h_name);
                                }
                        }
                        else
                                                                {
                                conArray[newSock].host = NULL;
                                bzero(&conArray[newSock].local,
                                                                                                         sizeof(struct sockaddr));
                                bzero(&conArray[newSock].
                                                                                                         remote,sizeof(struct sockaddr));
                                                                                  msqlDebug(MOD_GENERAL,"Host = UNIX domain\n");
                        }

                                                                setConnectionState(newSock,&clientFDs);

                        if (!error)
                        {
                                                                                  opt=1;
                                setsockopt(newSock,SOL_SOCKET,SO_KEEPALIVE,
                                        (char *) &opt, sizeof(opt));
                                sprintf(packet,
                                        "0:%d:%s\n",
                                        PROTOCOL_VERSION,SERVER_VERSION);
                                                                                  writePkt(newSock);
                                                                                  if (readPkt(newSock) <=0)
                                {
                                                                                                         sendError(newSock,HANDSHAKE_ERROR);
                                        shutdown(newSock,2);
#ifdef OS2
                                                                                                         soclose(newSock);
#elif defined WINSOCK
                                                                                                         closesocket(newSock);
#else
                                                                                                         close(newSock);
#endif
                                        conArray[newSock].host = NULL;
                                                                                                         bzero(&conArray[newSock].local,
                                                                                                                                sizeof(struct sockaddr));
                                        bzero(&conArray[newSock].
                                                                                                                                remote,sizeof(struct sockaddr));
                                        numCons--;
                                }
                                else
                                                                                  {
                                        FD_SET(newSock,&clientFDs);
                                        uname = (char *)strtok(packet,"\n");
                                        msqlDebug(MOD_GENERAL,"User = %s\n",uname);
                                        safeFree(conArray[newSock].user);
                                        conArray[newSock].user = (char *)
                                                                                                                                strdup(uname);
                                        sprintf(packet,"-100:\n");
                                                                                                         writePkt(newSock);
                                }
                        }
                        continue;
                }



                /*
                ** This must be a command.
                */

#ifndef UNIX
                                         comSock = lowSock;
                                         while(numCons && comSock <= highSock)
#else
                                         comSock = 3;
                                         while(numCons && comSock < MAX_SOCK_NUM)
#endif

                                         {
                                                  if (FD_ISSET(comSock,&readFDs))
                                                  {
                                                                setConnectionState(comSock,&clientFDs);
                                                                if (readPkt(comSock) <= 0)
                        {
                                msqlDebug(MOD_GENERAL,
                                        "Command read on sock %d failed!\n",
                                        comSock);
                                command = QUIT;
                        }
                        else
                        {
                                command = atoi(packet);
                        }
                        msqlDebug(MOD_GENERAL,"Command on sock %d = %d (%s)\n",
                                comSock, command, comTable[command]);
                                                                switch(command)
                        {
                            case INIT_DB:
                                cp=(char *)strtok(packet+2,"\n\r");
                                if (!cp)
                                {
                                                                                                         sendError(comSock,NO_DB_ERROR);
                                        break;
                                }
                                strcpy(dbname,cp);
                                msqlDebug(MOD_GENERAL,"DBName = %s\n", dbname);
                                conArray[comSock].access = msqlCheckAccess(
                                                                                                         dbname, conArray + comSock);
                                                                                  if(conArray[comSock].access == NO_ACCESS)
                                {
                                        sendError(comSock,
                                                                                                                                ACCESS_DENIED_ERROR);
                                        break;
                                }
                                                                                  if (msqlInit(dbname) < 0)
                                {
                                                                                                         sendError(comSock,NULL);
                                }
                                else
                                {
                                                                                                         sendOK(comSock);
                                                                                                         conArray[comSock].db =
                                                (char *)strdup(dbname);
                                                                                                         msqlSetDB(dbname);
                                }
                                break;

                            case DB_QUERY:
                                if (!conArray[comSock].db)
                                {
                                                                                                         sendError(comSock,NO_DB_ERROR);
                                        break;
                                }
                                curSock = comSock;
                                                                                  cp=(char *)(packet+2);
                                arg = (char *)strdup(cp);
                                                                                  if (debugSet(MOD_QUERY))
                                        fprintf(stderr,"\n");
                                msqlDebug(MOD_QUERY,"Query = %s",arg);
                                                                                  msqlSetDB(conArray[comSock].db);
                                                                                  msqlSetPerms(conArray[comSock].access);
                                                                                  msqlParseQuery(arg,comSock);
                                safeFree(arg);
                                break;

                            case DB_LIST:
                                curSock = comSock;
                                                                                  msqlListDBs(comSock);
                                break;

                            case TABLE_LIST:
                                if (!conArray[comSock].db)
                                {
                                                                                                         sendError(comSock, NO_DB_ERROR);
                                        break;
                                }
                                curSock = comSock;
                                                                                  msqlListTables(comSock,conArray[comSock].db);
                                break;

                                                                         case FIELD_LIST:
                                if (!conArray[comSock].db)
                                {
                                                                                                         sendError(comSock,NO_DB_ERROR);
                                        break;
                                }
                                cp=(char *)strtok(packet+2,
                                        "\n\r");
                                if (!cp)
                                {
                                                                                                         sendError(comSock,NO_TABLE_ERROR);
                                        break;
                                }
                                                                                  arg = (char *)strdup(cp);
                                curSock = comSock;
                                msqlListFields(comSock,
                                                                                                         arg,conArray[comSock].db);
                                safeFree(arg);
                                break;

                            case QUIT:
                                msqlDebug(MOD_GENERAL,"DB QUIT!\n");
                                FD_CLR(comSock,&clientFDs);
                                shutdown(comSock,2);
#ifdef OS2
                                                                                  soclose(comSock);
#elif defined WINSOCK
                                                                                  closesocket(comSock);
#else
                                                                                  close(comSock);
#endif
                                                                                  if (conArray[comSock].db)
                                                                                  {
                                                                                          safeFree(conArray[comSock].db);
                                                                                          safeFree(conArray[comSock].host);
                                                                                          safeFree(conArray[comSock].user);
                                                                                  }
                                                                                  conArray[comSock].db = NULL;
                                                                                  numCons--;
#ifdef OS2
                                                                                  if( !numCons )
                                                                                  { lowSock  = MAX_SOCK_NUM;
                                                                                         highSock = 0;
                                                                                         continue;
                                                                                  }
#endif
                                                                                  break;

                                                                         case CREATE_DB:
                                                                                  if (!msqlCheckLocal(conArray + comSock))
                                {
                                                                                                         sendError(comSock,PERM_DENIED_ERROR);
                                                                                                         break;
                                }
                                cp=(char *)strtok(packet+2,
                                        "\n\r");
                                if (!cp)
                                {
                                                                                                         sendError(comSock,NO_DB_ERROR);
                                        break;
                                }
                                arg = (char *)strdup(cp);
                                                                                  msqlCreateDB(comSock,arg);
                                safeFree(arg);
                                break;

                            case DROP_DB:
                                                                                  if (!msqlCheckLocal(conArray + comSock))
                                {
                                                                                                         sendError(comSock,PERM_DENIED_ERROR);
                                        break;
                                }
                                cp=(char *)strtok(packet+2,
                                        "\n\r");
                                if (!cp)
                                {
                                                                                                         sendError(comSock,NO_DB_ERROR);
                                        break;
                                                                                  }
                                                                                  arg = (char *)strdup(cp);
                                                                                  msqlDropDB(comSock,arg);
                                                                                  safeFree(arg);
                                                                                  break;

                                                                         case RELOAD_ACL:
                                                                                  if (!msqlCheckLocal(conArray + comSock))
                                                                                  {
                                                                                                         sendError(comSock,PERM_DENIED_ERROR);
                                                                                                         break;
                                                                                  }
                                                                                  (void)sprintf(packet,"-100:\n");
                                                                                  reloadAcls(comSock);
                                                                                  writePkt(comSock);
                                                                                  break;

                                                                         case SHUTDOWN:
                                                                                  if (!msqlCheckLocal(conArray + comSock))
                                                                                  {
                                                                                                         sendError(comSock,PERM_DENIED_ERROR);
                                                                                                         break;
                                                                                  }
                                                                                  sprintf(packet,"-100:\n");
                                                                                  writePkt(comSock);
                                                                                  puntServer(-1);
#ifdef WINSOCK
                                                                                  WSACleanup();
#endif
                                                                                  exit(0);
                                                                                  break;

                            default:
                                                                                  sendError(comSock, UNKNOWN_COM_ERROR);
                                break;
                        }
                        msqlDebug(MOD_GENERAL,"Command Processed!\n");
                    }
                    comSock++;
                }
        }
}
@


1.2
log
@Changed socket number hadling to conform closer to OS2.
Chaged a lot of #ifdef OS2  to #ifndef UNIX
@
text
@d443 3
d448 3
@


1.1
log
@Initial revision
@
text
@d44 1
d115 2
d137 1
a137 1
#ifdef OS2
d140 1
a140 1
        clientSock = 3;
d142 2
a143 2
        printf("\n\nForced server shutdown due to bad signal!\n\n");
        while(clientSock < MAX_SOCK_NUM)
d150 1
a150 1
                        soclose(clientSock);
d152 1
a152 1
								closesocket(clientSock);
d154 1
a154 1
								close(clientSock);
d156 1
a156 1
                }
d161 1
a161 1
		  soclose(IPsock);
d163 1
a163 1
		  closesocket(IPsock);
d165 1
a165 1
		  close(IPsock);
d169 1
a169 1
        close(UNIXsock);
d178 1
a178 1
        char    *err;
d187 1
a187 1
		  writePkt(fd);
d193 1
a193 1
					 printf("Send OK called\n");
d195 2
a196 2
        sprintf(packet,"1:\n");
		  writePkt(fd);
d215 1
a215 1
		  struct  sockaddr_in     IPaddr;
d217 1
a217 1
        char    *envVar;
d223 1
a223 1
        /*
d227 2
a228 2
		  if ((serv_ptr = getservbyname("msql", "tcp")))
		  {
d230 3
a232 3
        }
		  if ((envVar = getenv("MSQL_TCP_PORT")))
		  {
d234 1
a234 1
        }
d236 1
a236 1
        IPsock = socket(AF_INET, SOCK_STREAM, 0);
d241 1
a241 1
		  }
d245 1
a245 1
		  setsockopt(IPsock, SOL_SOCKET, SO_REUSEADDR, (char*)&opt, sizeof(int));
d247 2
a248 2
        opt = 1;
		  setsockopt(IPsock, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(int));
d252 1
a252 1
		  (void)bzero(&IPaddr, sizeof(IPaddr));
d254 3
a256 3
		  IPaddr.sin_addr.s_addr = htonl(INADDR_ANY);
		  IPaddr.sin_port = htons(tcpPort);
        if (bind(IPsock, (struct sockaddr *)&IPaddr, sizeof(IPaddr)) < 0)
d258 1
a258 1
					 perror("Can't start server : IP Bind ");
d260 1
a260 1
					 WSACleanup();
d262 1
a262 1
					 exit(1);
d267 1
a267 1
		  /*
d269 1
a269 1
        */
d271 1
a271 1
		  if ((envVar = getenv("MSQL_UNIX_PORT")))
d273 1
a273 1
                unixPort = envVar;
d280 3
a282 3
					 perror("Can't start server : UNIX Socket ");
					 exit(1);
        }
d284 1
a284 1
		  UNIXaddr.sun_family = AF_UNIX;
d286 1
a286 1
        unlink(unixPort);
d288 1
a288 1
        {
d290 3
a292 3
					 exit(1);
        }
        listen(UNIXsock,5);
d299 1
a299 1
        int     sig;
d301 1
a301 1
        int     clientSock;
d303 3
a305 3
        signal(sig,SIG_IGN);
#ifdef OS2
        clientSock = 1;
d307 1
a307 1
		  clientSock = 3;
d309 14
a322 14
        if (sig == -1)
		  {
                printf("\n\nNormal Server shutdown!\n\n");
        }
        else
        {
                printf("\n\nServer Aborting!\n\n");
        }
        while(clientSock < MAX_SOCK_NUM)
        {
                if (conArray[clientSock].db)
					 {
                        printf("Forcing close on Socket %d\n",clientSock);
                        shutdown(clientSock,2);
d324 1
a324 1
								soclose(clientSock);
d326 1
a326 1
								closesocket(clientSock);
d328 1
a328 1
								close(clientSock);
d330 4
a333 4
					 }
					 clientSock++;
		  }
        shutdown(IPsock,2);
d335 1
a335 1
		  soclose(IPsock);
d337 1
a337 1
    	  closesocket(IPsock);
d339 1
a339 1
		  close(IPsock);
d343 18
a360 18
        shutdown(UNIXsock,2);
		  close(UNIXsock);
        unlink(unixPort);
#endif
		  printf("\n");
		  dropCache();

		  if (debugSet(MOD_MALLOC))
        {
                fprintf(stderr,"\n\nmalloc() leak detection .....\n");
					 checkBlocks(MALLOC_BLK);
        }
		  if (debugSet(MOD_MMAP))
        {
                fprintf(stderr,"\n\nmmap() leak detection .....\n");
					 checkBlocks(MMAP_BLK);
        }
		  printf("\n\nmSQL Daemon Shutdown Complete.\n\n");
d362 7
a368 7
					 /*
                 * OS2 & WINNT
					  */
		  if (remove(PID_DIR"\\msqld.pid"))
        {
                fprintf(stderr,"\n\nCouldn't remove PID file\n");
        }
d370 2
a371 2
        if (sig >= 0)
        {
d373 1
a373 1
					 WSACleanup();
d375 2
a376 2
					 exit(1);
		  }
d382 1
a382 1
		  char    *s;
d384 3
a386 3
        sprintf(packet,"-1:%s near \"%s\"\n", s, yytext?yytext:"");
		  writePkt(curSock);
		  msqlClean();
d397 1
a397 1
        int     sock;
d401 1
a401 1
		  clientFdSet = fds;
d409 2
a410 2
        if (clientFdSet)
        {
d412 1
a412 1
                shutdown(curComSock,2);
d414 1
a414 1
					 soclose(curComSock);
d416 1
a416 1
					 closesocket(curComSock);
d418 1
a418 1
					 close(curComSock);
d422 2
a423 2
                        safeFree(conArray[curComSock].db);
                        safeFree(conArray[curComSock].host);
d425 1
a425 1
                }
d427 1
a427 1
					 printf("Forced close of client on socket %d due to pipe sig\n",
d438 1
a438 1
        signal(SIGSEGV,sigTrap);
d441 1
a441 1
        signal(SIGBUS,sigTrap);
d444 1
a444 1
        signal(SIGINT,puntServer);
d447 1
a447 1
        signal(SIGQUIT,puntServer);
d450 1
a450 1
        signal(SIGKILL,puntServer);
d453 1
a453 1
		  signal(SIGPIPE,puntClient);
d456 1
a456 1
        signal(SIGTERM,puntServer);
d459 1
a459 1
        signal(SIGHUP,SIG_IGN);
d469 2
a470 2
        int     argc;
        char    *argv[];
d472 8
a479 8
        fd_set  readFDs,
                clientFDs;
        int     sock         = 0,
                newSock      = 0,
                comSock      = 0,
#ifdef OS2
                lowSock      = MAX_SOCK_NUM,
					 highSock     = 0,
d481 1
a481 1
                command      = 0,
d484 4
a487 4
                error        = 0;
        char    dbname[30]   = "\0",
					 *uname       = NULL,
					 *cp          = NULL,
d491 1
a491 1
		  FILE    *pidFile     = NULL;
d496 9
a504 9
		  WORD wVersionRequired = MAKEWORD(1,1);  /* winsock 1.1 required */
		  WSADATA	wsaData;
		  int nErrorStatus;

		  if (WSAStartup(wVersionRequired, &wsaData) != 0)
		  {
			 printf("msqlConnect : Unable to initialise WINSOCK");
			 exit(1);
		  }
d511 1
a511 1
        msqlHomeDir = (char *)getenv("MSQL_HOME");
d517 1
a517 1
		  numCons=0;
d524 1
a524 1
        /*
d530 1
a530 1
					 char    *psz;                              /* string pointer */
d537 1
a537 1
                iRC = DosQueryModuleName( ppib->pib_hmte,
d543 1
a543 1
											"can't locate server executable (RC=%d) !\n",
d550 1
a550 1
                if( NULL != (psz=strrchr(szPath, '/')) )
d556 1
a556 1
					 printf( "server located in '%s'\n", szPath );
d563 1
a563 1
                        return -1;
d569 4
a572 4
		  initNet();
		  initServer();
		  initBackend();
		  (void)sprintf(path,"%s/msqld.pid",PID_DIR);
d576 1
a576 1
                perror("Couldn't open PID file");
d582 2
a583 2
								 * OS2
                         */
d589 1
a589 1
                fprintf(pidFile,"%d",getpid());
d595 3
a597 3
		  setupSignals();
		  msqlLoadAcl(1);
		  (void)bzero(&clientFDs,sizeof(fd_set));
d602 1
a602 1
               /*
d615 1
a615 1
                if(bsdselect(MAX_SOCK_NUM+1,&readFDs,0,0,0) < 0)
d621 1
a621 1
					 if(select(MAX_SOCK_NUM+1,&readFDs,0,0,0) < 0)
d641 1
a641 1
                {
d647 1
a647 1
								cAddrLen = sizeof(struct sockaddr_in);
d654 1
a654 1
                        }
d660 1
a660 1
								}
d667 1
a667 1
                        }
d671 6
a676 6
								*/
								numCons++;
								if (numCons > MAX_CON)
								{
										  numCons--;
										  sendError(newSock,CON_COUNT_ERROR);
d679 1
a679 1
										  soclose(newSock);
d681 1
a681 1
         							  closesocket(newSock);
d683 1
a683 1
										  close(newSock);
d686 1
a686 1
								}
d688 1
a688 1
#ifdef OS2
d693 1
a693 1
                        { lowSock  = newSock;
d706 1
a706 1
                        error = 0;
d712 1
a712 1
										  addrLen = sizeof(struct sockaddr);
d719 1
a719 1
                                    (char *)&conArray[newSock].remote.sin_addr,
d724 2
a725 2
													 sendError(newSock, BAD_HOST_ERROR);
													 error = 1;
d728 1
a728 1
													 soclose(newSock);
d730 1
a730 1
                 								 closesocket(newSock);
d732 1
a732 1
													 close(newSock);
d738 1
a738 1
													 conArray[newSock].host = (char *)
d745 1
a745 1
                        {
d748 1
a748 1
													 sizeof(struct sockaddr));
d750 2
a751 2
													 remote,sizeof(struct sockaddr));
										  msqlDebug(MOD_GENERAL,"Host = UNIX domain\n");
d754 1
a754 1
								setConnectionState(newSock,&clientFDs);
d758 1
a758 1
                                opt=1;
d764 2
a765 2
										  writePkt(newSock);
										  if (readPkt(newSock) <=0)
d767 1
a767 1
													 sendError(newSock,HANDSHAKE_ERROR);
d770 1
a770 1
													 soclose(newSock);
d772 1
a772 1
													 closesocket(newSock);
d774 1
a774 1
													 close(newSock);
d777 2
a778 2
													 bzero(&conArray[newSock].local,
																sizeof(struct sockaddr));
d780 1
a780 1
																remote,sizeof(struct sockaddr));
d784 1
a784 1
                                {
d790 1
a790 1
																strdup(uname);
d792 1
a792 1
													 writePkt(newSock);
d804 3
a806 3
#ifdef OS2
                comSock = lowSock;
                while(numCons && comSock <= highSock)
d808 2
a809 2
                comSock = 3;
                while(numCons && comSock < MAX_SOCK_NUM)
d812 5
a816 5
                {
                    if (FD_ISSET(comSock,&readFDs))
                    {
								setConnectionState(comSock,&clientFDs);
								if (readPkt(comSock) <= 0)
d829 1
a829 1
								switch(command)
d835 1
a835 1
													 sendError(comSock,NO_DB_ERROR);
d841 2
a842 2
													 dbname, conArray + comSock);
										  if(conArray[comSock].access == NO_ACCESS)
d845 1
a845 1
																ACCESS_DENIED_ERROR);
d848 1
a848 1
										  if (msqlInit(dbname) < 0)
d850 1
a850 1
													 sendError(comSock,NULL);
d854 2
a855 2
													 sendOK(comSock);
													 conArray[comSock].db =
d857 1
a857 1
													 msqlSetDB(dbname);
d864 1
a864 1
													 sendError(comSock,NO_DB_ERROR);
d868 1
a868 1
										  cp=(char *)(packet+2);
d870 1
a870 1
										  if (debugSet(MOD_QUERY))
d873 3
a875 3
										  msqlSetDB(conArray[comSock].db);
										  msqlSetPerms(conArray[comSock].access);
										  msqlParseQuery(arg,comSock);
d881 1
a881 1
										  msqlListDBs(comSock);
d887 1
a887 1
													 sendError(comSock, NO_DB_ERROR);
d891 1
a891 1
										  msqlListTables(comSock,conArray[comSock].db);
d894 1
a894 1
									 case FIELD_LIST:
d897 1
a897 1
													 sendError(comSock,NO_DB_ERROR);
d904 1
a904 1
													 sendError(comSock,NO_TABLE_ERROR);
d907 1
a907 1
										  arg = (char *)strdup(cp);
d910 1
a910 1
													 arg,conArray[comSock].db);
d919 1
a919 1
										  soclose(comSock);
d921 1
a921 1
										  closesocket(comSock);
d923 1
a923 1
										  close(comSock);
d925 14
a938 14
										  if (conArray[comSock].db)
										  {
											  safeFree(conArray[comSock].db);
											  safeFree(conArray[comSock].host);
											  safeFree(conArray[comSock].user);
										  }
										  conArray[comSock].db = NULL;
										  numCons--;
#ifdef OS2
										  if( !numCons )
										  { lowSock  = MAX_SOCK_NUM;
											 highSock = 0;
											 continue;
										  }
d940 1
a940 1
										  break;
d942 2
a943 2
									 case CREATE_DB:
										  if (!msqlCheckLocal(conArray + comSock))
d945 2
a946 2
													 sendError(comSock,PERM_DENIED_ERROR);
													 break;
d952 1
a952 1
													 sendError(comSock,NO_DB_ERROR);
d956 1
a956 1
										  msqlCreateDB(comSock,arg);
d961 1
a961 1
										  if (!msqlCheckLocal(conArray + comSock))
d963 1
a963 1
													 sendError(comSock,PERM_DENIED_ERROR);
d970 1
a970 1
													 sendError(comSock,NO_DB_ERROR);
d972 26
a997 26
										  }
										  arg = (char *)strdup(cp);
										  msqlDropDB(comSock,arg);
										  safeFree(arg);
										  break;

									 case RELOAD_ACL:
										  if (!msqlCheckLocal(conArray + comSock))
										  {
													 sendError(comSock,PERM_DENIED_ERROR);
													 break;
										  }
										  (void)sprintf(packet,"-100:\n");
										  reloadAcls(comSock);
										  writePkt(comSock);
										  break;

									 case SHUTDOWN:
										  if (!msqlCheckLocal(conArray + comSock))
										  {
													 sendError(comSock,PERM_DENIED_ERROR);
													 break;
										  }
										  sprintf(packet,"-100:\n");
										  writePkt(comSock);
										  puntServer(-1);
d999 1
a999 1
										  WSACleanup();
d1001 2
a1002 2
										  exit(0);
										  break;
d1005 1
a1005 1
										  sendError(comSock, UNKNOWN_COM_ERROR);
@
