
/*********************************************************
*
*	create_cb.c		Mark Loveland
*
*	version .5		5/20/96
*
*********************************************************/
#include "add.h"

/* callbacks for form NewDB */
void CREATE_Input_cb(FL_OBJECT *ob, long data)
{
}

void CREATE_Submit_cb(FL_OBJECT *ob, long data)
{
 	char buffer[2048];
	char *input;
	m_result *result_data;
	int socket;
	
	(const)input = fl_get_input(fd_create->CREATE_Input);

	if ((socket = msqlConnect(host)) < 0)
	{
		fl_add_browser_line(fd_xfsql->Output3,"ERROR: Unable to connect to host");
 		msqlClose(socket);
	}
	else
	{
		result_data = msqlListDBs(socket);

		if (!result_data)
		{
			fl_add_browser_line(fd_xfsql->Output3,"ERROR: No Databases available");
			msqlFreeResult(result_data);
			msqlClose(socket);
		}		
		else if (msqlSelectDB(socket,database) < 0)
		{
			fl_clear_browser(fd_xfsql->Output3);
			fl_add_browser_line(fd_xfsql->Output3,"Use cursor and click to select a DB");
			msqlFreeResult(result_data);
			msqlClose(socket);
		}
		else if (msqlQuery(socket,input) < 0)
		{
			fl_clear_browser(fd_xfsql->Output3);
			fl_add_browser_line(fd_xfsql->Output3,msqlErrMsg);
			msqlFreeResult(result_data);
			msqlClose(socket);
		}
		else
		{
			fl_clear_browser(fd_xfsql->Output3);
			if (strcmp(strtok(input, " /t"), "CREATE") == 0)
				strcpy(buffer, "Table created. ");
			else if (strcmp(strtok(input, " /t"), "DROP") == 0)
				strcpy(buffer, "Table dropped. ");
			else strcpy(buffer, "Unknown Operation");
			fl_add_browser_line(fd_xfsql->Output3,buffer);
			msqlFreeResult(result_data);
			msqlClose(socket);
 		}	 
	}
}

void CREATE_Exit_cb(FL_OBJECT *ob, long data)
{
 	fl_hide_form(fd_create->NewDB);
	ops = false;
}

void CREATE_Save_cb(FL_OBJECT *ob, long data)
{
	const char *fname; 
	char* input;
	char buffer[2048];
	int len;

	fname = fl_show_file_selector("File To Save","","*.c_d","");
  	if (fname == NULL) return;
  	if (strcmp(fname,"") != 0)
	{
		(const)input = fl_get_input(fd_gui_sql->GUI_SQL_Input);
		strcpy(buffer, input);
		input = buffer;
		strcat(buffer,"\n");
		len = strlen(buffer);
		Open(fname);
		Insert(input, len, false, fname);
	}
	else
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_add_browser_line(fd_xfsql->Output3,"No filename given");
	}  
}

void CREATE_Load_cb(FL_OBJECT *ob, long data)
{
	char *line,*buf;
	char storage[2048];
	int total_lines, i;
	const char *fname;
  	FL_OBJECT *obj;
	FL_FORM *form;

	buf = storage;

/* The invisible form (a storage area) */

	fl_disable_fselector_cache(1);
  	form = fl_bgn_form(FL_NO_BOX,0,0);
 	obj = fl_add_browser(FL_NORMAL_BROWSER,0,0,0,0,"");
  	fl_end_form();
	
	fname = fl_show_file_selector("File To Load","","*.c_d","");

  	if (strcmp(fname,"") != 0)
	{
 		if (!fl_load_browser(obj,fname)) 
     			fl_set_input(fd_create->CREATE_Input,"Problem loading file!");
		total_lines = fl_get_browser_maxline(obj);
		(const)line = fl_get_browser_line(obj,1);
		strcpy(buf,line);
		strcat(buf,"\n");
		for (i=2; i<total_lines; i++)
		{
			(const)line = fl_get_browser_line(obj,i);
			strcat(buf,line);
			strcat(buf,"\n");
		}
		fl_set_input(fd_create->CREATE_Input,buf);
	}
	else
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_add_browser_line(fd_xfsql->Output3,"No filename given");
	}
   
}

void CREATE_TABLE_cb(FL_OBJECT *ob, long data)
{
	mode = CREATE;
	Put_Create("CREATE TABLE ");
}

void DROP_TABLE_cb(FL_OBJECT *ob, long data)
{
	mode = DROP;
	first = true;
	Put_Create("DROP TABLE ");
}

void SHUTDOWN_cb(FL_OBJECT *ob, long data)
{
	int socket;

	if ((socket = msqlConnect(host)) < 0)
	{
		fl_add_browser_line(fd_xfsql->Output3,"ERROR: Unable to connect to host");
 		msqlClose(socket);
	}

   	if(msqlShutdown(socket) < 0)
	{
		fl_add_browser_line(fd_xfsql->Output3,"ERROR: Unable to SHUTDOWN");
		msqlClose(socket);
	}
	else
	{
		fl_add_browser_line(fd_xfsql->Output3,"SHUTDOWN Complete.\n\n");
		fl_add_browser_line(fd_xfsql->Output3,"You will have to manually restart msqld\n");
		fl_add_browser_line(fd_xfsql->Output3,"before further work with XfSQL.\n");
		msqlClose(socket);
	}
}

void RELOAD_cb(FL_OBJECT *ob, long data)
{
	int socket;

	if ((socket = msqlConnect(host)) < 0)
	{		
		fl_add_browser_line(fd_xfsql->Output3,"ERROR: Unable to connect to host");
 		msqlClose(socket);
	}
  	if(msqlReloadAcls(socket) < 0)
	{
		fl_add_browser_line(fd_xfsql->Output3,"ERROR: Unable to RELOAD");
		msqlClose(socket);
	}
	else
	{
		fl_add_browser_line(fd_xfsql->Output3,"RELOAD Complete");
		msqlClose(socket);
	}

}

void DROP_cb(FL_OBJECT *ob, long data)
{
	mode = DROP;
	if (fd_input == NULL)
   		fd_input = create_form_INPUT();
	fl_show_form(fd_input->INPUT,FL_PLACE_CENTER,FL_FULLBORDER,"DataBase NAME to DROP");
}

void CREATE_db_cb(FL_OBJECT *ob, long data)
{
	mode = CREATE;
	if (fd_input == NULL)
   		fd_input = create_form_INPUT();
	fl_show_form(fd_input->INPUT,FL_PLACE_CENTER,FL_FULLBORDER,"DataBase NAME to CREATE");
}

void CREATE_Clear_cb(FL_OBJECT *ob, long data)
{
	fl_set_input(fd_create->CREATE_Input,"");
}

void char_in_cb(FL_OBJECT *ob, long data)
{
	Put_Create(" char\(");  
}

void int_in_cb(FL_OBJECT *ob, long data)
{
	Put_Create(" int ");
}

void real_in_cb(FL_OBJECT *ob, long data)
{
	Put_Create(" real ");  
}

void notnull_cb(FL_OBJECT *ob, long data)
{
	Put_Create(" not null "); 
}

void primary_in_cb(FL_OBJECT *ob, long data)
{
	Put_Create(" primary key ");   
}

void current_CREATE_cb(FL_OBJECT *ob, long data)
{
	char buf[1024];
 	switch(mode)
	{
		case CREATE:
			break;
		case DROP:
			if (first)
			{
				strcpy(buf, " ");
				strcat(buf, table);
				first = false;
				Put_Create(buf);
			}
			break;
	}
}

void Put_Create(char* string)
{
	char buf[1024];
	char *input;	 

	(const)input = fl_get_input(fd_create->CREATE_Input);
	strcpy(buf, input);
	input = buf;
	strcat(buf,string);
  	fl_set_input(fd_create->CREATE_Input,input);
}



