/*********************************************************
*
*	gui_sql_cb.c		Mark Loveland
*
*	version 1.0		5/9/96
*
*********************************************************/
#include "add.h"

/* callbacks for form GUI_SQL */
void GUI_SQL_Input_cb(FL_OBJECT *ob, long data)
{
}

void GUI_Submit_cb(FL_OBJECT *ob, long data)
{
	char buffer[MAX_LENGTH];
	char *input, *buf, *space = " ";
 	m_row current_row;
	m_result *result_data;
	m_field	*current_field;
	int socket, field_offset, 
	maxlength, length, i;
	
	(const)input = fl_get_input(fd_gui_sql->GUI_SQL_Input);

	length = strlen(input);
	buf = malloc(length);
	memcpy(buf,input,length);
	for (i = 0; i < length; i++)
	{	
		if (buf[i] == '\n')
			buf[i] = ' ';
	}

	length = 0;
	if ((socket = msqlConnect(host)) < false)
	{
		fl_set_input(fd_gui_sql->GUI_SQL_Input,"ERROR: Unable to connect to host");
 		msqlClose(socket);
	}
	else
	{
		result_data = msqlListDBs(socket);

		if (!result_data)
		{
			fl_set_input(fd_gui_sql->GUI_SQL_Input,"ERROR: No Databases available");
			msqlFreeResult(result_data);
			msqlClose(socket);
		}		
		else if (msqlSelectDB(socket,database) < false)
		{
			fl_clear_browser(fd_xfsql->Output3);
			fl_add_browser_line(fd_xfsql->Output3,"Use cursor and click to select a DB");
			msqlFreeResult(result_data);
			msqlClose(socket);
		}
		else if (msqlQuery(socket,input) < false)
		{
			fl_clear_browser(fd_xfsql->Output3);
			fl_add_browser_line(fd_xfsql->Output3,msqlErrMsg);
			msqlFreeResult(result_data);
			msqlClose(socket);
			return;
		}
		else
		{
			fl_clear_browser(fd_xfsql->Output3);
			result_data = msqlStoreResult();
			maxlength = 1;
			if (result_data)
			{	
				strcpy(buffer,"@C1@b");
				fl_add_browser_line(fd_xfsql->Output3,"--------------------------------------------");	
				while((current_field = msqlFetchField(result_data)))
				{
					 switch(current_field->type)
					{
		    				case REAL_TYPE:
							length = strlen(current_field->name);
							if (length < 12)
								length = 12;
							break;

		    				case INT_TYPE:
							length = strlen(current_field->name);
							if (length < 8)
								length = 8;
							break;

		    				case CHAR_TYPE:
								length = max(strlen(current_field->name),
								current_field->length);
							break;
					}
					strcat(buffer, current_field->name);
					fill(buffer, strlen(current_field->name),length,space);
					strcat(buffer," ");
				}
				fl_add_browser_line(fd_xfsql->Output3,buffer);
				fl_add_browser_line(fd_xfsql->Output3,"--------------------------------------------");
				
				msqlFieldSeek(result_data,0);
				while ((current_row = msqlFetchRow(result_data)))
				{
					field_offset = 0;
					while(field_offset < msqlNumFields(result_data))
					{
						current_field = msqlFetchField(result_data);	
						switch(current_field->type)
						{
		    					case REAL_TYPE:
								length = strlen(current_field->name);
								if (length < 12)
									length = 12;
								break;

		    					case INT_TYPE:
								length = strlen(current_field->name);
								if (length < 8)
									length = 8;
								break;

		    					case CHAR_TYPE:
									length = max(strlen(current_field->name),
									current_field->length);
								break;
						}

						if (current_row[field_offset])
						{
							if (field_offset == 0)	
							{
								strcpy(buffer, current_row[field_offset]);
								fill(buffer, strlen(current_row[field_offset]),length,space);
							}
							else
							{
								strcat(buffer, current_row[field_offset]);
								fill(buffer, strlen(current_row[field_offset]),length,space);
							}
						}
						else
						{
							strcat(buffer,"NULL");
							fill(buffer,4,length,space);
						}	
						strcat(buffer," ");
						field_offset++;
					}
					fl_add_browser_line(fd_xfsql->Output3,buffer);
					msqlFieldSeek(result_data,0);
				}
				msqlFreeResult(result_data);
			}
			else fl_add_browser_line(fd_xfsql->Output3,"Query OK");
		}
	}
}

void GUI_SQL_ExitQB_cb(FL_OBJECT *ob, long data)
{
 	fl_hide_form(fd_gui_sql->GUI_SQL);
	ops = false;
}

void SaveQuery_cb(FL_OBJECT *ob, long data)
{	
	const char *fname; 
	char* input;
	char buffer[1024];
	int len;
	
	fname = fl_show_file_selector("File To Save","","*.sql","");
  	if (fname == NULL) return;
  	if (strcmp(fname,"") != 0)
	{
		(const)input = fl_get_input(fd_gui_sql->GUI_SQL_Input);
		strcpy(buffer, input);
		input = buffer;
		strcat(buffer,"\n");
		len = strlen(buffer);
		Open(fname);
		Insert(input, len, false, fname);
	}
	else
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_add_browser_line(fd_xfsql->Output3,"No filename given");
	}
}

void LoadQuery_cb(FL_OBJECT *ob, long data)
{
	char *line,*buffer;
	char storage[2048];
	int total_lines, i;
	const char *fname;
  	FL_OBJECT *obj;
	FL_FORM *form;

	
	buffer = storage;

/* The invisible form (a storage area) */

	fl_disable_fselector_cache(true);
  	form = fl_bgn_form(FL_NO_BOX,false,false);
 	obj = fl_add_browser(FL_NORMAL_BROWSER,false,false,false,false,"");
  	fl_end_form();
	
	fname = fl_show_file_selector("File To Load","","*.sql","");
   	if (strcmp(fname,"") != 0)
	{  	
		if (!fl_load_browser(obj,fname)) 
     			fl_set_input(fd_gui_sql->GUI_SQL_Input,"Problem loading file!");

		total_lines = fl_get_browser_maxline(obj);
		(const)line = fl_get_browser_line(obj,true);
		strcpy(buffer,line);
		strcat(buffer,"\n");
		for (i=2; i<total_lines; i++)
		{
			(const)line = fl_get_browser_line(obj,i);
			strcat(buffer,line);
			strcat(buffer,"\n");
		}
		fl_set_input(fd_gui_sql->GUI_SQL_Input,buffer);
	}
	else
	{
		fl_clear_browser(fd_xfsql->Output3);
		fl_add_browser_line(fd_xfsql->Output3,"No filename given");
	}
}

void SELECT_cb(FL_OBJECT *ob, long data)
{
	Put_Query("SELECT ");
	first = true;
	mode = SELECT;
	state = START;
}

void FROM_cb(FL_OBJECT *ob, long data)
{
	switch(mode)
	{
		case SELECT:
			Put_Query(" FROM ");
			first = true;
			state = FROM;
			break;
		case DELETE:
			if(info)
				showinfo("delete.info");
			break;
		case UPDATE:
			if(info)
				showinfo("update.info");
			break;
		case INSERT:
			if(info)
				showinfo("insert.info");
			break;
	}
}

void WHERE_cb(FL_OBJECT *ob, long data)
{
	switch(mode)
	{
		case SELECT:
		case DELETE:
		case UPDATE:		
			Put_Query(" WHERE ");
			state = WHERE;
			break;
		case INSERT:
			if(info)
				showinfo("insert.info");
			break;
	}
}

void AND_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" AND ");
}

void ORDER_BY_cb(FL_OBJECT *ob, long data)
{
	switch(mode)
	{
		case SELECT:
			Put_Query(" ORDER BY ");
			state = ORDERBY;
			break;
		case DELETE:
			if(info)
				showinfo("delete.info");
			break;
		case UPDATE:		
			if(info)
				showinfo("update.info");
			break;
		case INSERT:
			if(info)
				showinfo("insert.info");
			break;
	}
}

void LESS_THAN_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" < ");
}

void GREATER_THAN_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" > ");
}

void EQUAL_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" = ");
}

void LESS_EQUAL_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" <= ");
}

void GREATER_EQUAL_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" >= ");
}

void NOT_EQUAL_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" <> ");
}

void LIKE_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" LIKE ");
}

void OR_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" OR ");
}

void VALUE_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" ''");
}

void Current_cb(FL_OBJECT *ob, long data)
{
	char buffer1[1024];
	char buffer2[1024];
	char *tokptr;
	switch(mode)
	{
		case SELECT: switch (state)
			     {		
				case FROM: 
					if (strcmp(table,"") != false)
					{ 
						if (!first)
						{
							strcpy(buffer1, ", ");
							strcat(buffer1, table);
						}
						else
						{
							strcpy(buffer1, table);
							first = false;
						}
						Put_Query(buffer1);
						break;
					}
				case WHERE: 
					if (strcmp(table,"") != false && strcmp(field,"") != false)
					{
						strcpy(buffer1, table);
						strcat(buffer1, ".");
						strcpy(buffer2,field);
						tokptr = strtok(buffer2, " \t");
						strcat(buffer1, tokptr);
						Put_Query(buffer1);
						break;
					}
				case START: 
				case ORDERBY:
					if (strcmp(table,"") != false && strcmp(field,"") != false)
					{
						if (first)
						{
							first = false;
							strcpy(buffer1, table);
						}
						else
						{
							strcpy(buffer1, ", ");
							strcat(buffer1, table);
						}
						strcat(buffer1, ".");
						strcpy(buffer2,field);
						tokptr = strtok(buffer2, " \t");
						strcat(buffer1, tokptr);
						Put_Query(buffer1);
					}
					break;
				default: 
					if(info)
						showinfo("select.info");
					break;
			     }
			     break;

		case INSERT: switch(state)
			     {
				case START:
					if (strcmp(table,"") != false)
					{	
						if (first)
						{
							strcpy(buffer1, table);
							strcat(buffer1, "(");
							first = false;
							Put_Query(buffer1);
						}
						else if (!first && !second)	
						{
							if (strcmp(field,"") != false)
							{
								strcpy(buffer2,field);
								tokptr = strtok(buffer2, " \t");
								strcpy(buffer1, tokptr);
								second = true;
								Put_Query(buffer1);
							}
						}
						else if (!first && second)	
						{
							if (strcmp(field,"") != false)
							{
								strcpy(buffer2,field);
								strcpy(buffer1, ",");
								tokptr = strtok(buffer2, " \t");
								strcat(buffer1, tokptr);
								Put_Query(buffer1);
							}
						}
					}
					break;
				case VALUES:
					strcpy(buffer1, ") VALUES('");
					Put_Query(buffer1);
					break;
				default:
					if(info)
						showinfo("insert.info");
					break;
			     }
			     break;
		case DELETE: switch(state)
			     {
				case START:
					if (strcmp(table,"") != false)
					{	
						if (first)
						{
							strcpy(buffer1, table);
							Put_Query(buffer1);
							first = false;
							second = true;
						}
					}
					break;
				case WHERE: 
					if (strcmp(field,"") != false)
					{
						if (second)
						{
							strcpy(buffer2,field);
							tokptr = strtok(buffer2, " \t");
							strcpy(buffer1, tokptr);
							Put_Query(buffer1);
							first = false;
						}
					}
					break;
				default:
					if(info)
						showinfo("delete.info");
					break;
			     }
			     break;
		case UPDATE: switch(state)
			     {
				case START:
					if (strcmp(table,"") != false)
					{	
						if (first)
						{
							strcpy(buffer1, table);
							Put_Query(buffer1);
							first =false;
						}
					}
					break;
				case WHERE: 
					if (strcmp(field,"") != false)
					{
						if (first)
						{
							strcpy(buffer2,field);
							tokptr = strtok(buffer2, " \t");
							strcpy(buffer1, tokptr);
							Put_Query(buffer1);
							first = false;
						}
					}
					break;
				case SET: 
					if (strcmp(field,"") != false)
					{
						if (first && !second)
						{
							strcpy(buffer2,field);
							tokptr = strtok(buffer2, " \t");
							strcpy(buffer1, tokptr);
							strcat(buffer1," = ");
							Put_Query(buffer1);
						}
						else if (second)
						{
							strcpy(buffer1,", ");
							strcpy(buffer2,field);
							tokptr = strtok(buffer2, " \t");
							strcat(buffer1, tokptr);
							strcat(buffer1," = ");
							Put_Query(buffer1);
						}
					}
					break;
				default:
					if(info)
						showinfo("update.info");
					break;
			     }
			     break;
	}
}

void ClearQuery_cb(FL_OBJECT *ob, long data)
{	
	fl_set_input(fd_gui_sql->GUI_SQL_Input,"");
}

void INSERT_cb(FL_OBJECT *ob, long data)
{
	Put_Query("INSERT INTO ");
	first = true;
	second = false;
	mode = INSERT;
	state = START;
}

void DELETE_cb(FL_OBJECT *ob, long data)
{
	Put_Query("DELETE FROM ");
	first = true;
	mode = DELETE;
	state = START;
}

void UPDATE_cb(FL_OBJECT *ob, long data)
{
 	Put_Query("UPDATE ");
	first = true;
	second = false;
	mode = UPDATE;
	state = START;
}

void VALUES_cb(FL_OBJECT *ob, long data)
{
	switch(mode)
	{
		case SELECT:
			if(info)
				showinfo("select.info");
			break;
		case DELETE:
			if(info)
				showinfo("delete.info");
			break;
		case UPDATE:
			if(info)
				showinfo("update.info");
			break;
		case INSERT:
			Put_Query(") VALUES(");
			first = true;
			state = VALUES;
			break;
	}

}

void SET_cb(FL_OBJECT *ob, long data)
{	
	switch(mode)
	{
		case SELECT:
			if(info)
				showinfo("select.info");
			break;
		case DELETE:
			if(info)
				showinfo("delete.info");
			break;
		case UPDATE:
	 		Put_Query(" SET ");
			first = true;
			state = SET;
			break;
		case INSERT:
			if(info)
				showinfo("insert.info");
			break;
	}
}

void Put_Query(char* string)
{
	char buffer[1024];
	char * input;	

	(const)input = fl_get_input(fd_gui_sql->GUI_SQL_Input);
	strcpy(buffer, input);
	input = buffer;
	strcat(buffer,string);
  	fl_set_input(fd_gui_sql->GUI_SQL_Input,input);
}

void all_cb(FL_OBJECT *ob, long data)
{
	Put_Query(" * ");
}
