/* install.cmd
 *
 * installation script for mSQL (OS/2)
 * installs all executables, libraries, headers and documentation in the
 * appropriate directory structure; creates an WPS folder with the files.
 *
 * syntax:  install [directory]
 * where 'directory' is a destination, e.g. C:\PUBLIC\MSQL
 * default: \public\mSQL
 */

/*---| includes |-------------------------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

/*---| parameters |-----------------------------------------------------------*/
parse arg destDir
if destDir = "/?" | destDir = "-?" | destDir = "-h"
then do
  say "Usage: install [directory]"
  say
  say "where 'directory' is the place to install the files"
  exit
end
if destDir = ""
then do
  destDir = "\public\mSQL"
end
if "" = filespec("Drive", destDir)
then do
  destDir = filespec("Drive", directory())||destDir
end

/*---| replace '/' with '\' in path |-----------------------------------------*/
destDir = translate(destDir, "\\", "/")

/*---| set viewer and system editor |-----------------------------------------*/
editor = SysSearchPath("PATH", "e.exe")
viewer = SysSearchPath("PATH", "view.exe")

/*---| set source directory |-------------------------------------------------*/
sourceDir = directory()||"\"
if 0 < pos("msql-", sourceDir)
then do
  sourceDir = delstr(sourceDir, pos("\", sourceDir, pos("msql-", sourceDir)))
end
call directory(sourceDir)

/*---| intro |----------------------------------------------------------------*/
say
say "Starting install of mSQL for OS/2 software,"
say "using SOURCE='"sourceDir"' and DESTINATION='"destDir"'"

/*---| create directories |---------------------------------------------------*/
say "  creation of destination directories"
no=pos("\", destDir, 2)
do until no = 0
  say "   * "delstr(destDir, pos("\", destDir, no))
  call SysMkDir delstr(destDir, pos("\", destDir, no))
  no=pos("\", destDir, (no+1))
end
say "   * "destDir
call SysMkDir destDir
call SysMkDir destDir'\BIN'
call SysMkDir destDir'\DOC'
call SysMkDir destDir'\INCLUDE'
call SysMkDir destDir'\LIB'
call SysMkDir destDir'\MSQLDB'
call SysMkDir destDir'\TMP'
call SysMkDir destDir'\W3-mSQL'

/*---| bind icons to objects |------------------------------------------------*/
say "  bind icons to objects"
call SysSetIcon "bin\msql.exe",     "scripts\icons\msql.ico"
call SysSetIcon "bin\msqladm.exe",  "scripts\icons\msqladm.ico"
call SysSetIcon "bin\msqld.exe",    "scripts\icons\msqld.ico"
call SysSetIcon "bin\msqldump.exe", "scripts\icons\msqldump.ico"
call SysSetIcon "bin\relshow.exe",  "scripts\icons\relshow.ico"
call SysSetIcon "bin\w3-msql.exe",  "scripts\icons\w3-msql.ico"
call SysSetIcon "doc\mSQL.faq",     "scripts\icons\msql_inf.ico"
call SysSetIcon "doc\mSQL.inf",     "scripts\icons\msql_inf.ico"
call SysSetIcon "doc\W3-mSQL.inf",  "scripts\icons\msql_inf.ico"

/*---| copy files |-----------------------------------------------------------*/
say "  copy files to destination"
'@copy /b bin\*                     'destDir'\bin      > nul'
'@copy /b doc\*                     'destDir'\doc      > nul'
'@copy /b include\*                 'destDir'\include  > nul'
'@copy /b lib\*                     'destDir'\lib      > nul'
'@copy /b w3-msql\*                 'destDir'\w3-msql  > nul'

/*---| create workplace shell objects |---------------------------------------*/
say "  creation of WPS folder 'mSQL'"
if SysCreateObject("WPFolder", "mSQL", "<WP_DESKTOP>",,
                   "OBJECTID=<WP_mSQL>", "update")
then do
  say "   * folder created"
  if SysCreateObject("WPProgram", "mSQL-Server", "<WP_mSQL>",,
                     "PROGTYPE=FULLSCREEN;EXENAME="destDir"\bin\msqld.exe",,
                     "update")
  then do
    say "   * msqld"
  end
  if SysCreateObject("WPProgram", "local Monitor", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msql.exe;PARAMETERS=[database to use?]",,
                     "update")
  then do
    say "   * msql (local)"
  end
  if SysCreateObject("WPProgram", "remote Monitor", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msql.exe;PARAMETERS=-h [host?] [database to use?]",,
                     "update")
  then do
    say "   * msql (remote)"
  end
  if SysCreateObject("WPProgram", "Server Shutdown", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msqladm.exe;PARAMETERS=shutdown",,
                     "update")
  then do
    say "   * msqladm shutdown"
  end
  if SysCreateObject("WPProgram", "Server Reload", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msqladm.exe;PARAMETERS=reload",,
                     "update")
  then do
    say "   * msqladm reload"
  end
  if SysCreateObject("WPProgram", "Create DB", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msqladm.exe;PARAMETERS=create [database to create?]",,
                     "update")
  then do
    say "   * msqladm create"
  end
  if SysCreateObject("WPProgram", "Drop DB", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msqladm.exe;PARAMETERS=drop [database to create?]",,
                     "update")
  then do
    say "   * msqladm drop"
  end
  if SysCreateObject("WPProgram", "Dump", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\msqldump.exe;PARAMETERS=[database?]",,
                     "update")
  then do
    say "   * msqldump.exe"
  end
  if SysCreateObject("WPProgram", "Relations", "<WP_mSQL>",,
                     "EXENAME="destDir"\bin\relshow.exe;PARAMETERS=[database?] [table?]",,
                     "update")
  then do
    say "   * relshow.exe"
  end
  if SysCreateObject("WPProgram", "mSQL (Doc)", "<WP_mSQL>",,
                     "EXENAME="viewer";PARAMETERS="destDir"\doc\mSQL.inf",,
                     "update")
  then do
    say "   * mSQL.inf"
  end
  if SysCreateObject("WPProgram", "FAQ", "<WP_mSQL>",,
                     "EXENAME="editor";PARAMETERS="destDir"\doc\mSQL.faq",,
                     "update")
  then do
    say "   * mSQL.faq"
  end
  if SysCreateObject("WPProgram", "W3-mSQL (Doc)", "<WP_mSQL>",,
                     "EXENAME="viewer";PARAMETERS="destDir"\doc\W3-mSQL.inf",,
                     "update")
  then do
    say "   * W3-mSQL.inf"
  end
end

/*---| installation of package 'CLI/iODBC' |----------------------------------*/
if SysSetIcon("doc\iODBC.inf", "scripts\icons\msql_inf.ico")
then do
  say "  installation of package 'CLI/iODBC'"
  call SysMkDir destDir'\iODBC'
  call SysMkDir destDir'\iODBC\SAMPLES'
  '@copy /b iODBC\autoconf.cm_        'destDir'\iODBC\autoconf.cmd > nul'
  '@copy /b iODBC\*.mk                'destDir'\iODBC > nul'
  '@copy /b iODBC\*.txt               'destDir'\iODBC > nul'
  '@copy /b iODBC\SAMPLES\*           'destDir'\iODBC\SAMPLES > nul'
  if SysCreateObject("WPProgram", "CLI / iODBC", "<WP_mSQL>",,
                     "EXENAME="viewer";PARAMETERS="destDir"\doc\iODBC.inf",,
                     "update")
  then do
    say "   * iODBC.inf"
  end
end

/*---| done |-----------------------------------------------------------------*/
say "done."

/*============================================================================*/
