#include "zodbc.h"

void ProcessError (HENV henv, HDBC hdbc, HSTMT hstmt, UWORD fFocus );

ZODBC::ZODBC(ZODBCConnection* p):ZSQL((ZODBCConnection*)p)
{
Initialize();
Connection= p;
}


int ZODBC::Open(char* sql)
{
int i=0;
RETCODE rcode;
SDWORD x;
char buf[100];


if(!Connection)
	return 0;
if(hStmt)	{
	SQLFreeStmt(hStmt,SQL_UNBIND);
	SQLFreeStmt(hStmt,SQL_DROP);
	Connection->Log("Freeing statement resources");
	}
rcode=SQLAllocStmt(Connection->hDB,&hStmt);
if(rcode != SQL_SUCCESS && rcode!=SQL_SUCCESS_WITH_INFO)	{
		strcpy(ErrorMessage,"Error allocating memory for SQL statement");
		Connection->Log(ErrorMessage);
		return 0;
		}
rcode=SQLExecDirect(hStmt,sql,SQL_NTS);
Connection->Log("Executing sql: ",sql);
if(rcode!=SQL_SUCCESS&&rcode!=SQL_SUCCESS_WITH_INFO)	{
	if(rcode==SQL_ERROR)	{
		rcode=SQLError(Connection->hEnv,Connection->hDB,SQL_NULL_HSTMT,
			SQLErrCodeText, &SQLNativeError,ErrorMessage,MAXERRLEN-1,&SQLErrMsgSize);
		if(rcode==SQL_NO_DATA_FOUND)
			Connection->Log("Error getting error info...");
		else if(rcode==SQL_ERROR||rcode==SQL_INVALID_HANDLE)
			Connection->Log("Error in SQLError(...)...");
		else	{
			sprintf(ErrorMessage,"%s (%ld) : %s(%d bytes)",SQLErrCodeText,
				(long)SQLNativeError,ErrorMessage,SQLErrMsgSize);
			Connection->Log(ErrorMessage);
			}
		return 0;
		}
	else	{
		sprintf(ErrorMessage,"SQLExecDirect returned error %d",rcode);
		Connection->Log(ErrorMessage);
		}
	SQLFreeStmt(hStmt,SQL_DROP);
	Connection->Log(SQLErrCodeText,ErrorMessage);
	return 0;
	}
SQLTransact(Connection->hEnv,Connection->hDB,SQL_COMMIT);
Connection->Log("Commiting Transaction...",sql);
if(!strstr(sql,"select")&&!strstr(sql,"SELECT"))
	return 1;
Connection->Log("Retrieving results for select SQL...");
for(i=0;i<MAX_COLS;i++)	{
	if(SQLDescribeCol(hStmt,i+1,Field[i].Name,(SWORD)MAXFLDNAME,(SWORD*)&Field[i].Length,
	(SWORD*)&Field[i].Type,(UDWORD*)&Field[i].Precision,(SWORD*)&Field[i].Scale,
	(SWORD*)&Field[i].Nullable)==SQL_ERROR)	{
		NumCols=i;
		Connection->Log("SQL Complete: ",sql);
		return 1;
		}
	if(DataPtr[i-1])
		free((void*)DataPtr[i-1]);
	if((DataPtr[i-1]=(char*)malloc(Field[i].Precision))==NULL)	{
		Connection->Log("Error allocating data memory...bailing");
		return 0;
		}
	SQLBindCol(hStmt,i,SQL_C_CHAR,DataPtr[i],Field[i].Precision,&x);
	}
itoa(NumCols,buf,10);
Connection->Log("Number cols: ",buf);
Connection->Log("SQL Complete: ",sql);
return 1;
}

int ZODBC::GetNextRecord()
{
RETCODE rc;
rc=SQLFetch(hStmt);
if(rc!=SQL_SUCCESS)	{
	SQLError(Connection->hEnv,
		Connection->hDB,
		hStmt,
		SQLErrCodeText,
		&SQLNativeError,
		ErrorMessage,
		SQL_MAX_MESSAGE_LENGTH-1,
		&SQLErrMsgSize);
	Connection->Log(ErrorMessage);
	return 0;
	}
return 1;
}

int ZODBC::GetSQLData(int col,int* x)
{
if(!DataPtr[col])
	*x=atoi(DataPtr[col]);
else
	return 0;
return 1;
}

int ZODBC::GetSQLData(int col,float* x)
{
if(!DataPtr[col])
	*x=atof(DataPtr[col]);
else
	return 0;
return 1;

}


int ZODBC::GetSQLData(int col,char* res,int len)
{
if(!DataPtr[col])
	strncpy(res,DataPtr[col],len);
else
	return 0;
return 1;
}


int ZODBC::GetNumCols()
{
return NumCols;
}

int ZODBC::GetNumRows()
{
return NumRows;
}

void ZODBC::Initialize()
{
ZSQL::Initialize();
NumCols=0;
NumRows=0;
hStmt=NULL;

}

long ZODBC::Max(char* table,char* fld,char* Where)
{
return 0;
}

long ZODBC::Min(char* table,char* fld,char* Where)
{
return 0;
}

long ZODBC::Count(char* table,char* Where)
{
return 0;
}




//***********************************************************************
//			ZODBCConnection definitions
//***********************************************************************

ZODBCConnection::ZODBCConnection(char* db,char* user,char* pass):				ZDBConnection(db,user,pass)
{
Initialize();
if(user)
	SetUser(user);
if(pass)
	SetPassword(pass);
if(db)
	SetDB(db);
}

ZODBCConnection::~ZODBCConnection()
{
ShutDown();
}

int ZODBCConnection::SetDB(char* db)
{
RETCODE rcode;
UCHAR szConnStrIn[] = "";
SWORD cbConnStrIn = SQL_NTS;
UCHAR szConnStrOut[256] = "";
SWORD cbConnStrOutMax = 0;
SWORD pcbConnStrOut = 0;
char buf[256];

if(hDB)
	ShutDown();
strncpy(DBName,db,100);
rcode=SQLAllocEnv(&hEnv);
if(rcode != SQL_SUCCESS)	{
	Log("Error allocating memory for SQL environment");
	return 0;
	}
rcode=SQLAllocConnect(hEnv,&hDB);
if(rcode != SQL_SUCCESS)	{
	Log("Error allocating memory for SQL connection");
	strcpy(ErrorMessage,"Error allocating memory for SQL connection");
	SQLFreeEnv(hEnv);
	return 0;
	}
if(!db)	{
/*
	rcode = SQLDriverConnect(hDB, NULL, szConnStrIn,SQL_NTS,
				szConnStrOut, 255,
				&pcbConnStrOut, SQL_DRIVER_PROMPT);
	if (rcode != SQL_SUCCESS)
		ProcessError(SQL_NULL_HENV, hDB, SQL_NULL_HSTMT, CONNECTION);
	if( (rcode != SQL_SUCCESS_WITH_INFO) &&  (rcode != SQL_SUCCESS))
		return 0;
	sprintf(buf,"\nhdbc: %FX\nszConnStrIn: %s\ncbConnStrIn: %d"
				 "\nszConnStrOut: %s\ncbConnStrOutMax: %d"
				 "\npcbConnStrOut: %d", hDB,szConnStrIn, cbConnStrIn,
				szConnStrOut, cbConnStrOutMax,
				pcbConnStrOut);
	MessageBox(NULL,buf,"Info",MB_OK);
	*/
	return 0;
	}
rcode=SQLConnect(hDB,DBName,SQL_NTS,User,SQL_NTS,Password,SQL_NTS);
if(rcode!=SQL_SUCCESS && rcode!=SQL_SUCCESS_WITH_INFO)	{
	if(rcode==SQL_INVALID_HANDLE)
		Log("Invalid Handle");
	else	{
		if(SQLError(hEnv,hDB,SQL_NULL_HSTMT,SQLErrCodeText, &SQLNativeError,
			 ErrorMessage,SQL_MAX_MESSAGE_LENGTH-1,&SQLErrMsgSize)==SQL_SUCCESS){
			Log(SQLErrCodeText,ErrorMessage);
			}
		else
			Log("Error getting error code");
		}
	return 0;
	}
Log("Connected to Data Source: ",DBName);
return 1;
}

//****************************************************************************
//				ShutDown
//****************************************************************************
void ZODBCConnection::ShutDown()
{
if(hDB)	{
	SQLDisconnect(hDB);
	SQLFreeConnect(hDB);
	}
if(hEnv)
	SQLFreeEnv(hEnv);
hDB=NULL;
hEnv=NULL;
ErrorMessage[0]='\0';
Log("Disconnected from Data Source");
}

//****************************************************************************
//				Initialize
//****************************************************************************
void ZODBCConnection::Initialize()
{
hDB=NULL;
hEnv=NULL;
DBName[0]='\0';
User[0]='\0';
Password[0]='\0';
ErrorMessage[0]='\0';
}



void ProcessError (HENV henv, HDBC hdbc, HSTMT hstmt, UWORD fFocus ){

UCHAR szSqlState[6]="";
UCHAR FAR * lpErrorMsg;
UCHAR FAR * lpDialogMsg;
static int fEntry=0;
static GLOBALHANDLE hErrorMsg;
static GLOBALHANDLE hDialogMsg;
SDWORD sdwNativeError;
SWORD cbErrorMsgMax=SQL_MAX_MESSAGE_LENGTH-1;
SWORD cbErrorMsg=0;
RETCODE retcode=SQL_ERROR;

/* Process all Errors associated with the particular handle */

if (!fEntry) {
	if ((hErrorMsg = GlobalAlloc (GHND, (WORD) SQL_MAX_MESSAGE_LENGTH-1))
							==NULL){
		MessageBox(NULL, " Memory allocation error", "Memory",
						MB_ICONSTOP|MB_OK);
		return;
		}

	if (  (hDialogMsg = GlobalAlloc (GHND, (WORD) 1024)) == NULL   ) {
		MessageBox(NULL, " Memory allocation error", "Memory", 
						MB_ICONSTOP|MB_OK);
		return; 
    	}
	fEntry = 1;
}
lpErrorMsg 	= GlobalLock(hErrorMsg);
lpDialogMsg 	= GlobalLock (hDialogMsg);

while (1) {
if (fFocus == ENVIRON) 
	retcode = SQLError (henv, SQL_NULL_HDBC, SQL_NULL_HSTMT, 
				szSqlState, &sdwNativeError, lpErrorMsg, 
				cbErrorMsgMax, &cbErrorMsg);
else if (fFocus == CONNECTION)
	retcode = SQLError (SQL_NULL_HENV, hdbc, SQL_NULL_HSTMT, 
				szSqlState, &sdwNativeError, lpErrorMsg,
				cbErrorMsgMax, &cbErrorMsg);
else if (fFocus == STATEMENT)
	retcode = SQLError (SQL_NULL_HENV, SQL_NULL_HDBC, hstmt, 
				szSqlState, &sdwNativeError, lpErrorMsg, 
				cbErrorMsgMax, &cbErrorMsg);


	if (retcode == SQL_ERROR){
		MessageBox(NULL, "SQLError posted an error!",
					"SQLError", MB_OK|MB_ICONEXCLAMATION);
		return;
	}
	if ((retcode == SQL_SUCCESS_WITH_INFO) || (retcode == SQL_SUCCESS)){
			wsprintf(lpDialogMsg,
		"SQLState: %s\nNative Source Message:%ld\n Driver Message:%s ",
			(char FAR *) szSqlState,
					(SDWORD) sdwNativeError,
					(char FAR *)lpErrorMsg);

		MessageBox(NULL, lpDialogMsg, "SQL Message",
					MB_OK|MB_ICONINFORMATION);

	}
	if (retcode == SQL_NO_DATA_FOUND)
		return;
  } /* loop for retrieving every message */

GlobalUnlock (hErrorMsg);
GlobalUnlock (hDialogMsg);
}

