%{
 /*
 * This software is Copyright (c)  1989 by Leroy Cain.
 *
 * Permission is hereby granted to copy, reproduce, redistribute or
 * otherwise use this software as long as: there is no monetary
 * profit gained specifically from the use or reproduction or this
 * software, it is not sold, rented, traded or otherwise marketed
 * except under licence from the author, and this copyright notice
 * is included prominently in any copy made.
 *
 * The author makes no claims as to the fitness or correctness of
 * this software for any use whatsoever, and it is provided as is. 
 * Any use of this software is at the user's own risk.
 *
 */
%}
/*                             5.1 <character>                         */
DIGIT          [0-9]
LOWER          [a-z]
UPPER          [A-Z]
LETTER         ({UPPER}|{LOWER})
SPECIAL                [!-/]
EOL            [\n\r]
CHARACTER      {DIGIT}|{LETTER}|{SPECIAL}

/*                             5.2 <literal>                           */
UINT           {DIGIT}+
SINT           [+-]{DIGIT}+
ENL            ([+-])?({UINT}"."{UINT})|({UINT}".")|("."{UINT})
ANL            {ENL}[Ee]{SINT}

%%
{UPPER}("_"|{LETTER}|{DIGIT})* 
{
int    rw;
/*                             5.3 <token>                             */
       if(rw=rwlookup(yytext))
       {
               printf("Reserved Words '%s'\n",yytext);
               return rw;
       }
       else
       {
               printf("Got an IDENTIFIER '%s'\n",yytext);
               return IDENTIFIER;
       }
}

({ENL})|({ANL})                
{
       return NUMERIC;
}

{SINT} 
{
       return SINTEGER;
}

{UINT} 
{
       return UINTEGER;
}

\'[^\']*\'     
{
       return STRING;
}
","    return COMA;
"("    return LPAREN;
")"    return RPAREN;
"["    return LBRACKET;
"]"    return RBRACKET;
"<"    return GT;
">"    return LT;
"."    return PERIOD;
":"    return COLON;
";"    return SEMICOLON;
"="    return EQ;
"*"    return MULT;
"+"    return PLUS;
"-"    return SUB;
"/"    return DIV;
"<>"   return NEQ;
">="   return GE;
"<="   return LE;
--[^\n]*\n     /* COMMENT */;
[ \n\t]                /* SPACE */;
.      return ERROR;
%%

static struct
{
       char    *word;
       int     token;
} rwords[] =
{
"ALL", RW_ALL,
"AND", RW_AND,
"ANY", RW_ANY,
"AS", RW_AS,
"ASC", RW_ASC,
"AUTHORIZATION", RW_AUTHORIZATION,
"AVG", RW_AVG,
"BEGIN", RW_BEGIN,
"BETWEEN", RW_BETWEEN,
"BY", RW_BY,
"C", RW_C,
"CHAR", RW_CHAR,
"CHARACTER", RW_CHARACTER,
"CHECK", RW_CHECK,
"CLOSE", RW_CLOSE,
"COBOL", RW_COBOL,
"COMMIT", RW_COMMIT,
"CONTINUE", RW_CONTINUE,
"COUNT", RW_COUNT,
"CREATE", RW_CREATE,
"CURRENT", RW_CURRENT,
"CURSOR", RW_CURSOR,
"DEC", RW_DECIMAL,
"DECIMAL", RW_DECIMAL,
"DECLARE", RW_DECLARE,
"DEFAULT", RW_DEFAULT,
"DELETE", RW_DELETE,
"DESC", RW_DESC,
"DISTINCT", RW_DISTINCT,
"DOUBLE", RW_DOUBLE,
"END", RW_END,
"ESCAPE", RW_ESCAPE,
"EXEC", RW_EXEC,
"EXISTS", RW_EXISTS,
"FETCH", RW_FETCH,
"FLOAT", RW_FLOAT,
"FOR", RW_FOR,
"FOREIGN", RW_FOREIGN,
"FORTRAN", RW_FORTRAN,
"FOUND", RW_FOUND,
"FROM", RW_FROM,
"GO", RW_GO,
"GOTO", RW_GOTO,
"GRANT", RW_GRANT,
"GROUP", RW_GROUP,
"HAVING", RW_HAVING,
"IN", RW_IN,
"INDICATOR", RW_INDICATOR,
"INSERT", RW_INSERT,
"INT", RW_INT,
"INTEGER", RW_INTEGER,
"INTO", RW_INTO,
"IS", RW_IS,
"KEY", RW_KEY,
"LANGUAGE", RW_LANGUAGE,
"LIKE", RW_LIKE,
"MAX", RW_MAX,
"MIN", RW_MIN,
"MODULE", RW_MODULE,
"NOT", RW_NOT,
"NULL", RW_NULL,
"NUMERIC", RW_NUMERIC,
"OF", RW_OF,
"ON", RW_ON,
"OPEN", RW_OPEN,
"OPTION", RW_OPTION,
"OR", RW_OR,
"ORDER", RW_ORDER,
"PASCAL", RW_PASCAL,
"PLI", RW_PLI,
"PRECISION", RW_PRECISION,
"PRIMARY", RW_PRIMARY,
"PRIVILEGES", RW_PRIVILEGES,
"PROCEDURE", RW_PROCEDURE,
"PUBLIC", RW_PUBLIC,
"REAL", RW_REAL,
"REFERENCES", RW_REFERENCES,
"ROLLBACK", RW_ROLLBACK,
"SCHEMA", RW_SCHEMA,
"SECTION", RW_SECTION,
"SELECT", RW_SELECT,
"SET", RW_SET,
"SMALLINT", RW_SMALLINT,
"SOME", RW_SOME,
"SQL", RW_SQL,
"SQLCODE", RW_SQLCODE,
"SQLERROR", RW_SQLERROR,
"SUM", RW_SUM,
"TABLE", RW_TABLE,
"TO", RW_TO,
"UNION", RW_UNION,
"UNIQUE", RW_UNIQUE,
"UPDATE", RW_UPDATE,
"USER", RW_USER,
"VALUES", RW_VALUES,
"VIEW", RW_VIEW,
"WHENEVER", RW_WHENEVER,
"WHERE", RW_WHERE,
"WITH", RW_WITH,
"WORK", RW_WORK,
"",0
};

rwlookup(rw)
char   *rw;
{
int    x;

       for(x=0;rwords[x].token && strcmp(rw,rwords[x].word);x++);
       return rwords[x].token;
}
