/*
 * This software is Copyright (c)  1989 by Leroy Cain.
 *
 * Permission is hereby granted to copy, reproduce, redistribute or
 * otherwise use this software as long as: there is no monetary
 * profit gained specifically from the use or reproduction or this
 * software, it is not sold, rented, traded or otherwise marketed
 * except under licence from the author, and this copyright notice
 * is included prominently in any copy made.
 *
 * The author makes no claims as to the fitness or correctness of
 * this software for any use whatsoever, and it is provided as is. 
 * Any use of this software is at the user's own risk.
 *
 */
%token         IDENTIFIER
%token         UINTEGER
%token         SINTEGER
%token         NUMERIC
%token         STRING

%token         COMA
%token         LPAREN
%token         RPAREN
%token         LBRACKET
%token         RBRACKET
%token         PERIOD
%token         COLON
%token         SEMICOLON
%right         NEG 
%left          DIV MULT
%left          PLUS SUB
%left          EQ NEQ GT LT GE LE
%token         ERROR

%token         RW_CHAR
               RW_INT

%token         RW_ALL
               RW_AND
               RW_ANY
               RW_AS
               RW_ASC
               RW_AUTHORIZATION
               RW_AVG
               RW_BEGIN
               RW_BETWEEN
               RW_BY
               RW_C
               RW_CHARACTER
               RW_CHECK
               RW_CLOSE
               RW_COBOL
               RW_COMMIT
               RW_CONTINUE
               RW_COUNT
               RW_CREATE
               RW_CURRENT
               RW_CURSOR
               RW_DECIMAL
               RW_DECLARE
               RW_DEFAULT
               RW_DELETE
               RW_DESC
               RW_DISTINCT
               RW_DOUBLE
               RW_END
               RW_ESCAPE
               RW_EXEC
               RW_EXISTS
               RW_FETCH
               RW_FLOAT
               RW_FOR
               RW_FOREIGN
               RW_FORTRAN
               RW_FOUND
               RW_FROM
               RW_GO
               RW_GOTO
               RW_GRANT
               RW_GROUP
               RW_HAVING
               RW_IN
               RW_INDICATOR
               RW_INSERT
               RW_INTEGER
               RW_INTO
               RW_IS
               RW_KEY
               RW_LANGUAGE
               RW_LIKE
               RW_MAX
               RW_MIN
               RW_MODULE
               RW_NOT
               RW_NULL
               RW_NUMERIC
               RW_OF
               RW_ON
               RW_OPEN
               RW_OPTION
               RW_OR
               RW_ORDER
               RW_PASCAL
               RW_PLI
               RW_PRECISION
               RW_PRIMARY
               RW_PRIVILEGES
               RW_PROCEDURE
               RW_PUBLIC
               RW_REAL
               RW_REFERENCES
               RW_ROLLBACK
               RW_SCHEMA
               RW_SECTION
               RW_SELECT
               RW_SET
               RW_SMALLINT
               RW_SOME
               RW_SQL
               RW_SQLCODE
               RW_SQLERROR
               RW_SUM
               RW_TABLE
               RW_TO
               RW_UNION
               RW_UNIQUE
               RW_UPDATE
               RW_USER
               RW_VALUES
               RW_VIEW
               RW_WHENEVER
               RW_WHERE
               RW_WITH
               RW_WORK

%%
/*****************************************************************************/

/*-----------------------------------------------------------------------------
Parser for Module
-----------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------
Parser for ESQL
-----------------------------------------------------------------------------*/

ansi_sql_embedded:
         embedded_sql_statement
         { return ; }
       | embedded_sql_declare_section
         { return ; }
       ;


/*-----------------------------------------------------------------------------
Parser for SQL Statements
-----------------------------------------------------------------------------*/


/*------------------ B <Embedded Exception Declaration> ---------------------*/

embedded_exception_declaration:
       RW_WHENEVER condition exception_action
       ;

condition:
         RW_SQLERROR
       | RW_NOT RW_FOUND
       ;

exception_action:
       RW_CONTINUE
       | RW_GOTO target
       ;

target:
       COLON host_identifier
       | NUMERIC
       ;


/*-------------------- A <Embedded SQL host program> ------------------------*/


embedded_sql_statement:
         sql_prefix declare_cursor sql_terminator
       | embedded_exception_declaration
       | sql_prefix sql_statement sql_terminator
       | sql_prefix schema sql_terminator
       ;

sql_prefix:
       RW_SQL
       ;

sql_terminator:
       RW_END RW_EXEC
       | SEMICOLON
       ;

embedded_sql_declare_section:
       sql_prefix RW_BEGIN RW_DECLARE RW_SECTION sql_terminator
       host_variable_definition_list SEMICOLON
       RW_EXEC sql_prefix RW_END RW_DECLARE RW_SECTION sql_terminator
       ;

host_variable_definition_list:
         c_variable_definition
       | host_variable_definition_list SEMICOLON c_variable_definition
       ;

c_variable_definition:
         RW_CHAR IDENTIFIER
       | RW_CHAR IDENTIFIER LBRACKET UINTEGER RBRACKET
       | RW_INT IDENTIFIER
       | RW_FLOAT IDENTIFIER
       | RW_DOUBLE IDENTIFIER
       ;


/*------------------ 8.12 <Update Statement: Searched> ----------------------*/

update_statement_search:
       RW_UPDATE table_name
       RW_SET set_clause_list
       RW_WHERE search_condition
       ;

/*----------------- 8.11 <Update Statement: Positioned> ---------------------*/

update_statement_position:
       RW_UPDATE table_name
       RW_SET set_clause_list
       RW_WHERE RW_CURRENT RW_OF cursor_name
       ;

set_clause_list:
       set_clause
       | set_clause_list COMA set_clause
       ;

set_clause:
         column_name EQ value_expression
       | column_name EQ RW_NULL
       ;

/*----------------------- 8.10 <Select Statement> ---------------------------*/

select_statement:
       RW_SELECT op_ad select_list
       RW_INTO select_target_list
       table_expression
       ;

select_target_list:
         target_specification
       | select_target_list COMA target_specification
       ;


/*---------------------- 8.9 <Rollback Statement> ---------------------------*/

rollback_statement:
       RW_ROLLBACK RW_WORK
       ;

/*------------------------ 8.8 <Open Statement> -----------------------------*/

open_statement:
       RW_OPEN cursor_name
       ;

/*------------------------ 8.7 <Insert Statement> ---------------------------*/

insert_statement:
         RW_INSERT RW_INTO table_name op_insert_column_list
         RW_VALUES LPAREN insert_value_list RPAREN
       | RW_INSERT RW_INTO table_name op_insert_column_list
         query_specification
       ;

op_insert_column_list:
       | LPAREN insert_column_list RPAREN
       ;

insert_column_list:
       column_name
       | insert_column_list COMA column_name
       ;

insert_value_list:
       insert_value
       | insert_value_list COMA insert_value
       ;

insert_value:
       value_specification
       | RW_NULL
       ;

/*------------------------ 8.6 <Fetch Statement> ----------------------------*/

fetch_statement:
       RW_FETCH cursor_name
       RW_INTO fetch_target_list

       ;

fetch_target_list:
       target_specification
       | fetch_target_list COMA target_specification
       ;


/*------------------- 8.5 <Delete Statement: Searched> ----------------------*/

delete_statement_search:
       RW_DELETE RW_FROM table_name
       op_where_clause
       ;

/*------------------ 8.4 <Delete Statement: Positioned> ---------------------*/

delete_statement_position:
       RW_DELETE RW_FROM table_name
       RW_WHERE RW_CURRENT RW_OF cursor_name
       ;

/*------------------------ 8.3 <Declare Cursor> -----------------------------*/

declare_cursor:
       RW_DECLARE cursor_name RW_CURSOR
       RW_FOR cursor_specification
       ;

cursor_specification:
         query_expression
       | query_expression order_by_clause
       ;

query_expression:
         query_term
       | query_expression RW_UNION op_all query_term 
       ;

query_term:
       query_specification
       | LPAREN query_expression RPAREN
       ;

order_by_clause:
       RW_ORDER RW_BY sort_specification_list
       ;

sort_specification_list:
       sort_specification
       | sort_specification_list COMA sort_specification
       ;

sort_specification:
         NUMERIC op_asc_desc
       | column_specification op_asc_desc
       ;

op_asc_desc:
       | RW_ASC
       | RW_DESC
       ;

/*------------------------ 8.2 <Commit Statement> ---------------------------*/

commit_statement:
       RW_COMMIT RW_WORK
       ;

/*------------------------ 8.1 <Close Statement> ----------------------------*/

close_statement:
       RW_CLOSE cursor_name
       ;

/*--------------------------- 7.3 <Procedure> -------------------------------*/



sql_statement:
         close_statement
       | commit_statement
       | delete_statement_position
       | delete_statement_search
       | fetch_statement
       | insert_statement
       | open_statement
       | rollback_statement
       | select_statement


       | update_statement_position
       | update_statement_search
       ;

/*----------------------- 7.2 <Module Name Clause> --------------------------*/



/*----------------------------- 7.1 <Module> --------------------------------*/



/*---------------------- 6.10 <privilege definition> ------------------------*/

privilege_definition:
       RW_GRANT privileges RW_ON table_name
       RW_TO grantee_list
       op_with_grant_option
       ;

op_with_grant_option:
       | RW_WITH RW_GRANT RW_OPTION
       ;

privileges:
       RW_ALL RW_PRIVILEGES
       | action_list
       ;

action_list:
       action
       | action_list COMA action
       ;

action:
       RW_SELECT
       | RW_INSERT
       | RW_DELETE
       | RW_UPDATE op_grant_column_list
       ;

op_grant_column_list:
       | LPAREN grant_column_list RPAREN
       ;

grant_column_list:
         column_name
       | grant_column_list COMA column_name
       ;

grantee_list:
         grantee
       | grantee_list COMA grantee
       ;

grantee:
       RW_PUBLIC
       | authorization_identifier
       ;

/*------------------------- 6.9 <view definition> ---------------------------*/

view_definition:
       RW_CREATE RW_VIEW table_name op_view_column_list
       RW_AS query_specification
       op_with_check_option
       ;

op_view_column_list:
       | LPAREN view_column_list RPAREN
       ;

view_column_list:
       column_name
       | view_column_list COMA column_name
       ;

op_with_check_option:
       | RW_WITH RW_CHECK RW_OPTION
       ;

/*----------------- 6.8 <Check Constraint Definition> -----------------*/

check_constraint_definition:
       RW_CHECK LPAREN search_condition RPAREN
       ;

/*----------------- 6.7 <Referential Constraint Definition> -----------------*/

referential_constraint_definition:
       RW_FOREIGN RW_KEY LPAREN references_columns RPAREN
       references_specification
       ;

references_specification:
       RW_REFERENCES referenced_table_and_columns
       ;

references_columns:
       references_column_list
       ;

referenced_table_and_columns:
         table_name
       | table_name LPAREN references_column_list RPAREN
       ;

references_column_list:
         column_name
       | references_column_list COMA column_name
       ;

/*------------------- 6.6 <Unique Constraint Definition> --------------------*/

unique_constraint_definition:
         RW_UNIQUE LPAREN unique_column_list RPAREN
       | RW_PRIMARY RW_KEY LPAREN unique_column_list RPAREN
       ;

unique_column_list:
         column_name
       | unique_column_list COMA column_name
       ;
       
/*------------------- 6.5 <Table Constraint Definition> --------------------*/

table_constraint_definition:
       unique_constraint_definition
       | referential_constraint_definition
       | check_constraint_definition
       ;

/*-------------------------- 6.4 <Default Clause> ---------------------------*/

default_clause:
         RW_DEFAULT literal
       | RW_DEFAULT RW_NULL
       | RW_DEFAULT RW_USER
       ;

/*------------------------ 6.3 <Column Definition> --------------------------*/

column_definiton:
       column_name data_type
       op_default_clause
       op_column_constraint_list
       ;

op_default_clause:
       |default_clause
       ;

op_column_constraint_list:
       | column_constraint op_column_constraint_list
       ;

column_constraint:
         RW_NOT RW_NULL
       | RW_NOT RW_NULL RW_UNIQUE
       | references_specification
       | RW_CHECK LPAREN search_condition RPAREN
       ;

/*------------------------ 6.2 <table definition> ---------------------------*/

table_definition:
       RW_CREATE RW_TABLE table_name
       LPAREN  table_element_list RPAREN
       ;

table_element_list:
         table_element
       | table_element_list COMA table_element
       ;
       
table_element:
         column_definiton
       | table_constraint_definition
       ;
       
/*----------------------------- 6.1 <schema> --------------------------------*/

schema:
       RW_CREATE RW_SCHEMA schema_authorization_clause
       schema_element_list
       ;

schema_authorization_clause:
       RW_AUTHORIZATION schema_authorization_identifier
       ;

schema_authorization_identifier:
       authorization_identifier
       ;

schema_element_list:
         schema_element
       | schema_element_list schema_element
       ;

schema_element:
         table_definition
       | view_definition
       | privilege_definition
       ;

/*****************************************************************************/
/*---------------------- 5.25 <query specification> -------------------------*/

query_specification:
       RW_SELECT op_ad select_list table_expression
       ;

select_list:
         value_expression_list
       | MULT
       ;

value_expression_list:
         value_expression
       | value_expression_list COMA value_expression
       ;

/*---------------------------- 5.24 <subquery> ------------------------------*/

subquery:
       LPAREN RW_SELECT op_ad result_specification table_expression RPAREN
       ;

op_ad:
       | RW_ALL
       | RW_DISTINCT
       ;

result_specification:
       value_expression
       | MULT
       ;

/*------------------------- 5.23 <having clause> ----------------------------*/

having_clause:
       RW_HAVING search_condition
       ;

/*------------------------ 5.22 <group by clause> ---------------------------*/

group_by_clause:
       RW_GROUP RW_BY column_specification_list

column_specification_list:
         column_specification
       | column_specification_list COMA column_specification
       ;

/*-------------------------- 5.21 <where clause> ----------------------------*/

where_clause:
       RW_WHERE search_condition
       ;

/*-------------------------- 5.20 <from clause> -----------------------------*/

from_clause:
       RW_FROM table_reference_list
       ;

table_reference_list:
         table_reference
       | table_reference_list COMA table_reference
       ;

table_reference:
         table_name
       | table_name correlation_name
       ;

/*----------------------- 5.19 <search condiction> --------------------------*/

table_expression:
       from_clause
       op_where_clause
       op_group_by_clause
       op_having_clause
       ;

op_where_clause:
       | where_clause
       ;

op_group_by_clause:
       | group_by_clause
       ;

op_having_clause:
       | having_clause
       ;

/*----------------------- 5.18 <search condiction> --------------------------*/

search_condition:
       boolean_term
       | search_condition RW_OR boolean_term
       ;

boolean_term:
       boolean_factor
       | boolean_term RW_AND boolean_factor
       ;

boolean_factor:
         boolean_primary
       | RW_NOT boolean_primary
       ;

boolean_primary:
         predicate
       | LPAREN search_condition RPAREN
       ;

/*------------------------ 5.17 <exists_predicate> --------------------------*/

exists_predicate:
       RW_EXISTS subquery
       ;

/*---------------------- 5.16 <quantified_predicate> ------------------------*/

quantified_predicate:
       value_expression comp_op quantifier subquery
       ;

quantifier:
         all
       | some
       ;
all:
       RW_ALL
       ;

some:
         RW_SOME
       | RW_ANY
       ;

/*------------------------- 5.15 <null_predicate> ---------------------------*/

null_predicate:
       column_specification RW_IS op_not RW_NULL
       ;

/*------------------------- 5.14 <like_predicate> ---------------------------*/

like_predicate:
         column_specification op_not RW_LIKE pattern op_escape
       ;

op_escape:
       RW_ESCAPE escape_character
       ;

pattern:
         value_specification
       ;

escape_character:
         value_specification
       ;

/*-------------------------- 5.13 <in_predicate> ----------------------------*/

in_predicate:
         value_expression op_not RW_IN subquery
       | value_expression op_not RW_IN LPAREN in_value_list RPAREN
       ;

in_value_list:
         value_specification
       | in_value_list COMA value_specification
       ;

/*------------------------ 5.12 <between_predicate> -------------------------*/

between_predicate:
       value_expression op_not
               RW_BETWEEN value_expression RW_AND value_expression
       ;

op_not:
       | RW_NOT
       ;

/*---------------------- 5.11 <comparison_predicate> ------------------------*/

comparison_predicate:
         value_expression comp_op value_expression
       | value_expression comp_op subquery
       ;

comp_op:
         EQ
       | NEQ
       | LT
       | GT
       | LE
       | GE
       ;

/*--------------------------- 5.10 <predicate> ------------------------------*/

predicate:
         comparison_predicate
       | between_predicate
       | in_predicate
       | like_predicate
       | null_predicate
       | quantified_predicate
       | exists_predicate
       ;

/*------------------------ 5.9 <value expression> ---------------------------*/

value_expression:
         value_expression MULT value_expression 
       | value_expression DIV value_expression 
       | value_expression PLUS value_expression 
       | value_expression SUB value_expression 
       | primary
       | factor
       ;

factor:
         PLUS primary
       | SUB primary
       ;

primary:
         value_specification
       | column_specification
       | set_function_specification
       | LPAREN value_expression RPAREN
       ;

/*------------------- 5.8 <set function specification> ----------------------*/

set_function_specification:
       RW_COUNT LPAREN MULT RPAREN
       | distinct_set_function
       | all_set_function
       ;

distinct_set_function:
         RW_AVG LPAREN RW_DISTINCT column_specification RPAREN
       | RW_MAX LPAREN RW_DISTINCT column_specification RPAREN
       | RW_MIN LPAREN RW_DISTINCT column_specification RPAREN
       | RW_SUM LPAREN RW_DISTINCT column_specification RPAREN
       | RW_COUNT LPAREN RW_DISTINCT column_specification RPAREN
       ;

all_set_function:
         RW_AVG LPAREN op_all value_expression RPAREN
       | RW_MAX LPAREN op_all value_expression RPAREN
       | RW_MIN LPAREN op_all value_expression RPAREN
       | RW_SUM LPAREN op_all value_expression RPAREN
       | RW_COUNT LPAREN op_all value_expression RPAREN
       ;

op_all:
       | RW_ALL
       ;


/*--------------------- 5.7 <column specification> --------------------------*/
column_specification:
       column_name
       | IDENTIFIER PERIOD column_name
       ;

/*
qualifier::=
       <table_name> | <correlation_name>
*/

/*---------- 5.6 <value specification> and <target specification> -----------*/

value_specification:
         parameter_specification
       | variable_specification
       | literal
       | RW_USER
       ;

target_specification:
         parameter_specification
       | variable_specification
       ;


parameter_specification:
       IDENTIFIER op_indicator IDENTIFIER
       ;

variable_specification:
       COLON IDENTIFIER op_indicator IDENTIFIER
       ;

op_indicator:
       | RW_INDICATOR
       ;

/*
<target_specification>::=
       <parameter_specification> | <variable_specification>

parameter_specification:
       parameter_name indicator_parameter
       ;

indicator_parameter:
       op_indicator parameter_name
       ;

variable_specification:
       embedded_variable_name indicator_variable
       ;

indicator_variable:
       op_indicator embedded_variable_name
       ;
*/

/*--------------------------- 5.5 <data type> -------------------------------*/

data_type:
         char_string_type
       | exact_numeric_type
       | approx_numeric_type
       ;

char_string_type:
         RW_CHARACTER
       | RW_CHARACTER LPAREN length RPAREN
       ;

exact_numeric_type:
       RW_NUMERIC LPAREN precision op_scale RPAREN
       | RW_DECIMAL LPAREN precision op_scale RPAREN
       | RW_INTEGER
       | RW_SMALLINT
       ;

op_scale:
       | COMA scale
       ;

approx_numeric_type:
       RW_FLOAT LPAREN precision RPAREN
       | RW_REAL
       | RW_DOUBLE RW_PRECISION
       ;

length:
       UINTEGER
       ;

precision:
       UINTEGER
       ;

scale:
       UINTEGER
       ;

/*----------------------------- 5.4 Names -----------------------------------*/
table_name:
       table_identifier
       | authorization_identifier PERIOD table_identifier
       ;

authorization_identifier:
       IDENTIFIER
       ;

table_identifier:
       IDENTIFIER
       ;

column_name:
       IDENTIFIER
       ;

correlation_name:
       IDENTIFIER
       ;

host_identifier:
       IDENTIFIER
       ;


cursor_name:
       IDENTIFIER
       ;



/*----------------------------- 5.2 <literal> --------------------------------*/

literal:
         STRING
       | NUMERIC
       | UINTEGER
       | SINTEGER
       ;
%%

#ifdef INTERNAL
extern char    *sqlbuf;
#      include "ilex.yy.c"
#else
#      include "lex.yy.c"
#endif

yyerror(s)
char   *s;
{
       fprintf(stderr,"%d:%s\n",yylineno,s);
}

yywrap()
{
       return 1;
}
