/*
 * This software is Copyright (c)  1989 by Leroy Cain.
 *
 * Permission is hereby granted to copy, reproduce, redistribute or
 * otherwise use this software as long as: there is no monetary
 * profit gained specifically from the use or reproduction or this
 * software, it is not sold, rented, traded or otherwise marketed
 * except under licence from the author, and this copyright notice
 * is included prominently in any copy made.
 *
 * The author makes no claims as to the fitness or correctness of
 * this software for any use whatsoever, and it is provided as is. 
 * Any use of this software is at the user's own risk.
 *
 */

#include <stdio.h>
#include "y.esql.h"

/*
Embedded SQL file.esql
*/
main(argc,argv)
int    argc;           /* Argument Count */
char   *argv[];        /* Argument Vector */
{
int    c;              /* Current command line argument */
int    errflg;         /* Error flag */
FILE   *esqlfd;                /* ESQL file descriptor */
extern char    *optarg;/* Option argument */
extern int     optind;/* Option index */

       errflg=0;
       /* Get arguments */
       while((c = getopt(argc,argv,"l:")) != -1)
       {
               switch(c)
               {
               case 'l':
                       break;
               case '?':
                       errflg++;
               }
       }

       if(optind>=argc && argc!= 1)
       {
               fprintf(stderr,"Usage:esql [file_name]\n");
               exit(1);
       }

       /* open file */
       if(argc>1)
       {
               if(!((esqlfd=fopen(argv[optind],"r")) != NULL))
               {
                       fprintf(stderr,"Can't open file %s\n",argv[optind]);
               }
#ifdef ansi
               _stp->_fblk[0] = *esqlfd;
#else
               _iob[0] = *esqlfd;
#endif
       }

       while( (c=yylex())>0 )
       {
               if( c==RW_EXEC)
               {
                       yyparse();
               }
       }
}
