//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Complex.h>
#include <test.h>
 
int main (void) {
  START("Complex");
  Complex c1;
  TEST ("Complex c1", c1.status(), N_OK);
  Complex c2(3.0,5.0);
  TEST ("Complex c2(3.0,5.0)", c2.status(), N_OK);
  TEST ("c2.real()", c2.real(), 3.0);
  TEST ("c2.imaginary()", c2.imaginary(), 5.0);
  TEST ("c1 != c2", c1 != c2, TRUE);
  Complex c3(9.0);
  TEST ("Complex c3(9.0)", c3.status(), N_OK);
  TEST ("c3.real()", c3.real(), 9.0);
  TEST ("c3.imaginary()", c3.imaginary(), 0.0);
  Complex c4(6,10);
  TEST ("Complex c4(6,10)", c4.status(), N_OK);
  TEST ("c4.real()", c4.real(), 6.0);
  TEST ("c4.imaginary()", c4.imaginary(), 10.0);
  TEST ("c2 == c4", c2 == c4, FALSE);
  TEST ("c1 = c2", c1.operator=(c2), c2);
  TEST ("c1.status()", c1.status(), N_OK);
  TEST ("c1.real()", c1.real(), 3.0);
  TEST ("c1.imaginary()", c1.imaginary(), 5.0);
  TEST ("c1 == c4", c1 == c4, FALSE);
  TEST ("-c3",(c1 = -c3,(c1.real() == -9.0 && c1.imaginary() == 0.0)),TRUE);
  TEST ("c1 = -c3", (c1.real() == -9.0 && c1.imaginary() == 0.0), TRUE);
  Complex c5(c4);
  TEST ("Complex c5(c4)", c4 == c5, TRUE);
  TEST ("!c5", !c5, FALSE);
  TEST ("c5 = c2", (c5 = c2, c5 == c2), TRUE);
  TEST ("c5--", (c5--, c5.real() == 2.0 && c5.imaginary() == 5.0), TRUE);
  TEST ("c5++", (c5++, c5.real() == 3.0 && c5.imaginary() == 5.0), TRUE);
  c5 = c5.invert ();
  TEST ("c5 = c5.invert ()", (c5.real()<=0.089 && c5.real() >= 0.088 &&
	   c5.imaginary()<=-0.14 && c5.imaginary()>=-0.15), TRUE);
  TEST ("c1=c2+c4",(c1=c2+c4,c1.real()==9.0 && c1.imaginary()==15.0),TRUE);
  TEST ("c1=c2-c4",(c1=c2-c4,c1.real()==-3.0 && c1.imaginary()==-5.0),TRUE);
  TEST ("c1=c2*c4",(c1=c2*c4,c1.real()==-32.0 && c1.imaginary()==60.0),TRUE);
  TEST ("c1=c2/c4",(c1=c2/c4,c1.real()==0.5 && c1.imaginary()==0.0),TRUE);
  TEST ("c2+=c4",(c2+=c4,c2.real()==9.0 && c2.imaginary()==15.0),TRUE);
  TEST ("c2-=c4",(c2-=c4,c2.real()==3.0 && c2.imaginary()==5.0),TRUE);
  TEST ("c2*=c4",(c2*=c4,c2.real()==-32.0 && c2.imaginary()==-290.0),TRUE);
  TEST ("c2/=c4",(c2/=c4, (c2.real()<=-22.73 && c2.real() >= -22.74 &&
           c2.imaginary()<=-10.44 && c2.imaginary()>=-10.45)),TRUE);
  SUMMARY();
  return 0;
}


