//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MJF 02/23/90 -- New member function for initializing group_names

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Member function of the Exception class
// **********************************************************************

// Exception::set_group_names(Excp_Type) - sets the group name of Exception
//                                         to the specified exception type.
// Input:   An Exception type.
// Output:  None

void Exception::set_group_names(Excp_Type etype) {
  this->group_names = (Excp_Type*) new Excp_Type[2];
  this->group_names[0] = etype;
  this->group_names[1] = NULL;  // null terminated array
}
