//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- Split into separate file.
// Updated: MJF 02/22/90 -- Changed to delete array of group names.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// ******************************************************
// Destructor for Exception class
// ******************************************************

// Exception::~Exception() - the Exception destructor deletes the array
//                           of group names.
//
// Input:   None.
// Output:  None.

Exception::~Exception() {
 if (this->group_names != NULL) {
   int n;
   for (n = 1; this->group_names[n] != NULL; n++);
   delete [n] this->group_names;
 }
}
