//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/19/89 -- Initial design and implementation
// Updated: MBN 09/18/89 -- Changed package name to uppercase

#include <cool/Generic.h>

#if GENERIC_TYPECHECK

// Support an efficient typecase macro using select.
// A null-terminated list of Symbol*'s is passed in, and the
// index of the matching type symbol is returned, or -1 if none match.
// This is used ONLY by the inline select_type_of method.
//
// Example:
//   void foo (generic* g) {
//     static Symbol* switch_symbols_xxx[] = { SYM(Vector), Sym(List), NULL };
//     switch (select_type_of(g, switch_symbols_xxx) {
//     case 0: // code for Vector
//     case 1: // code for List
//     default: // other types
//     }
//   }

int compare_multiple_types(Symbol** our_type, const Symbol** test_types) {
  while(TRUE) {
    Symbol* class_name = *our_type;
    int i = 0;
    const Symbol** tt;
    const Symbol* t;

    for(tt = test_types; (t = *tt++) != NULL; i++)
      if (t == class_name) return(i);
    if (*++our_type == NULL)	// No base class
      return(-1);
    else if (our_type[1] == NULL)
      our_type = (Symbol**) *our_type;
    else
      while(TRUE)
	if((i = compare_multiple_types(our_type, test_types)) >= 0 ||
	   *++our_type == NULL)
	  return(i);
  }
}

#endif
