//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 09/26/89 -- Initial implementation
// Updated: MJF 03/12/90 -- Added group names to RAISE

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// key_error -- Raise exception for Hash_Table::key()
// Input:       None
// Output:      None
     
void Hash_Table::key_error (const char* T1, const char* T2) {
  RAISE (Error, SYM(Hash_Table), SYM(Invalid_Cpos),
	 "Hash_Table<%s,%s>::key(): Invalid current position", T1, T2);
}
