//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>
#include <cool/Pair.h>
#include <test.h>

DECLARE Pair<int,char>;
IMPLEMENT Pair<int,char>;
DECLARE Pair<double,String>;
IMPLEMENT Pair<double,String>;


Boolean compare_double_String(const Pair<double,String>& s1,const Pair<double,String>& s2){
  if (s1.get_first() == s2.get_first() && s1.get_second() == s2.get_second())
    return TRUE;
  return FALSE;
}

void test_int_char () {
  Pair<int,char> p0;
  TEST("Pair<int,char> p0", 1, 1);
  Pair<int,char> p1(1,'a');
  TEST("Pair<int,char> p1(1,'a')", 1, 1);
  Pair<int,char> p2(p1);
  TEST("Pair<int,char> p2 = p1", 1, 1);
  TEST("p1.get_first()", p1.get_first(), 1);
  TEST("p2.get_second()", p2.get_second(), 'a');
  p1.set_first(2);
  TEST("p1.set_first(2)", p1.get_first(), 2);
  p1.set_second('b');
  TEST("p1.set_second('b')", p1.get_second(), 'b');
  TEST("p2 = p1", (p2 = p1), p1);
  TEST("p1 == p2", (p1 == p2), TRUE);
  TEST("p1 != p2", (p1 != p2), FALSE);
}


// Cfront 2.0 has a bug (one of MANY) which prevents us from passing
// a constant "string" as a const char*&
#ifdef __cplusplus
void test_int_charP () {
  TEST ("ALL Pair<int,char*> tests fail because of Cfront 2.0 bug", 0, 1);
}
#else
DECLARE Pair<int,char*>;
IMPLEMENT Pair<int,char*>;

Boolean compare_int_charP(const Pair<int,char*>& s1,const Pair<int,char*>& s2){
  if (s1.get_first() == s2.get_first() &&
      (strcmp (s1.get_second(), s2.get_second()) == 0))
    return TRUE;
  return FALSE;
}

void test_int_charP () {
  Pair<int,char*> p0;
  TEST("Pair<int,char*> p0", 1, 1);
  Pair<int,char*> p1(1,"AAA");
  TEST("Pair<int,char*> p1(1,\"AAA\")", 1, 1);
  p1.set_compare(&compare_int_charP);
  TEST ("p1.set_compare(&compare_int_charP)", 1,1);
  Pair<int,char*> p2(p1);
  TEST("Pair<int,char*> p2 = p1", 1, 1);
  TEST("p1.get_first()", p1.get_first(), 1);
  TEST("p1.get_second()", strcmp (p1.get_second(), "AAA"), 0);
  TEST("p2.get_second()", strcmp (p2.get_second(), "AAA"), 0);
  p1.set_first(2);
  TEST("p1.set_first(2)", p1.get_first(), 2);
  p1.set_second("BBB");
  TEST("p1.set_second(\"BBB\")", strcmp (p1.get_second(), "BBB"), 0);
  TEST("p2 = p1", (p2 = p1), p1);
  TEST("p1 == p2", (p1 == p2), TRUE);
  TEST("p1 != p2", (p1 != p2), FALSE);
}
#endif

void test_double_String () {
  Pair<double,String> p0;
  TEST("Pair<double,String> p0", 1, 1);
  Pair<double,String> p1(1.0,String("AAA"));
  TEST("Pair<double,String> p1(1.0,String(\"AAA\"))", 1, 1);
  Pair<double,String> p2(p1);
  TEST("Pair<double,String> p2 = p1", 1, 1);
  TEST("p1.get_first()", p1.get_first(), 1);
  TEST("p1.get_second()", p1.get_second(), String("AAA"));
  TEST("p2.get_second()", p2.get_second(), String("AAA"));
  p1.set_first(2.0);
  TEST("p1.set_first(2.0)", p1.get_first(), 2.0);
  p1.set_second(String("BBB"));
  TEST("p1.set_second(String(\"BBB\"))", p1.get_second(), "BBB");
  TEST("p2 = p1", (p2 = p1), p1);
  TEST("p1 == p2", (p1 == p2), TRUE);
  TEST("p1 != p2", (p1 != p2), FALSE);
}

int main (void) {
  START("Pair");
  test_int_char ();
  test_int_charP ();
  test_double_String ();
  SUMMARY();
  return 0;
}  
