//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/05/90 -- Split into seperate files
//

#include <cool/char.h>		// Include char* specification header file

#if defined(DOS)
extern "C" {
#include <ctype.h>		// Include character processing macros
}
#else
#include <ctype.h>		// Include character processing macros
#endif

// c_upcase -- Convert all alphabetical characters to uppercase
// Input:      Character string 
// Output:     Updated string

char* c_upcase (char* s) {	// Convert entire string to upper case
  char* p = s;			// Point to beginning of string
  while (*p) {			// While there are still valid characters
    if (islower (*p))		// if this is lower case
      *p = toupper (*p);	// convert to uppercase 
    p++;			// Advance pointer
  }
  return s;			// Return reference to modified string
}
