//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>
#include <cool/Binary_Tree.h>
#include <test.h>

DECLARE Binary_Tree<int>
IMPLEMENT Binary_Tree<int>

DECLARE Binary_Tree<String>
IMPLEMENT Binary_Tree<String>

void test_int_remove(Binary_Tree<int>&);

void test_int_put () {  
  Binary_Tree<int> b0;

  TEST ("b0.put(10)", b0.put(10), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 0);
  TEST ("b0.put(7)", b0.put(7), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 1);
  TEST ("b0.put(15)", b0.put(15), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 1);
  TEST ("b0.put(8)", b0.put(8), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 2);
  TEST ("b0.put(2)", b0.put(2), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 2);
  TEST ("b0.put(12)", b0.put(12), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 2);
  TEST ("b0.put(4)", b0.put(4), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 3);
  TEST ("b0.put(6)", b0.put(6), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 4);
  TEST ("b0.put(5)", b0.put(5), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 5);
  TEST ("b0.put(14)", b0.put(14), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 5);
  TEST ("b0.put(11)", b0.put(11), TRUE);
  TEST ("b0.tree_depth()", b0.tree_depth(), 5);
  TEST ("b0.count()", b0.count(), 11);

  TEST ("b0.find(5),b0.node()->is_leaf()", 
        (b0.find(5),b0.node()->is_leaf()), TRUE);
  TEST ("b0.find(8),b0.node()->is_leaf()",
        (b0.find(8),b0.node()->is_leaf()), TRUE);
  TEST ("b0.find(11),b0.node()->is_leaf()",
        (b0.find(11),b0.node()->is_leaf()), TRUE);
  TEST ("b0.find(14),b0.node()->is_leaf()",
        (b0.find(14),b0.node()->is_leaf()), TRUE);
  TEST ("b0.find(10),b0.node() == b0.get_root()",
        (b0.find(10),b0.node() == b0.get_root()), TRUE);
  test_int_remove (b0);
}

void test_int_remove (Binary_Tree<int>& b0) {
  Binary_Node<int>* n0;
    
  TEST ("b0.remove(7)", b0.remove(7), TRUE);
  TEST ("b0.find(7)", b0.find(7), FALSE);
  TEST ("b0.count()", b0.count(), 10);
  TEST ("b0.tree_depth()", b0.tree_depth(), 4);
  TEST ("b0.find(6)", b0.find(6), TRUE);
  TEST ("(b0.node() == b0.get_root()->get_ltree())",
         (b0.node() == b0.get_root()->get_ltree()), TRUE);
  TEST ("b0.find(5)",b0.find(5),TRUE);
  n0 = b0.node();
  TEST ("(n0 == (b0.find(4),b0.node()->get_rtree()))",
         (n0 == (b0.find(4),b0.node()->get_rtree())), TRUE);
  TEST ("b0.find(8)",b0.find(8),TRUE);
  n0 = b0.node();
  TEST ("(n0 == (b0.find(6),b0.node()->get_rtree()))",
         (n0 == (b0.find(6),b0.node()->get_rtree())), TRUE);

  TEST ("b0.remove(12)", b0.remove(12), TRUE);
  TEST ("b0.find(12)", b0.find(12), FALSE);
  TEST ("b0.count()", b0.count(), 9);
  TEST ("b0.tree_depth()", b0.tree_depth(), 4);
  TEST ("b0.find(11)",b0.find(11), TRUE);
  n0 = b0.node();
  TEST ("(n0 == (b0.find(15),b0.node()->get_ltree()))",
         (n0 == (b0.find(15),b0.node()->get_ltree())), TRUE);
  TEST ("b0.find(14)",b0.find(14), TRUE);
  n0 = b0.node();
  TEST ("(n0 == (b0.find(11),b0.node()->get_rtree()))",
         (n0 == (b0.find(11),b0.node()->get_rtree())), TRUE);


  TEST ("b0.remove(10)", b0.remove(10), TRUE);
  TEST ("b0.count()", b0.count(), 8);
  TEST ("b0.tree_depth()", b0.tree_depth(), 4);
  TEST ("b0.find(10)", b0.find(10), FALSE);
  TEST ("b0.get_root() == (b0.find(8),b0.node())",
        b0.get_root() == (b0.find(8),b0.node()), TRUE)
  TEST ("b0.find(6)",b0.find(6), TRUE);
  n0 = b0.node();
  TEST ("(n0 == (b0.find(8),b0.node()->get_ltree()))",
         (n0 == (b0.find(8),b0.node()->get_ltree())), TRUE);

  TEST ("b0.remove(5)", b0.remove(5), TRUE);
  TEST ("b0.count()", b0.count(), 7);
  TEST ("b0.tree_depth()", b0.tree_depth(), 3);

  TEST ("b0.remove(2)", b0.remove(2), TRUE);
  TEST ("b0.count()", b0.count(), 6);
  TEST ("b0.tree_depth()", b0.tree_depth(), 3);
  TEST ("b0.find(4)",b0.find(4), TRUE);
  n0 = b0.node();
  TEST ("(n0 == (b0.find(6),b0.node()->get_ltree()))",
         (n0 == (b0.find(6),b0.node()->get_ltree())), TRUE);

  TEST ("b0.remove(15)", b0.remove(15), TRUE);
  TEST ("b0.count()", b0.count(), 5);
  TEST ("b0.find(11)",b0.find(11), TRUE);
  TEST ("((b0.node())==(b0.get_root()->get_rtree()))",
         ((b0.node())==(b0.get_root()->get_rtree())), TRUE);

  TEST ("b0.remove(14)", b0.remove(14), TRUE);
  TEST ("b0.count()", b0.count(), 4);
  TEST ("b0.tree_depth()", b0.tree_depth(), 2);
  TEST ("b0.find(11),b0.node()->is_leaf()",
	(b0.find(11),b0.node()->is_leaf()), TRUE);

  TEST ("b0.remove(8)", b0.remove(8), TRUE);
  TEST ("b0.count()", b0.count(), 3);
  TEST ("b0.tree_depth()", b0.tree_depth(), 1);
  TEST ("b0.get_root()==(b0.find(6),b0.node())",
        (b0.get_root()==(b0.find(6),b0.node())), TRUE);
  TEST ("b0.find(4)",b0.find(4), TRUE);
  n0 = b0.node();
  TEST ("(n0==(b0.find(6),b0.node()->get_ltree()))",
         (n0==(b0.find(6),b0.node()->get_ltree())), TRUE);

  TEST ("b0.remove(11)", b0.remove(11), TRUE);
  TEST ("b0.count()", b0.count(), 2);
  TEST ("b0.tree_depth()", b0.tree_depth(), 1);

  TEST ("b0.remove(6)", b0.remove(6), TRUE);
  TEST ("b0.count()", b0.count(), 1);
  TEST ("b0.tree_depth()", b0.tree_depth(), 0);
  TEST ("b0.get_root()==(b0.find(4),b0.node())",
        (b0.get_root()==(b0.find(4),b0.node())), TRUE);
  TEST ("b0.get_root()->is_leaf()",
        (b0.get_root()->is_leaf()), TRUE);

  TEST ("b0.remove(4)", b0.remove(4), TRUE);
  TEST ("b0.count()", b0.count(), 0);
  TEST ("b0.tree_depth()", b0.tree_depth(), 0);
  TEST ("b0.get_root()==NULL", (b0.get_root()==NULL), TRUE);

}

void test_int () {  
  Binary_Tree<int> b0;

  TEST ("Binary_Tree<int> b0", b0.count(), 0);
  TEST ("b0.put(1)", b0.put(1), TRUE);
  TEST ("b0.count()", b0.count(), 1);
  TEST ("b0.find(1)", b0.find(1), TRUE);
  TEST ("b0.value()", b0.value(), 1);
  TEST ("b0.remove()", b0.remove(), TRUE);
  TEST ("b0.count()", b0.count(), 0);
  TEST ("b0.put(4)", b0.put(4), TRUE);
  TEST ("b0.count()", b0.count(), 1);
  TEST ("b0.put(8)", b0.put(8), TRUE);
  TEST ("b0.count()", b0.count(), 2);
  TEST ("b0.put(3)", b0.put(3), TRUE);
  TEST ("b0.count()", b0.count(), 3);
  TEST ("b0.put(1)", b0.put(1), TRUE);
  TEST ("b0.count()", b0.count(), 4);
  TEST ("b0.put(2)", b0.put(2), TRUE);
  TEST ("b0.count()", b0.count(), 5);
  TEST ("b0.put(6)", b0.put(6), TRUE);
  TEST ("b0.count()", b0.count(), 6);
  TEST ("b0.find(2)", b0.find(2), TRUE);
  TEST ("b0.value()", b0.value(), 2);
  TEST ("b0.reset()", (b0.reset(), 1), 1);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 1);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 2);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 3);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 4);
  TEST ("b0.prev()", b0.prev(), TRUE);
  TEST ("b0.value()", b0.value(), 3);
  TEST ("b0.prev()", b0.prev(), TRUE);
  TEST ("b0.value()", b0.value(), 2);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 3);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 4);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 6);
  TEST ("b0.next()", b0.next(), TRUE);
  TEST ("b0.value()", b0.value(), 8);
  TEST ("b0.count()", b0.count(), 6);
  TEST ("b0.find(99)", b0.find(99), FALSE);
  Binary_Tree<int> b1(b0);
  TEST ("Binary_Tree<int> b1(b0)", b1.count(), 6);
  TEST ("b1.remove(3)", b1.remove(3), TRUE);
  TEST ("b1.count()", b1.count(), 5);
  TEST ("b1.find(3)", b1.find(3), FALSE);
  TEST ("b0.balance()", (b0.balance(), b0.count()), 6);
  TEST ("b0.remove(3)", b0.remove(3), TRUE);
  TEST ("b0.count()", b0.count(), 5);
  TEST ("b0.find(3)", b0.find(3), FALSE);
  TEST ("b0.put(-3)", b0.put(-3), TRUE);
  TEST ("b0.count()", b0.count(), 6);
  TEST ("b0.put(18)", b0.put(18), TRUE);
  TEST ("b0.count()", b0.count(), 7);
  TEST ("b0.put(13)", b0.put(13), TRUE);
  TEST ("b0.count()", b0.count(), 8);
  TEST ("b0.put(1)", b0.put(1), FALSE);
  TEST ("b0.count()", b0.count(), 8);
  TEST ("b0.put(5)", b0.put(5), TRUE);
  TEST ("b0.count()", b0.count(), 9);
  TEST ("b0.put(17)", b0.put(17), TRUE);
  TEST ("b0.count()", b0.count(), 10);
  TEST ("b0.put(3)", b0.put(3), TRUE);
  TEST ("b0.count()", b0.count(), 11);
  TEST ("b0.balance()", (b0.balance(), b0.count()), 11);
  TEST ("b0.find(3)", b0.find(3), TRUE);
  TEST ("b0.find(8)", b0.find(8), TRUE);
  TEST ("b0.find(9)", b0.find(9), FALSE);
  TEST ("b0.find(-3)", b0.find(-3), TRUE);
  TEST ("b0.find(17)", b0.find(17), TRUE);
  TEST ("b1=b0", (b1=b0, b0.count() == b1.count()), 1);
  TEST ("b1.find(3)", b1.find(3), TRUE);
  TEST ("b1.find(8)", b1.find(8), TRUE);
  TEST ("b1.find(9)", b1.find(9), FALSE);
  TEST ("b1.find(-3)", b1.find(-3), TRUE);
  TEST ("b1.find(17)", b1.find(17), TRUE);
}  

// Cfront 2.0 has a bug (one of MANY) which prevents us from passing
// a constant "string" as a const char*&
#ifdef __cplusplus
void test_charP () {
  TEST ("ALL Binary_Tree<char*> tests fail because of Cfront 2.0 bug", 0, 1);
}
#else
DECLARE Binary_Tree<char*>
IMPLEMENT Binary_Tree<char*>
int my_comp (const charP& s1, const charP& s2) {
  return strcmp (s1, s2);
}

void test_charP () {  
  Binary_Tree<char*> s0;
  TEST ("Binary_Tree<char*> s0", s0.count(), 0);
  TEST ("s0.set_compare(&my_comp)",(s0.set_compare(&my_comp),1),1);
  TEST ("s0.put(\"LLL\")", s0.put("LLL"), TRUE);
  TEST ("s0.count()", s0.count(), 1);
  TEST ("s0.find(\"LLL\")", s0.find("LLL"), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"LLL")), 0);
  TEST ("s0.remove()", s0.remove(), TRUE);
  TEST ("s0.count()", s0.count(), 0);
  TEST ("s0.put(\"DDD\")", s0.put("DDD"), TRUE);
  TEST ("s0.count()", s0.count(), 1);
  TEST ("s0.put(\"HHH\")", s0.put("HHH"), TRUE);
  TEST ("s0.count()", s0.count(), 2);
  TEST ("s0.put(\"CCC\")", s0.put("CCC"), TRUE);
  TEST ("s0.count()", s0.count(), 3);
  TEST ("s0.put(\"LLL\")", s0.put("LLL"), TRUE);
  TEST ("s0.count()", s0.count(), 4);
  TEST ("s0.put(\"BBB\")", s0.put("BBB"), TRUE);
  TEST ("s0.count()", s0.count(), 5);
  TEST ("s0.put(\"FFF\")", s0.put("FFF"), TRUE);
  TEST ("s0.count()", s0.count(), 6);
  TEST ("s0.find(\"BBB\")", s0.find("BBB"), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"BBB")), 0);
  TEST ("s0.reset()", (s0.reset(), 1), 1);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"BBB")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"CCC")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"DDD")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"FFF")), 0);
  TEST ("s0.prev()", s0.prev(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"DDD")), 0);
  TEST ("s0.prev()", s0.prev(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"CCC")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"DDD")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"FFF")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"HHH")), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),"LLL")), 0);
  TEST ("s0.count()", s0.count(), 6);
  TEST ("s0.find(\"JJJ\")", s0.find("JJJ"), FALSE);
  Binary_Tree<char*> s1(s0);
  TEST ("Binary_Tree<char*> s1(s0)", s1.count(), 6);
  TEST ("s0.balance()", (s0.balance(), s0.count()), 6);
  TEST ("s1.remove(\"CCC\")", s1.remove("CCC"), TRUE);
  TEST ("s1.count()", s1.count(), 5);
  TEST ("s1.find(\"CCC\")", s1.find("CCC"), FALSE);
  TEST ("s0.remove(\"CCC\")", s0.remove("CCC"), TRUE);
  TEST ("s0.count()", s0.count(), 5);
  TEST ("s0.find(\"CCC\")", s0.find("CCC"), FALSE);
  TEST ("s0.put(\"KKK\")", s0.put("KKK"), TRUE);
  TEST ("s0.count()", s0.count(), 6);
  TEST ("s0.put(\"MMM\")", s0.put("MMM"), TRUE);
  TEST ("s0.count()", s0.count(), 7);
  TEST ("s0.put(\"NNN\")", s0.put("NNN"), TRUE);
  TEST ("s0.count()", s0.count(), 8);
  TEST ("s0.put(\"LLL\")", s0.put("LLL"), FALSE);
  TEST ("s0.count()", s0.count(), 8);
  TEST ("s0.put(\"EEE\")", s0.put("EEE"), TRUE);
  TEST ("s0.count()", s0.count(), 9);
  TEST ("s0.put(\"GGG\")", s0.put("GGG"), TRUE);
  TEST ("s0.count()", s0.count(), 10);
  TEST ("s0.put(\"CCC\")", s0.put("CCC"), TRUE);
  TEST ("s0.count()", s0.count(), 11);
  TEST ("s0.balance()", (s0.balance(), s0.count()), 11);
  TEST ("s0.find(\"CCC\")", s0.find("CCC"), TRUE);
  TEST ("s0.find(\"HHH\")", s0.find("HHH"), TRUE);
  TEST ("s0.find(\"III\")", s0.find("III"), FALSE);
  TEST ("s0.find(\"KKK\")", s0.find("KKK"), TRUE);
  TEST ("s0.find(\"GGG\")", s0.find("GGG"), TRUE);
  TEST ("s1=s0", (s1=s0, s0.count() == s1.count()), 1);
  TEST ("s1.find(\"CCC\")", s1.find("CCC"), TRUE);
  TEST ("s1.find(\"HHH\")", s1.find("HHH"), TRUE);
  TEST ("s1.find(\"III\")", s1.find("III"), FALSE);
  TEST ("s1.find(\"KKK\")", s1.find("KKK"), TRUE);
  TEST ("s1.find(\"GGG\")", s1.find("GGG"), TRUE);
}  
#endif

void test_String_2 (Binary_Tree<String>& s0) {
  Binary_Tree<String> s1(s0);
  TEST ("Binary_Tree<String> s1(s0)", s1.count(), 6);
  TEST ("s0.balance()", (s0.balance(), s0.count()), 6);
  TEST ("s1.remove(String(\"CCC\"))", s1.remove(String("CCC")), TRUE);
  TEST ("s1.count()", s1.count(), 5);
  TEST ("s1.find(String(\"CCC\"))", s1.find(String("CCC")), FALSE);
  TEST ("s0.remove(String(\"CCC\"))", s0.remove(String("CCC")), TRUE);
  TEST ("s0.count()", s0.count(), 5);
  TEST ("s0.find(String(\"CCC\"))", s0.find(String("CCC")), FALSE);
  TEST ("s0.put(String(\"KKK\"))", s0.put(String("KKK")), TRUE);
  TEST ("s0.count()", s0.count(), 6);
  TEST ("s0.put(String(\"MMM\"))", s0.put(String("MMM")), TRUE);
  TEST ("s0.count()", s0.count(), 7);
  TEST ("s0.put(String(\"NNN\"))", s0.put(String("NNN")), TRUE);
  TEST ("s0.count()", s0.count(), 8);
  TEST ("s0.put(String(\"LLL\"))", s0.put(String("LLL")), FALSE);
  TEST ("s0.count()", s0.count(), 8);
  TEST ("s0.put(String(\"EEE\"))", s0.put(String("EEE")), TRUE);
  TEST ("s0.count()", s0.count(), 9);
  TEST ("s0.put(String(\"GGG\"))", s0.put(String("GGG")), TRUE);
  TEST ("s0.count()", s0.count(), 10);
  TEST ("s0.put(String(\"CCC\"))", s0.put(String("CCC")), TRUE);
  TEST ("s0.count()", s0.count(), 11);
  TEST ("s0.balance()", (s0.balance(), s0.count()), 11);
  TEST ("s0.find(String(\"CCC\"))", s0.find(String("CCC")), TRUE);
  TEST ("s0.find(String(\"HHH\"))", s0.find(String("HHH")), TRUE);
  TEST ("s0.find(String(\"III\"))", s0.find(String("III")), FALSE);
  TEST ("s0.find(String(\"KKK\"))", s0.find(String("KKK")), TRUE);
  TEST ("s0.find(String(\"GGG\"))", s0.find(String("GGG")), TRUE);
  TEST ("s1=s0", (s1=s0, s0.count() == s1.count()), 1);
  TEST ("s1.find(String(\"CCC\"))", s1.find(String("CCC")), TRUE);
  TEST ("s1.find(String(\"HHH\"))", s1.find(String("HHH")), TRUE);
  TEST ("s1.find(String(\"III\"))", s1.find(String("III")), FALSE);
  TEST ("s1.find(String(\"KKK\"))", s1.find(String("KKK")), TRUE);
  TEST ("s1.find(String(\"GGG\"))", s1.find(String("GGG")), TRUE);
}  

int my_strcmp (const String& s1, const String& s2) {
  return strcmp (s1, s2);
}

void test_String () {  
  Binary_Tree<String> s0;
  TEST ("Binary_Tree<String> s0", s0.count(), 0);
  TEST ("s0.set_compare(&my_strcmp)",(s0.set_compare(&my_strcmp),1),1);
  TEST ("s0.put(String(\"LLL\"))", s0.put(String("LLL")), TRUE);
  TEST ("s0.count()", s0.count(), 1);
  TEST ("s0.find(String(\"LLL\"))", s0.find(String("LLL")), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("LLL"))), 0);
  TEST ("s0.remove()", s0.remove(), TRUE);
  TEST ("s0.count()", s0.count(), 0);
  TEST ("s0.put(String(\"DDD\"))", s0.put(String("DDD")), TRUE);
  TEST ("s0.count()", s0.count(), 1);
  TEST ("s0.put(String(\"HHH\"))", s0.put(String("HHH")), TRUE);
  TEST ("s0.count()", s0.count(), 2);
  TEST ("s0.put(String(\"CCC\"))", s0.put(String("CCC")), TRUE);
  TEST ("s0.count()", s0.count(), 3);
  TEST ("s0.put(String(\"LLL\"))", s0.put(String("LLL")), TRUE);
  TEST ("s0.count()", s0.count(), 4);
  TEST ("s0.put(String(\"BBB\"))", s0.put(String("BBB")), TRUE);
  TEST ("s0.count()", s0.count(), 5);
  TEST ("s0.put(String(\"FFF\"))", s0.put(String("FFF")), TRUE);
  TEST ("s0.count()", s0.count(), 6);
  TEST ("s0.find(String(\"BBB\"))", s0.find(String("BBB")), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("BBB"))), 0);
  TEST ("s0.reset()", (s0.reset(), 1), 1);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("BBB"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("CCC"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("DDD"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("FFF"))), 0);
  TEST ("s0.prev()", s0.prev(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("DDD"))), 0);
  TEST ("s0.prev()", s0.prev(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("CCC"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("DDD"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("FFF"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("HHH"))), 0);
  TEST ("s0.next()", s0.next(), TRUE);
  TEST ("s0.value()", (strcmp (s0.value(),String("LLL"))), 0);
  TEST ("s0.count()", s0.count(), 6);
  TEST ("s0.find(String(\"JJJ\"))", s0.find(String("JJJ")), FALSE);
  test_String_2 (s0);
}

void test_equal (void) {
  Binary_Tree<int> b0, b1;
  for (int i = 0; i < 10; i++) {
    b0.put (i);
    b1.put (i);
  }
  TEST ("b0 == b1", b0 == b1, TRUE);
  b0.put (11);
  TEST ("b0 != b1", b0 != b1, TRUE);
}

int main () {
  START("Binary_Tree");
  test_int_put ();
  test_int ();
  test_charP ();
  test_String ();
  test_equal ();
  SUMMARY ();
  return 0;
}
