//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: LGO 09/19/89 -- Split into seperate files
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header

// copy_start_error -- Raise exception for Vector<Type>::copy()
// Input:              Type string, start argument
// Output:             None

void Vector::copy_start_error (const char* Type, const long start) CONST {
  RAISE (Error, SYM(Vector), SYM(Out_Of_Range),
	 "Vector<%s>::copy(): Start index %d out of range", Type, start);
}


// copy_end_error -- Raise exception for Vector<Type>::copy()
// Input:            Type string, end argument
// Output:           None

void Vector::copy_end_error (const char* Type, const long end) CONST {
  RAISE (Error, SYM(Vector), SYM(Out_Of_Range),
	 "Vector<%s>::copy(): End index %d out of range", Type, end);
}

// copy_error -- Raise exception for Vector<Type>::copy()
// Input:        Type string
// Output:       None

void Vector::copy_error (const char* Type) {
  RAISE (Error, SYM(Vector), SYM(Static_Size),
	 "Vector<%s>::copy(): Static-size vector", Type);
}
