//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <test.h>
#include <cool/misc.h>
 
int a;
int b;
int c;
int d;

KEYARGS void key_func1 (KEY: int i = 1, int j = 2, int k = 3, int l= 4) {
  a = i;
  b = j;
  c = k;
  d = l;
}

KEYARGS void key_func2 (int i = 1, KEY: int j = 2, int k = 3, int l= 4) {
  a = i;
  b = j;
  c = k;
  d = l;
}

KEYARGS void key_func3 (int i, int j = 2, KEY: int k = 3, int l= 4) {
  a = i;
  b = j;
  c = k;
  d = l;
}

// class with keywords
class mine {
public:
  int x;
  int y;
  int z;
  mine(int i, int j, int k);
  void set(int i, int j, int k);
};

KEYARGS mine::mine(KEY: int i = 1, int j = 2, int k = 3) {
  x = i;
  y = j;
  z = k;
}

KEYARGS void mine::set(int i = 1, KEY: int j = 2, int k = 3) {
  x = i;
  y = j;
  z = k;
}

int main (void) {
  START("keyargs");

  mine* my1;
  my1 = new mine();
  TEST ("X::X();", (my1->x==1 && my1->y==2, my1->z==3), 1);

  my1 = new mine(k=111,j=222,i=333);
  TEST ("X::X(k=111,j=222,i=333);",
	(my1->x==333 && my1->y==222 && my1->z==111),
	1);

  my1->set();
  TEST ("x.set();", (my1->x==1 && my1->y==2, my1->z==3), 1);

  my1->set(333, k=111,j=222);
  TEST ("x.set(333, k=111,j=222);",
	(my1->x==333 && my1->y==222 && my1->z==111),
	1);

  key_func1();
  TEST ("key_func1();", 
	(a==1 && b==2 && c==3 && d==4),
	1);

  key_func1(i=111, j=222, k=333, l=444);
  TEST ("key_func1(i=111, j=222, k=333, l=444);", 
	(a==111 && b==222 && c==333 && d==444),
	1);

  key_func1(l=111, k=222, j=333, i=444);
  TEST ("key_func1(l=111, k=222, j=333, i=444);", 
	(a==444 && b==333 && c==222 && d==111),
	1);

  key_func1(l=444, j=444);
  TEST ("key_func1(l=444, j=444);", 
	(a==1 && b==444 && c==3 && d==444),
	1);
  key_func1(i=111);
  TEST ("key_func1(i=111);", 
	(a==111 && b==2 && c==3 && d==4),
	1);

  key_func1(j=222);
  TEST ("key_func1(j=222);", 
	(a==1 && b==222 && c==3 && d==4),
	1);
  
  key_func2();
  TEST ("key_func2();", 
	(a==1 && b==2 && c==3 && d==4),
	1);

  key_func2(111);
  TEST ("key_func2(111);",
	(a==111 && b==2 && c==3 && d==4),
	1);

  key_func2(111, j=222, k=333, l=444);
  TEST ("key_func2(111, j=222, k=333, l=444);", 
	(a==111 && b==222 && c==333 && d==444),
	1);

  key_func2(444, l=111, k=222, j=333);
  TEST ("key_func2(444, l=111, k=222, j=333);", 
	(a==444 && b==333 && c==222 && d==111),
	1);

  key_func2(l=444, j=444);
  TEST ("key_func2(l=444, j=444);", 
	(a==1 && b==444 && c==3 && d==444),
	1);

  key_func2(j=222);
  TEST ("key_func2(j=222);", 
	(a==1 && b==222 && c==3 && d==4),
	1);

  key_func3(111);
  TEST ("key_func3(111);", 
	(a==111 && b==2 && c==3 && d==4),
	1);

  key_func3(444, 333);
  TEST ("key_func3(444, 333);", 
	(a==444 && b==333 && c==3 && d==4),
	1);

  key_func3(111, 222, k=333, l=444);
  TEST ("key_func3(111, 222, k=333, l=444);", 
	(a==111 && b==222 && c==333 && d==444),
	1);

  key_func3(444, 333, l=111, k=222);
  TEST ("key_func3(444, 333, l=111, k=222);", 
	(a==444 && b==333 && c==222 && d==111),
	1);

  key_func3(111, l=444);
  TEST ("key_func3(111, l=444);", 
	(a==111 && b==2 && c==3 && d==444),
	1);

  key_func3(111, k=333);
  TEST ("key_func3(111, k=333);", 
	(a==111 && b==2 && c==333 && d==4),
	1);

  SUMMARY();
  return 0;
}
